/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.client;

import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientPoolProperty;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.client.AsyncIoTConsensusServiceClient;
import org.apache.iotdb.consensus.iot.client.SyncIoTConsensusServiceClient;

public class IoTConsensusClientPool {
    private IoTConsensusClientPool() {
    }

    public static class AsyncIoTConsensusServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncIoTConsensusServiceClient> {
        private final IoTConsensusConfig config;
        private static final String IOT_CONSENSUS_CLIENT_POOL_THREAD_NAME = "IoTConsensusClientPool";

        public AsyncIoTConsensusServiceClientPoolFactory(IoTConsensusConfig config) {
            this.config = config;
        }

        public KeyedObjectPool<TEndPoint, AsyncIoTConsensusServiceClient> createClientPool(ClientManager<TEndPoint, AsyncIoTConsensusServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncIoTConsensusServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(this.config.getRpc().getConnectionTimeoutInMs()).setRpcThriftCompressionEnabled(this.config.getRpc().isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(this.config.getRpc().getSelectorNumOfClientManager()).build(), IOT_CONSENSUS_CLIENT_POOL_THREAD_NAME), new ClientPoolProperty.Builder().setMaxIdleClientForEachNode(this.config.getRpc().getMaxConnectionForInternalService()).setMaxTotalClientForEachNode(this.config.getRpc().getMaxConnectionForInternalService()).build().getConfig());
        }
    }

    public static class SyncIoTConsensusServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncIoTConsensusServiceClient> {
        private final IoTConsensusConfig config;

        public SyncIoTConsensusServiceClientPoolFactory(IoTConsensusConfig config) {
            this.config = config;
        }

        public KeyedObjectPool<TEndPoint, SyncIoTConsensusServiceClient> createClientPool(ClientManager<TEndPoint, SyncIoTConsensusServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncIoTConsensusServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(this.config.getRpc().getConnectionTimeoutInMs()).setRpcThriftCompressionEnabled(this.config.getRpc().isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(this.config.getRpc().getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }
}

