/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.client;

import java.util.concurrent.CompletableFuture;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.iot.logdispatcher.Batch;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcher;
import org.apache.iotdb.consensus.iot.thrift.TSyncLogEntriesRes;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchLogHandler
implements AsyncMethodCallback<TSyncLogEntriesRes> {
    private final Logger logger = LoggerFactory.getLogger(DispatchLogHandler.class);
    private final LogDispatcher.LogDispatcherThread thread;
    private final Batch batch;
    private final long createTime;
    private int retryCount;

    public DispatchLogHandler(LogDispatcher.LogDispatcherThread thread, Batch batch) {
        this.thread = thread;
        this.batch = batch;
        this.createTime = System.currentTimeMillis();
    }

    public void onComplete(TSyncLogEntriesRes response) {
        if (response.getStatuses().size() == 1 && this.needRetry(((TSStatus)response.getStatuses().get(0)).getCode())) {
            this.logger.warn("Can not send {} to peer {} for {} times because {}", new Object[]{this.batch, this.thread.getPeer(), ++this.retryCount, ((TSStatus)response.getStatuses().get(0)).getMessage()});
            this.sleepCorrespondingTimeAndRetryAsynchronous();
        } else {
            this.thread.getSyncStatus().removeBatch(this.batch);
            this.thread.updateSafelyDeletedSearchIndex();
        }
        MetricService.getInstance().getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "syncLogTimePerRequest", Tag.REGION.toString(), this.thread.getPeer().getGroupId().toString()}).update((System.currentTimeMillis() - this.createTime) / (long)this.batch.getLogEntries().size());
    }

    private boolean needRetry(int statusCode) {
        return statusCode == TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode() || statusCode == TSStatusCode.SYSTEM_READ_ONLY.getStatusCode() || statusCode == TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode();
    }

    public void onError(Exception exception) {
        this.logger.warn("Can not send {} to peer for {} times {} because {}", new Object[]{this.batch, this.thread.getPeer(), ++this.retryCount, exception});
        this.sleepCorrespondingTimeAndRetryAsynchronous();
    }

    private void sleepCorrespondingTimeAndRetryAsynchronous() {
        CompletableFuture.runAsync(() -> {
            try {
                long defaultSleepTime = (long)((double)this.thread.getConfig().getReplication().getBasicRetryWaitTimeMs() * Math.pow(2.0, this.retryCount));
                Thread.sleep(Math.min(defaultSleepTime, this.thread.getConfig().getReplication().getMaxRetryWaitTimeMs()));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn("Unexpected interruption during retry pending batch");
            }
            if (this.thread.isStopped()) {
                this.logger.debug("LogDispatcherThread {} has been stopped, we will not retrying this Batch {} after {} times", new Object[]{this.thread.getPeer(), this.batch, this.retryCount});
            } else {
                this.thread.sendBatchAsync(this.batch, this);
            }
        });
    }
}

