/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.iotdb.db.engine.flush.MemTableFlushTask;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.exception.WALRecoverException;
import org.apache.iotdb.db.wal.recover.file.AbstractTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.recover.file.TsFilePlanRedoer;
import org.apache.iotdb.db.wal.utils.listener.WALRecoverListener;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsealedTsFileRecoverPerformer
extends AbstractTsFileRecoverPerformer {
    private static final Logger logger = LoggerFactory.getLogger(UnsealedTsFileRecoverPerformer.class);
    private final boolean sequence;
    private final Consumer<UnsealedTsFileRecoverPerformer> callbackAfterUnsealedTsFileRecovered;
    private final TsFilePlanRedoer walRedoer;
    private final WALRecoverListener recoverListener;

    public UnsealedTsFileRecoverPerformer(TsFileResource tsFileResource, boolean sequence, IDTable idTable, Consumer<UnsealedTsFileRecoverPerformer> callbackAfterUnsealedTsFileRecovered) {
        super(tsFileResource);
        this.sequence = sequence;
        this.callbackAfterUnsealedTsFileRecovered = callbackAfterUnsealedTsFileRecovered;
        this.walRedoer = new TsFilePlanRedoer(tsFileResource, sequence, idTable);
        this.recoverListener = new WALRecoverListener(tsFileResource.getTsFilePath());
    }

    public void startRecovery() throws DataRegionException, IOException {
        super.recoverWithWriter();
        if (this.hasCrashed()) {
            this.constructResourceFromTsFile();
        }
    }

    private void constructResourceFromTsFile() {
        Map<String, Map<String, List<Deletion>>> modificationsForResource = this.loadModificationsForResource();
        Map deviceChunkMetaDataMap = this.writer.getDeviceChunkMetadataMap();
        for (Map.Entry entry : deviceChunkMetaDataMap.entrySet()) {
            String deviceId = (String)entry.getKey();
            List chunkMetadataList = (List)entry.getValue();
            HashMap<String, List> measurementToChunkMetadatas = new HashMap<String, List>();
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                List list = measurementToChunkMetadatas.computeIfAbsent(chunkMetadata.getMeasurementUid(), n -> new ArrayList());
                list.add(chunkMetadata);
            }
            for (List metadataList : measurementToChunkMetadatas.values()) {
                TSDataType dataType = ((ChunkMetadata)metadataList.get(metadataList.size() - 1)).getDataType();
                for (ChunkMetadata chunkMetaData : chunkMetadataList) {
                    if (!chunkMetaData.getDataType().equals((Object)dataType)) continue;
                    long startTime = chunkMetaData.getStartTime();
                    long endTime = chunkMetaData.getEndTime();
                    long chunkHeaderOffset = chunkMetaData.getOffsetOfChunkHeader();
                    if (modificationsForResource.containsKey(deviceId) && modificationsForResource.get(deviceId).containsKey(chunkMetaData.getMeasurementUid())) {
                        for (Deletion modification : modificationsForResource.get(deviceId).get(chunkMetaData.getMeasurementUid())) {
                            long fileOffset = modification.getFileOffset();
                            if (chunkHeaderOffset >= fileOffset) continue;
                            long modsStartTime = modification.getStartTime();
                            long modsEndTime = modification.getEndTime();
                            if (startTime >= modsStartTime && endTime <= modsEndTime) {
                                startTime = Long.MAX_VALUE;
                                endTime = Long.MIN_VALUE;
                                continue;
                            }
                            if (startTime >= modsStartTime && startTime <= modsEndTime) {
                                startTime = modsEndTime + 1L;
                                continue;
                            }
                            if (endTime < modsStartTime || endTime > modsEndTime) continue;
                            endTime = modsStartTime - 1L;
                        }
                    }
                    this.tsFileResource.updateStartTime(deviceId, startTime);
                    this.tsFileResource.updateEndTime(deviceId, endTime);
                }
            }
        }
        this.tsFileResource.updatePlanIndexes(this.writer.getMinPlanIndex());
        this.tsFileResource.updatePlanIndexes(this.writer.getMaxPlanIndex());
    }

    private Map<String, Map<String, List<Deletion>>> loadModificationsForResource() {
        HashMap<String, Map<String, List<Deletion>>> modificationsForResource = new HashMap<String, Map<String, List<Deletion>>>();
        ModificationFile modificationFile = this.tsFileResource.getModFile();
        if (modificationFile.exists()) {
            List modifications = (List)modificationFile.getModifications();
            for (Modification modification : modifications) {
                if (!modification.getType().equals((Object)Modification.Type.DELETION)) continue;
                String deviceId = modification.getPath().getDevice();
                String measurementId = modification.getPath().getMeasurement();
                Map measurementModsMap = modificationsForResource.computeIfAbsent(deviceId, n -> new HashMap());
                List list = measurementModsMap.computeIfAbsent(measurementId, n -> new ArrayList());
                list.add((Deletion)modification);
            }
        }
        return modificationsForResource;
    }

    public void redoLog(WALEntry walEntry) {
        if (!this.hasCrashed()) {
            logger.info("This TsFile {} isn't crashed, no need to redo wal log.", (Object)this.tsFileResource.getTsFilePath());
            return;
        }
        try {
            switch (walEntry.getType()) {
                case MEMORY_TABLE_SNAPSHOT: {
                    IMemTable memTable = (IMemTable)walEntry.getValue();
                    if (!memTable.isSignalMemTable()) {
                        this.walRedoer.resetRecoveryMemTable(memTable);
                    }
                    break;
                }
                case INSERT_ROW_NODE: 
                case INSERT_TABLET_NODE: {
                    this.walRedoer.redoInsert((InsertNode)((Object)walEntry.getValue()));
                    break;
                }
                case DELETE_DATA_NODE: {
                    this.walRedoer.redoDelete((DeleteDataNode)walEntry.getValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type " + (Object)((Object)walEntry.getType()));
                }
            }
        }
        catch (Exception e) {
            logger.warn("meet error when redo wal of {}", (Object)this.tsFileResource.getTsFile(), (Object)e);
        }
    }

    public void endRecovery() throws WALRecoverException {
        if (this.hasCrashed()) {
            IMemTable recoveryMemTable = this.walRedoer.getRecoveryMemTable();
            Map<IDeviceID, IWritableMemChunkGroup> memTableMap = recoveryMemTable.getMemTableMap();
            for (Map.Entry<IDeviceID, IWritableMemChunkGroup> deviceEntry : memTableMap.entrySet()) {
                String deviceId = deviceEntry.getKey().toStringID();
                for (Map.Entry<String, IWritableMemChunk> measurementEntry : deviceEntry.getValue().getMemChunkMap().entrySet()) {
                    IWritableMemChunk memChunk = measurementEntry.getValue();
                    this.tsFileResource.updateStartTime(deviceId, memChunk.getFirstPoint());
                    this.tsFileResource.updateEndTime(deviceId, memChunk.getLastPoint());
                }
            }
            try {
                if (!recoveryMemTable.isEmpty() && recoveryMemTable.getSeriesNumber() != 0) {
                    String dataRegionId = this.tsFileResource.getTsFile().getParentFile().getParentFile().getName();
                    String databaseName = this.tsFileResource.getTsFile().getParentFile().getParentFile().getParentFile().getName();
                    MemTableFlushTask tableFlushTask = new MemTableFlushTask(recoveryMemTable, this.writer, databaseName + "-" + dataRegionId);
                    tableFlushTask.syncFlushMemTable();
                    this.tsFileResource.updatePlanIndexes(recoveryMemTable.getMinPlanIndex());
                    this.tsFileResource.updatePlanIndexes(recoveryMemTable.getMaxPlanIndex());
                }
                this.writer.endFile();
                this.tsFileResource.serialize();
            }
            catch (IOException | ExecutionException e) {
                throw new WALRecoverException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WALRecoverException(e);
            }
        }
        this.callbackAfterUnsealedTsFileRecovered.accept(this);
    }

    public TsFileResource getTsFileResource() {
        return this.tsFileResource;
    }

    public RestorableTsFileIOWriter getWriter() {
        return this.writer;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public WALRecoverListener getRecoverListener() {
        return this.recoverListener;
    }

    public String getTsFileAbsolutePath() {
        return this.tsFileResource.getTsFile().getAbsolutePath();
    }
}

