/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.wal.checkpoint.Checkpoint;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.io.CheckpointReader;
import org.apache.iotdb.db.wal.utils.CheckpointFileUtils;

public class CheckpointRecoverUtils {
    private CheckpointRecoverUtils() {
    }

    public static CheckpointInfo recoverMemTableInfo(File logDirectory) {
        File[] checkpointFiles = CheckpointFileUtils.listAllCheckpointFiles(logDirectory);
        if (checkpointFiles == null) {
            return new CheckpointInfo(0L, Collections.emptyMap());
        }
        CheckpointFileUtils.descSortByVersionId(checkpointFiles);
        long maxMemTableId = 0L;
        List<Checkpoint> checkpoints = null;
        for (File checkpointFile : checkpointFiles) {
            CheckpointReader reader = new CheckpointReader(checkpointFile);
            maxMemTableId = reader.getMaxMemTableId();
            checkpoints = reader.getCheckpoints();
            if (!checkpoints.isEmpty()) break;
        }
        if (checkpoints == null || checkpoints.isEmpty()) {
            return new CheckpointInfo(0L, Collections.emptyMap());
        }
        HashMap<Long, MemTableInfo> memTableId2Info = new HashMap<Long, MemTableInfo>();
        block5: for (Checkpoint checkpoint : checkpoints) {
            switch (checkpoint.getType()) {
                case GLOBAL_MEMORY_TABLE_INFO: 
                case CREATE_MEMORY_TABLE: {
                    for (MemTableInfo memTableInfo : checkpoint.getMemTableInfos()) {
                        maxMemTableId = Math.max(maxMemTableId, memTableInfo.getMemTableId());
                        memTableId2Info.put(memTableInfo.getMemTableId(), memTableInfo);
                    }
                    continue block5;
                }
                case FLUSH_MEMORY_TABLE: {
                    for (MemTableInfo memTableInfo : checkpoint.getMemTableInfos()) {
                        memTableId2Info.remove(memTableInfo.getMemTableId());
                    }
                    break;
                }
            }
        }
        return new CheckpointInfo(maxMemTableId, memTableId2Info);
    }

    public static class CheckpointInfo {
        private final long maxMemTableId;
        private final Map<Long, MemTableInfo> memTableId2Info;

        public CheckpointInfo(long maxMemTableId, Map<Long, MemTableInfo> memTableId2Info) {
            this.maxMemTableId = maxMemTableId;
            this.memTableId2Info = memTableId2Info;
        }

        public long getMaxMemTableId() {
            return this.maxMemTableId;
        }

        public Map<Long, MemTableInfo> getMemTableId2Info() {
            return this.memTableId2Info;
        }
    }
}

