/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.buffer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.buffer.IWALBuffer;
import org.apache.iotdb.db.wal.io.WALWriter;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWALBuffer
implements IWALBuffer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWALBuffer.class);
    protected final String identifier;
    protected final String logDirectory;
    protected final AtomicLong currentWALFileVersion = new AtomicLong();
    protected volatile long currentSearchIndex;
    protected volatile WALWriter currentWALFileWriter;

    public AbstractWALBuffer(String identifier, String logDirectory, long startFileVersion, long startSearchIndex) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = logDirectory;
        File logDirFile = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!logDirFile.exists() && logDirFile.mkdirs()) {
            logger.info("Create folder {} for wal node-{}'s buffer.", (Object)logDirectory, (Object)identifier);
        }
        this.currentSearchIndex = startSearchIndex;
        this.currentWALFileVersion.set(startFileVersion);
        this.currentWALFileWriter = new WALWriter(SystemFileFactory.INSTANCE.getFile(logDirectory, WALFileUtils.getLogFileName(this.currentWALFileVersion.get(), this.currentSearchIndex, WALFileStatus.CONTAINS_SEARCH_INDEX)));
    }

    @Override
    public long getCurrentWALFileVersion() {
        return this.currentWALFileVersion.get();
    }

    @Override
    public long getCurrentWALFileSize() {
        return this.currentWALFileWriter.size();
    }

    protected void rollLogWriter(long searchIndex, WALFileStatus fileStatus) throws IOException {
        String targetName;
        File currentFile = this.currentWALFileWriter.getLogFile();
        String currentName = currentFile.getName();
        this.currentWALFileWriter.close();
        WALManager.getInstance().addTotalDiskUsage(this.currentWALFileWriter.size());
        WALManager.getInstance().addTotalFileNum(1L);
        if (WALFileUtils.parseStatusCode(currentName) != fileStatus && !currentFile.renameTo(SystemFileFactory.INSTANCE.getFile(this.logDirectory, targetName = WALFileUtils.getLogFileName(WALFileUtils.parseVersionId(currentName), WALFileUtils.parseStartSearchIndex(currentName), fileStatus)))) {
            logger.error("Fail to rename file {} to {}", (Object)currentName, (Object)targetName);
        }
        File nextLogFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, WALFileUtils.getLogFileName(this.currentWALFileVersion.incrementAndGet(), searchIndex, WALFileStatus.CONTAINS_SEARCH_INDEX));
        this.currentWALFileWriter = new WALWriter(nextLogFile);
        logger.debug("Open new wal file {} for wal node-{}'s buffer.", (Object)nextLogFile, (Object)this.identifier);
    }

    @Override
    public long getCurrentSearchIndex() {
        return this.currentSearchIndex;
    }
}

