/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.service;

import java.io.IOException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.trigger.service.TriggerClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerClassLoaderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerClassLoaderManager.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final String libRoot;
    private volatile TriggerClassLoader activeClassLoader;

    private TriggerClassLoaderManager(String libRoot) throws IOException {
        this.libRoot = libRoot;
        LOGGER.info("Trigger lib root: {}", (Object)libRoot);
        this.activeClassLoader = new TriggerClassLoader(libRoot);
    }

    public TriggerClassLoader updateAndGetActiveClassLoader() throws IOException {
        TriggerClassLoader deprecatedClassLoader = this.activeClassLoader;
        this.activeClassLoader = new TriggerClassLoader(this.libRoot);
        deprecatedClassLoader.close();
        return this.activeClassLoader;
    }

    public TriggerClassLoader getActiveClassLoader() {
        return this.activeClassLoader;
    }

    public static TriggerClassLoaderManager getInstance() {
        return TriggerClassLoaderManagerHolder.INSTANCE;
    }

    private static class TriggerClassLoaderManagerHolder {
        private static final TriggerClassLoaderManager INSTANCE;

        private TriggerClassLoaderManagerHolder() {
        }

        static {
            try {
                SystemFileFactory.INSTANCE.makeDirIfNecessary(CONFIG.getTriggerDir());
                INSTANCE = new TriggerClassLoaderManager(CONFIG.getTriggerDir());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

