/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.pipe;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.TsFilePipeInfo;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.sync.pipedata.DeletionPipeData;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.pipedata.queue.BufferedPipeDataQueue;
import org.apache.iotdb.db.sync.pipedata.queue.PipeDataQueue;
import org.apache.iotdb.db.sync.sender.manager.ISyncManager;
import org.apache.iotdb.db.sync.sender.manager.LocalSyncManager;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.recovery.TsFilePipeLogger;
import org.apache.iotdb.db.sync.transport.client.SenderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFilePipe
implements Pipe {
    private static final Logger logger = LoggerFactory.getLogger(TsFilePipe.class);
    private final Map<String, ISyncManager> syncManagerMap = new ConcurrentHashMap<String, ISyncManager>();
    private final TsFilePipeInfo pipeInfo;
    private final PipeSink pipeSink;
    private final Map<String, PipeDataQueue> historyQueueMap = new ConcurrentHashMap<String, PipeDataQueue>();
    private final Map<String, PipeDataQueue> realTimeQueueMap = new ConcurrentHashMap<String, PipeDataQueue>();
    private final TsFilePipeLogger pipeLog;
    private final ReentrantLock collectRealTimeDataLock;
    private final SenderManager senderManager;
    private boolean isCollectFinished;
    private final ReentrantReadWriteLock isCollectFinishedReadWriteLock = new ReentrantReadWriteLock(false);
    private AtomicLong maxSerialNumber;

    public TsFilePipe(long createTime, String name, PipeSink pipeSink, long dataStartTime, boolean syncDelOp) {
        this.pipeInfo = new TsFilePipeInfo(name, pipeSink.getPipeSinkName(), PipeStatus.STOP, createTime, dataStartTime, syncDelOp);
        this.pipeSink = pipeSink;
        this.pipeLog = new TsFilePipeLogger(this);
        this.isCollectFinished = this.pipeLog.isCollectFinished();
        this.collectRealTimeDataLock = new ReentrantLock();
        this.senderManager = new SenderManager(this, pipeSink);
        this.maxSerialNumber = new AtomicLong(0L);
        this.recover();
    }

    private void recover() {
        String dataRegionId;
        File[] fileList;
        File dir = new File(SyncPathUtil.getSenderHistoryPipeLogDir((String)this.pipeInfo.getPipeName(), (long)this.pipeInfo.getCreateTime()));
        if (dir.exists()) {
            for (File file : fileList = dir.listFiles()) {
                dataRegionId = file.getName();
                BufferedPipeDataQueue historyQueue = new BufferedPipeDataQueue(SyncPathUtil.getSenderDataRegionHistoryPipeLogDir((String)this.pipeInfo.getPipeName(), (long)this.pipeInfo.getCreateTime(), (String)dataRegionId));
                this.historyQueueMap.put(dataRegionId, historyQueue);
            }
        }
        if ((dir = new File(SyncPathUtil.getSenderRealTimePipeLogDir((String)this.pipeInfo.getPipeName(), (long)this.pipeInfo.getCreateTime()))).exists()) {
            for (File file : fileList = dir.listFiles()) {
                dataRegionId = file.getName();
                BufferedPipeDataQueue realTimeQueue = new BufferedPipeDataQueue(SyncPathUtil.getSenderDataRegionRealTimePipeLogDir((String)this.pipeInfo.getPipeName(), (long)this.pipeInfo.getCreateTime(), (String)dataRegionId));
                this.realTimeQueueMap.put(dataRegionId, realTimeQueue);
                this.maxSerialNumber.set(Math.max(this.maxSerialNumber.get(), realTimeQueue.getLastMaxSerialNumber()));
            }
        }
    }

    @Override
    public synchronized void start() throws PipeException {
        if (this.pipeInfo.getStatus() == PipeStatus.RUNNING) {
            return;
        }
        this.senderManager.checkConnection();
        List<DataRegion> dataRegions = StorageEngineV2.getInstance().getAllDataRegions();
        for (DataRegion dataRegion : dataRegions) {
            logger.info(this.logFormat("init syncManager for %s-%s", dataRegion.getDatabaseName(), dataRegion.getDataRegionId()));
            this.getOrCreateSyncManager(dataRegion.getDataRegionId());
        }
        try {
            this.isCollectFinishedReadWriteLock.writeLock().lock();
            if (!this.isCollectFinished) {
                this.pipeLog.clear();
                this.collectHistoryData();
                this.pipeLog.finishCollect();
                this.isCollectFinished = true;
            }
            this.pipeInfo.setStatus(PipeStatus.RUNNING);
            this.senderManager.start();
        }
        catch (IOException e) {
            logger.error(this.logFormat("Clear pipe dir %s error.", SyncPathUtil.getSenderPipeDir((String)this.pipeInfo.getPipeName(), (long)this.pipeInfo.getCreateTime())), (Throwable)e);
            throw new PipeException("Start error, can not clear pipe log.");
        }
        finally {
            this.isCollectFinishedReadWriteLock.writeLock().unlock();
        }
    }

    private void collectHistoryData() {
        for (Map.Entry<String, ISyncManager> entry : this.syncManagerMap.entrySet()) {
            List<File> historyTsFiles = entry.getValue().syncHistoryTsFile(this.pipeInfo.getDataStartTimestamp());
            int historyTsFilesSize = historyTsFiles.size();
            for (int i = 0; i < historyTsFilesSize; ++i) {
                long serialNumber = 1 - historyTsFilesSize + i;
                File tsFile = historyTsFiles.get(i);
                this.historyQueueMap.get(entry.getKey()).offer(new TsFilePipeData(tsFile.getParent(), tsFile.getName(), serialNumber));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createHistoryTsFileHardlink(File tsFile, long modsOffset) {
        this.collectRealTimeDataLock.lock();
        try {
            if (this.pipeLog.isHardlinkExist(tsFile)) {
                File file = null;
                return file;
            }
            File file = this.pipeLog.createTsFileAndModsHardlink(tsFile, modsOffset);
            return file;
        }
        catch (IOException e) {
            logger.error(this.logFormat("Create hardlink for history tsfile %s error.", tsFile.getPath()), (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            this.collectRealTimeDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectRealTimeDeletion(Deletion deletion, String sgName, String dataRegionId) {
        this.collectRealTimeDataLock.lock();
        try {
            if (!this.pipeInfo.isSyncDelOp()) {
                return;
            }
            for (PartialPath deletePath : LocalSyncManager.splitPathPatternByDevice(deletion.getPath())) {
                Deletion splitDeletion = new Deletion(deletePath, deletion.getFileOffset(), deletion.getStartTime(), deletion.getEndTime());
                DeletionPipeData deletionData = new DeletionPipeData(sgName, splitDeletion, this.maxSerialNumber.incrementAndGet());
                this.realTimeQueueMap.get(dataRegionId).offer(deletionData);
            }
        }
        catch (MetadataException e) {
            logger.warn(this.logFormat("Collect deletion %s error.", deletion), (Throwable)e);
        }
        finally {
            this.collectRealTimeDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectRealTimeTsFile(File tsFile, String dataRegionId) {
        this.collectRealTimeDataLock.lock();
        try {
            if (this.pipeLog.isHardlinkExist(tsFile)) {
                return;
            }
            File hardlink = this.pipeLog.createTsFileHardlink(tsFile);
            TsFilePipeData tsFileData = new TsFilePipeData(hardlink.getParent(), hardlink.getName(), this.maxSerialNumber.incrementAndGet());
            this.realTimeQueueMap.get(dataRegionId).offer(tsFileData);
        }
        catch (IOException e) {
            logger.warn(this.logFormat("Create Hardlink tsfile %s on disk error, serial number is %d.", tsFile.getPath(), this.maxSerialNumber), (Throwable)e);
        }
        finally {
            this.collectRealTimeDataLock.unlock();
        }
    }

    public void collectRealTimeResource(File tsFile) {
        try {
            this.pipeLog.createTsFileResourceHardlink(tsFile);
        }
        catch (IOException e) {
            logger.warn(this.logFormat("Record tsfile resource %s on disk error.", tsFile.getPath()), (Throwable)e);
        }
    }

    @Override
    public PipeData take(String dataRegionId) throws InterruptedException {
        if (!this.historyQueueMap.get(dataRegionId).isEmpty()) {
            return this.historyQueueMap.get(dataRegionId).take();
        }
        return this.realTimeQueueMap.get(dataRegionId).take();
    }

    public List<PipeData> pull(long serialNumber) {
        ArrayList<PipeData> pullPipeData = new ArrayList<PipeData>();
        for (PipeDataQueue historyQueue : this.historyQueueMap.values()) {
            if (historyQueue.isEmpty()) continue;
            pullPipeData.addAll(historyQueue.pull(serialNumber));
        }
        for (PipeDataQueue realTimeQueue : this.realTimeQueueMap.values()) {
            if (serialNumber <= 0L) continue;
            pullPipeData.addAll(realTimeQueue.pull(serialNumber));
        }
        return pullPipeData;
    }

    @Override
    public void commit(String dataRegionId) {
        if (!this.historyQueueMap.get(dataRegionId).isEmpty()) {
            this.historyQueueMap.get(dataRegionId).commit();
        }
        this.realTimeQueueMap.get(dataRegionId).commit();
    }

    @Override
    public ISyncManager getOrCreateSyncManager(String dataRegionId) {
        return this.syncManagerMap.computeIfAbsent(dataRegionId, id -> {
            this.registerDataRegion((String)id);
            return new LocalSyncManager(StorageEngineV2.getInstance().getDataRegion(new DataRegionId(Integer.parseInt(id))), this);
        });
    }

    private void registerDataRegion(String dataRegionId) {
        this.historyQueueMap.put(dataRegionId, new BufferedPipeDataQueue(SyncPathUtil.getSenderDataRegionHistoryPipeLogDir((String)this.pipeInfo.getPipeName(), (long)this.pipeInfo.getCreateTime(), (String)dataRegionId)));
        this.realTimeQueueMap.put(dataRegionId, new BufferedPipeDataQueue(SyncPathUtil.getSenderDataRegionRealTimePipeLogDir((String)this.pipeInfo.getPipeName(), (long)this.pipeInfo.getCreateTime(), (String)dataRegionId)));
        this.senderManager.registerDataRegion(dataRegionId);
    }

    @Override
    public void unregisterDataRegion(String dataRegionId) {
        ISyncManager syncManager = this.syncManagerMap.remove(dataRegionId);
        if (syncManager != null) {
            syncManager.delete();
            this.senderManager.unregisterDataRegion(dataRegionId);
            this.realTimeQueueMap.remove(dataRegionId).clear();
            this.historyQueueMap.remove(dataRegionId).clear();
        }
    }

    @Override
    public boolean isHistoryCollectFinished() {
        try {
            this.isCollectFinishedReadWriteLock.readLock().lock();
            boolean bl = this.isCollectFinished;
            return bl;
        }
        finally {
            this.isCollectFinishedReadWriteLock.readLock().unlock();
        }
    }

    @Override
    public PipeInfo getPipeInfo() {
        return this.pipeInfo;
    }

    public void commit(long serialNumber) {
        for (PipeDataQueue historyQueue : this.historyQueueMap.values()) {
            if (historyQueue.isEmpty()) continue;
            historyQueue.commit(serialNumber);
        }
        for (PipeDataQueue realTimeQueue : this.realTimeQueueMap.values()) {
            if (serialNumber <= 0L) continue;
            realTimeQueue.commit(serialNumber);
        }
    }

    @Override
    public synchronized void stop() throws PipeException {
        this.senderManager.stop();
        this.pipeInfo.setStatus(PipeStatus.STOP);
    }

    @Override
    public synchronized void drop() throws PipeException {
        this.close();
        this.clear();
    }

    private void clear() {
        try {
            this.historyQueueMap.values().forEach(PipeDataQueue::clear);
            this.realTimeQueueMap.values().forEach(PipeDataQueue::clear);
            this.pipeLog.clear();
        }
        catch (IOException e) {
            logger.warn(this.logFormat("Clear pipe %s %d error.", this.pipeInfo.getPipeName(), this.pipeInfo.getCreateTime()), (Throwable)e);
        }
    }

    private String logFormat(String format, Object ... arguments) {
        return String.format(String.format("[%s-%s] ", this.pipeInfo.getPipeName(), this.pipeInfo.getCreateTime()) + format, arguments);
    }

    @Override
    public void close() throws PipeException {
        this.historyQueueMap.values().forEach(PipeDataQueue::close);
        this.realTimeQueueMap.values().forEach(PipeDataQueue::close);
        this.senderManager.close();
    }

    @Override
    public String getName() {
        return this.pipeInfo.getPipeName();
    }

    @Override
    public PipeSink getPipeSink() {
        return this.pipeSink;
    }

    @Override
    public long getCreateTime() {
        return this.pipeInfo.getCreateTime();
    }

    @Override
    public PipeStatus getStatus() {
        return this.pipeInfo.getStatus();
    }

    public String toString() {
        return "TsFilePipe{, pipeInfo=" + this.pipeInfo + ", pipeSink=" + this.pipeSink + ", pipeLog=" + this.pipeLog + ", collectRealTimeDataLock=" + this.collectRealTimeDataLock + ", maxSerialNumber=" + this.maxSerialNumber + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFilePipe that = (TsFilePipe)o;
        return Objects.equals(this.pipeInfo, that.pipeInfo) && Objects.equals(this.pipeSink, that.pipeSink);
    }

    public int hashCode() {
        return Objects.hash(this.pipeInfo, this.pipeSink);
    }

    @Override
    public SenderManager getSenderManager() {
        return this.senderManager;
    }
}

