/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.sync.datasource.AbstractOpBlock;
import org.apache.iotdb.db.sync.datasource.DeletionGroup;
import org.apache.iotdb.db.sync.externalpipe.operation.InsertOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileOpBlock
extends AbstractOpBlock {
    private static final Logger logger = LoggerFactory.getLogger(TsFileOpBlock.class);
    private String tsFileName;
    private String modsFileName;
    private TsFileFullReader tsFileFullSeqReader;
    private Map<Long, Pair<Path, TimeseriesMetadata>> fullTsMetadataMap;
    private TreeMap<Long, ChunkInfo> indexToChunkInfoMap;
    Collection<Modification> modificationList;
    private Map<String, DeletionGroup> fullPathToDeletionMap;
    private LRUCache<Long, List<TimeValuePair>> pageCache;
    private boolean dataReady = false;
    Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);

    public TsFileOpBlock(String sg, String tsFileName, long pipeDataSerialNumber) throws IOException {
        this(sg, tsFileName, pipeDataSerialNumber, 0L);
    }

    public TsFileOpBlock(String sg, String tsFileName, long pipeDataSerialNumber, long beginIndex) throws IOException {
        this(sg, tsFileName, null, pipeDataSerialNumber, beginIndex);
    }

    public TsFileOpBlock(String sg, String tsFileName, String modsFileName, long pipeDataSerialNumber) throws IOException {
        this(sg, tsFileName, modsFileName, pipeDataSerialNumber, 0L);
    }

    public TsFileOpBlock(String sg, String tsFileName, String modsFileName, long pipeDataSerialNumber, long beginIndex) throws IOException {
        super(sg, pipeDataSerialNumber, beginIndex);
        this.tsFileName = tsFileName;
        this.modsFileName = null;
        if (modsFileName != null && new File(modsFileName).exists()) {
            this.modsFileName = modsFileName;
        }
        this.pageCache = new LRUCache<Long, List<TimeValuePair>>(5){

            public List<TimeValuePair> loadObjectByKey(Long key) throws IOException {
                return null;
            }
        };
        this.calculateDataCount();
    }

    private void calculateDataCount() throws IOException {
        this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        this.dataCount = 0L;
        for (String device : this.tsFileFullSeqReader.getAllDevices()) {
            Map deviceMetaData = this.tsFileFullSeqReader.readDeviceMetadata(device);
            long countInDevice = 0L;
            for (TimeseriesMetadata tsMetaData : deviceMetaData.values()) {
                if (tsMetaData.getTSDataType() == TSDataType.VECTOR) {
                    countInDevice = tsMetaData.getStatistics().getCount() * (long)(deviceMetaData.size() - 1);
                    break;
                }
                countInDevice += tsMetaData.getStatistics().getCount();
            }
            this.dataCount += countInDevice;
        }
        this.tsFileFullSeqReader.close();
        this.tsFileFullSeqReader = null;
        this.fullTsMetadataMap = null;
    }

    @Override
    public long getDataCount() {
        return this.dataCount;
    }

    private DeletionGroup.DeletedType checkDeletedState(String measurementPath, long startTime, long endTime) {
        DeletionGroup deletionGroup = this.getFullPathDeletion(measurementPath);
        if (deletionGroup == null) {
            return DeletionGroup.DeletedType.NO_DELETED;
        }
        return deletionGroup.checkDeletedState(startTime, endTime);
    }

    private void buildIndexToChunkMap() throws IOException {
        if (this.tsFileFullSeqReader == null) {
            this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        }
        if (this.fullTsMetadataMap == null) {
            this.fullTsMetadataMap = this.tsFileFullSeqReader.getAllTimeseriesMeta(true);
        }
        TreeMap offsetToChunkInfoMap = new TreeMap();
        TreeMap<Long, ChunkInfo> tmpOffsetToChunkInfoMap = new TreeMap<Long, ChunkInfo>();
        for (String device : this.tsFileFullSeqReader.getAllDevices()) {
            Map chunkMetadataMap = this.tsFileFullSeqReader.readChunkMetadataInDevice(device);
            tmpOffsetToChunkInfoMap.clear();
            boolean isTimeAlignedDevice = false;
            for (List chunkMetadataList : chunkMetadataMap.values()) {
                for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                    ChunkInfo chunkInfo = new ChunkInfo();
                    chunkInfo.measurementFullPath = new Path(device, chunkMetadata.getMeasurementUid(), true).getFullPath();
                    chunkInfo.chunkOffsetInFile = chunkMetadata.getOffsetOfChunkHeader();
                    chunkInfo.pointCount = chunkMetadata.getStatistics().getCount();
                    if (chunkMetadata.getDataType() == TSDataType.VECTOR) {
                        isTimeAlignedDevice = true;
                        chunkInfo.isTimeAligned = true;
                    } else {
                        chunkInfo.deletedFlag = this.checkDeletedState(chunkInfo.measurementFullPath, chunkMetadata.getStatistics().getStartTime(), chunkMetadata.getStatistics().getEndTime());
                    }
                    tmpOffsetToChunkInfoMap.put(chunkInfo.chunkOffsetInFile, chunkInfo);
                }
            }
            if (isTimeAlignedDevice) {
                long timeChunkOffset = -1L;
                long timeChunkPointCount = 0L;
                Iterator iter = tmpOffsetToChunkInfoMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    ChunkInfo chunkInfo = (ChunkInfo)entry.getValue();
                    if (chunkInfo.isTimeAligned) {
                        timeChunkOffset = (Long)entry.getKey();
                        timeChunkPointCount = chunkInfo.pointCount;
                        iter.remove();
                        continue;
                    }
                    chunkInfo.isTimeAligned = true;
                    chunkInfo.timeChunkOffsetInFile = timeChunkOffset;
                    chunkInfo.pointCount = timeChunkPointCount;
                }
            }
            offsetToChunkInfoMap.putAll(tmpOffsetToChunkInfoMap);
        }
        this.indexToChunkInfoMap = new TreeMap();
        long indexInFile = 0L;
        for (ChunkInfo chunkInfo : offsetToChunkInfoMap.values()) {
            chunkInfo.startIndexInFile = indexInFile;
            this.indexToChunkInfoMap.put(indexInFile, chunkInfo);
            indexInFile += chunkInfo.pointCount;
        }
    }

    private void buildModificationList() throws IOException {
        if (this.modsFileName == null) {
            logger.debug("buildModificationList(), modsFileName is null.");
            this.modificationList = null;
            return;
        }
        try (ModificationFile modificationFile = new ModificationFile(this.modsFileName);){
            this.modificationList = modificationFile.getModifications();
        }
        if (this.modificationList.isEmpty()) {
            this.modificationList = null;
        }
    }

    private DeletionGroup getFullPathDeletion(String fullPath) {
        if (this.fullPathToDeletionMap == null) {
            return null;
        }
        if (this.fullPathToDeletionMap.containsKey(fullPath)) {
            return this.fullPathToDeletionMap.get(fullPath);
        }
        DeletionGroup deletionGroup = new DeletionGroup();
        PartialPath partialPath = null;
        try {
            partialPath = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            logger.error("getFullPathDeletion(), find invalid fullPath: {}", (Object)fullPath);
        }
        if (partialPath != null) {
            for (Modification modification : this.modificationList) {
                if (!(modification instanceof Deletion) || !modification.getPath().matchFullPath(partialPath)) continue;
                Deletion deletion = (Deletion)modification;
                deletionGroup.addDelInterval(deletion.getStartTime(), deletion.getEndTime());
            }
        }
        if (deletionGroup.isEmpty()) {
            deletionGroup = null;
        }
        this.fullPathToDeletionMap.put(fullPath, deletionGroup);
        return deletionGroup;
    }

    private long getDataFromPageCache(long pageStartIndexInFile, long dataIndexInfile, long dataLen, List<TimeValuePair> destTVList) throws IOException {
        List pageTVList = (List)this.pageCache.get((Object)pageStartIndexInFile);
        if (pageTVList == null) {
            return -1L;
        }
        long pageDataCount = pageTVList.size();
        if (pageStartIndexInFile + pageDataCount < dataIndexInfile || pageStartIndexInFile >= dataIndexInfile + dataLen) {
            return pageDataCount;
        }
        int beginIdxInPage = (int)(Math.max(dataIndexInfile, pageStartIndexInFile) - pageStartIndexInFile);
        int needCountInPage = (int)(Math.min(pageStartIndexInFile + pageDataCount, dataIndexInfile + dataLen) - Math.max(dataIndexInfile, pageStartIndexInFile));
        destTVList.addAll(((LinkedList)pageTVList).subList(beginIdxInPage, beginIdxInPage + needCountInPage));
        return pageDataCount;
    }

    private long getNonAlignedChunkPoints(ChunkInfo chunkInfo, long startIndexInChunk, long lengthInChunk, DeletionGroup deletionGroup, List<TimeValuePair> tvPairList) throws IOException {
        if (chunkInfo.chunkOffsetInFile < 0L) {
            String errMsg = String.format("getNonAlignedChunkPoints(), invalid chunkOffsetInFile=%d.", chunkInfo.chunkOffsetInFile);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        this.tsFileFullSeqReader.position(chunkInfo.chunkOffsetInFile);
        byte chunkTypeByte = this.tsFileFullSeqReader.readMarker();
        ChunkHeader chunkHeader = this.tsFileFullSeqReader.readChunkHeader(chunkTypeByte);
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
        boolean pageHeaderHasStatistic = (chunkHeader.getChunkType() & 0x3F) == 1;
        int chunkLeftDataSize = chunkHeader.getDataSize();
        long indexInChunk = 0L;
        while (chunkLeftDataSize > 0 && indexInChunk < startIndexInChunk + lengthInChunk) {
            long pagePosInTsfile = this.tsFileFullSeqReader.position();
            PageHeader pageHeader = this.tsFileFullSeqReader.readPageHeader(chunkHeader.getDataType(), pageHeaderHasStatistic);
            int pageSize = pageHeader.getSerializedPageSize();
            chunkLeftDataSize -= pageSize;
            long pageStartIndexInFile = chunkInfo.startIndexInFile + indexInChunk;
            long pageDataNum = this.getDataFromPageCache(pageStartIndexInFile, chunkInfo.startIndexInFile + startIndexInChunk, lengthInChunk, tvPairList);
            if (pageDataNum >= 0L) {
                this.tsFileFullSeqReader.position(pagePosInTsfile + (long)pageSize);
                indexInChunk += pageDataNum;
                continue;
            }
            if (pageHeader.getStatistics() != null) {
                DeletionGroup.DeletedType pageDeletedStatus;
                long pageDataCount = pageHeader.getNumOfValues();
                if (indexInChunk + pageDataCount <= startIndexInChunk) {
                    this.tsFileFullSeqReader.position(pagePosInTsfile + (long)pageSize);
                    indexInChunk += pageDataCount;
                    continue;
                }
                if (deletionGroup != null && (pageDeletedStatus = deletionGroup.checkDeletedState(pageHeader.getStartTime(), pageHeader.getEndTime())) == DeletionGroup.DeletedType.FULL_DELETED) {
                    LinkedList<Object> pageTVList = new LinkedList<Object>();
                    for (long i = 0L; i < pageDataCount; ++i) {
                        pageTVList.add(null);
                    }
                    this.pageCache.put((Object)pageStartIndexInFile, pageTVList);
                    long needCount = Math.min(indexInChunk + pageDataCount, startIndexInChunk + lengthInChunk) - Math.max(indexInChunk, startIndexInChunk);
                    for (long i = 0L; i < needCount; ++i) {
                        tvPairList.add(null);
                    }
                    this.tsFileFullSeqReader.position(pagePosInTsfile + (long)pageSize);
                    indexInChunk += pageDataCount;
                    continue;
                }
            }
            List<TimeValuePair> pageTVList = this.getNonAlignedPagePoints(pageHeader, chunkHeader, valueDecoder, deletionGroup);
            this.pageCache.put((Object)pageStartIndexInFile, pageTVList);
            long pageDataCount = pageTVList.size();
            if (indexInChunk + pageDataCount <= startIndexInChunk) {
                indexInChunk += pageDataCount;
                continue;
            }
            int beginIdxInPage = (int)(Math.max(indexInChunk, startIndexInChunk) - indexInChunk);
            int needCountInPage = (int)(Math.min(indexInChunk + pageDataCount, startIndexInChunk + lengthInChunk) - Math.max(indexInChunk, startIndexInChunk));
            tvPairList.addAll(((LinkedList)pageTVList).subList(beginIdxInPage, beginIdxInPage + needCountInPage));
            indexInChunk += pageDataCount;
        }
        return tvPairList.size();
    }

    private List<TimeValuePair> getNonAlignedPagePoints(PageHeader pageHeader, ChunkHeader chunkHeader, Decoder valueDecoder, DeletionGroup deletionGroup) throws IOException {
        LinkedList<TimeValuePair> pageTVList = new LinkedList<TimeValuePair>();
        ByteBuffer pageData = this.tsFileFullSeqReader.readPage(pageHeader, chunkHeader.getCompressionType());
        valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, chunkHeader.getDataType(), valueDecoder, this.timeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        if (chunkHeader.getChunkType() == 1) {
            logger.debug("points in the page(by pageHeader): " + pageHeader.getNumOfValues());
        } else {
            logger.debug("points in the page(by batchData): " + batchData.length());
        }
        if (batchData.isEmpty()) {
            logger.warn("getNonAlignedChunkPoints(), chunk is empty, chunkHeader = {}.", (Object)chunkHeader);
            return pageTVList;
        }
        batchData.resetBatchData();
        DeletionGroup.IntervalCursor intervalCursor = new DeletionGroup.IntervalCursor();
        while (batchData.hasCurrent()) {
            long ts = batchData.currentTime();
            if (deletionGroup != null && deletionGroup.isDeleted(ts, intervalCursor)) {
                pageTVList.add(null);
            } else {
                TimeValuePair timeValuePair = new TimeValuePair(ts, batchData.currentTsPrimitiveType());
                logger.debug("getNonAlignedChunkPoints(), timeValuePair = {} ", (Object)timeValuePair);
                pageTVList.add(timeValuePair);
            }
            batchData.next();
        }
        return pageTVList;
    }

    private List<TimeValuePair> getAlignedValuePagePoints(ChunkInfo chunkInfo, int pageIndexInChunk, long[] timeBatch, DeletionGroup deletionGroup) throws IOException {
        Decoder valueDecoder;
        ByteBuffer pageData;
        int chunkLeftDataSize;
        int pageSize;
        boolean pageHeaderHasStatistic;
        if (chunkInfo.chunkOffsetInFile < 0L) {
            String errMsg = String.format("getAlignedValuePagePoints(), invalid chunkOffsetInFile=%d.", chunkInfo.chunkOffsetInFile);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        this.tsFileFullSeqReader.position(chunkInfo.chunkOffsetInFile);
        byte valueChunkTypeByte = this.tsFileFullSeqReader.readMarker();
        ChunkHeader valueChunkHeader = this.tsFileFullSeqReader.readChunkHeader(valueChunkTypeByte);
        byte chunkType = valueChunkHeader.getChunkType();
        if ((chunkType & 0x40) != 64) {
            String errMsg = String.format("getAlignedValuePagePoints(), tsFile(%s) current chunk is not time-aligned value chunk. chunkOffsetInFile=%d.", this.tsFileName, chunkInfo.chunkOffsetInFile);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        boolean bl = pageHeaderHasStatistic = (chunkType & 0x3F) == 1;
        if (!pageHeaderHasStatistic && pageIndexInChunk != 0) {
            String errMsg = String.format("getAlignedValuePagePoints(), current value chunk has only 1 page, but pageIndexInChunk=%d.", pageIndexInChunk);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        int k = 0;
        TSDataType tsDataType = valueChunkHeader.getDataType();
        for (chunkLeftDataSize = valueChunkHeader.getDataSize(); chunkLeftDataSize > 0 && k++ < pageIndexInChunk; chunkLeftDataSize -= pageSize) {
            long pagePosInTsFile = this.tsFileFullSeqReader.position();
            PageHeader pageHeader = this.tsFileFullSeqReader.readPageHeader(tsDataType, pageHeaderHasStatistic);
            pageSize = pageHeader.getSerializedPageSize();
            this.tsFileFullSeqReader.position(pagePosInTsFile + (long)pageSize);
        }
        if (chunkLeftDataSize <= 0) {
            String errMsg = String.format("getAlignedValuePagePoints(), current value chunk has only %d pages, but pageIndexInChunk=%d.", k, pageIndexInChunk);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        PageHeader pageHeader = this.tsFileFullSeqReader.readPageHeader(tsDataType, pageHeaderHasStatistic);
        ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData = this.tsFileFullSeqReader.readPage(pageHeader, valueChunkHeader.getCompressionType()), tsDataType, valueDecoder = Decoder.getDecoderByType((TSEncoding)valueChunkHeader.getEncodingType(), (TSDataType)tsDataType));
        TsPrimitiveType[] valueBatch = valuePageReader.nextValueBatch(timeBatch);
        if (timeBatch.length != valueBatch.length) {
            String errMsg = String.format("getAlignedValuePagePoints(), timeBatch & valueBatch have different length. %d != %d.", timeBatch.length, valueBatch.length);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        LinkedList<TimeValuePair> pageTVList = new LinkedList<TimeValuePair>();
        DeletionGroup.IntervalCursor intervalCursor = new DeletionGroup.IntervalCursor();
        for (int i = 0; i < timeBatch.length; ++i) {
            long ts = timeBatch[i];
            if (valueBatch[i] == null || deletionGroup != null && deletionGroup.isDeleted(ts, intervalCursor)) {
                pageTVList.add(null);
                continue;
            }
            TimeValuePair timeValuePair = new TimeValuePair(ts, valueBatch[i]);
            logger.debug("getNonAlignedChunkPoints(), timeValuePair = {} ", (Object)timeValuePair);
            pageTVList.add(timeValuePair);
        }
        return pageTVList;
    }

    private long getAlignedChunkPoints(ChunkInfo chunkInfo, long startIndexInChunk, long lengthInChunk, DeletionGroup deletionGroup, List<TimeValuePair> tvPairList) throws IOException {
        if (chunkInfo.timeChunkOffsetInFile < 0L) {
            String errMsg = String.format("getAlignedChunkPoints(), invalid timeChunkOffsetInFile=%d.", chunkInfo.timeChunkOffsetInFile);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        this.tsFileFullSeqReader.position(chunkInfo.timeChunkOffsetInFile);
        byte timeChunkTypeByte = this.tsFileFullSeqReader.readMarker();
        ChunkHeader timeChunkHeader = this.tsFileFullSeqReader.readChunkHeader(timeChunkTypeByte);
        TSDataType tsDataType = timeChunkHeader.getDataType();
        boolean pageHeaderHasStatistic = (timeChunkHeader.getChunkType() & 0x3F) == 1;
        int chunkLeftDataSize = timeChunkHeader.getDataSize();
        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
        long indexInChunk = 0L;
        int pageIndexInChunk = -1;
        while (chunkLeftDataSize > 0 && indexInChunk < startIndexInChunk + lengthInChunk) {
            long timePageDataCount;
            long timePagePosInTsfile = this.tsFileFullSeqReader.position();
            PageHeader timePageHeader = this.tsFileFullSeqReader.readPageHeader(tsDataType, pageHeaderHasStatistic);
            int timePageSize = timePageHeader.getSerializedPageSize();
            chunkLeftDataSize -= timePageSize;
            ++pageIndexInChunk;
            long pageStartIndexInFile = chunkInfo.startIndexInFile + indexInChunk;
            long pageDataNum = this.getDataFromPageCache(pageStartIndexInFile, chunkInfo.startIndexInFile + startIndexInChunk, lengthInChunk, tvPairList);
            if (pageDataNum >= 0L) {
                this.tsFileFullSeqReader.position(timePagePosInTsfile + (long)timePageSize);
                indexInChunk += pageDataNum;
                continue;
            }
            if (timePageHeader.getStatistics() != null) {
                DeletionGroup.DeletedType pageDeletedStatus;
                long pageDataCount = timePageHeader.getNumOfValues();
                if (indexInChunk + pageDataCount <= startIndexInChunk) {
                    this.tsFileFullSeqReader.position(timePagePosInTsfile + (long)timePageSize);
                    indexInChunk += pageDataCount;
                    continue;
                }
                if (deletionGroup != null && (pageDeletedStatus = deletionGroup.checkDeletedState(timePageHeader.getStartTime(), timePageHeader.getEndTime())) == DeletionGroup.DeletedType.FULL_DELETED) {
                    LinkedList<Object> pageTVList = new LinkedList<Object>();
                    for (long i = 0L; i < pageDataCount; ++i) {
                        pageTVList.add(null);
                    }
                    this.pageCache.put((Object)pageStartIndexInFile, pageTVList);
                    long needCount = Math.min(indexInChunk + pageDataCount, startIndexInChunk + lengthInChunk) - Math.max(indexInChunk, startIndexInChunk);
                    for (long i = 0L; i < needCount; ++i) {
                        tvPairList.add(null);
                    }
                    this.tsFileFullSeqReader.position(timePagePosInTsfile + (long)timePageSize);
                    indexInChunk += pageDataCount;
                    continue;
                }
            }
            ByteBuffer timePageData = this.tsFileFullSeqReader.readPage(timePageHeader, timeChunkHeader.getCompressionType());
            TimePageReader timePageReader = new TimePageReader(timePageHeader, timePageData, defaultTimeDecoder);
            long[] timeBatch = timePageReader.getNextTimeBatch();
            if (logger.isDebugEnabled()) {
                logger.debug("Time pager content: {}", (Object)timeBatch);
            }
            if (indexInChunk + (timePageDataCount = (long)timeBatch.length) <= startIndexInChunk) {
                this.tsFileFullSeqReader.position(timePagePosInTsfile + (long)timePageSize);
                indexInChunk += timePageDataCount;
                continue;
            }
            List<TimeValuePair> pageTVList = this.getAlignedValuePagePoints(chunkInfo, pageIndexInChunk, timeBatch, deletionGroup);
            this.pageCache.put((Object)pageStartIndexInFile, pageTVList);
            int beginIdxInPage = (int)(Math.max(indexInChunk, startIndexInChunk) - indexInChunk);
            int needCountInPage = (int)(Math.min(indexInChunk + timePageDataCount, startIndexInChunk + lengthInChunk) - Math.max(indexInChunk, startIndexInChunk));
            tvPairList.addAll(((LinkedList)pageTVList).subList(beginIdxInPage, beginIdxInPage + needCountInPage));
            this.tsFileFullSeqReader.position(timePagePosInTsfile + (long)timePageSize);
            indexInChunk += timePageDataCount;
        }
        return tvPairList.size();
    }

    private long getChunkPoints(ChunkInfo chunkInfo, long indexInChunk, long lengthInChunk, List<TimeValuePair> tvPairList) throws IOException {
        if (chunkInfo.deletedFlag == DeletionGroup.DeletedType.FULL_DELETED) {
            for (long i = 0L; i < lengthInChunk; ++i) {
                tvPairList.add(null);
            }
            return lengthInChunk;
        }
        DeletionGroup deletionGroup = null;
        if (chunkInfo.deletedFlag != DeletionGroup.DeletedType.NO_DELETED) {
            deletionGroup = this.getFullPathDeletion(chunkInfo.measurementFullPath);
        }
        if (chunkInfo.isTimeAligned) {
            return this.getAlignedChunkPoints(chunkInfo, indexInChunk, lengthInChunk, deletionGroup, tvPairList);
        }
        return this.getNonAlignedChunkPoints(chunkInfo, indexInChunk, lengthInChunk, deletionGroup, tvPairList);
    }

    private void insertToDataList(List<Pair<MeasurementPath, List<TimeValuePair>>> dataList, String sensorFullPath, List<TimeValuePair> tvPairList) throws IOException {
        MeasurementPath measurementPath;
        try {
            measurementPath = new MeasurementPath(sensorFullPath);
        }
        catch (IllegalPathException e) {
            logger.error("TsFileOpBlock.insertToDataList(), Illegal MeasurementPath: {}", (Object)"");
            throw new IOException("Illegal MeasurementPath: " + sensorFullPath, e);
        }
        dataList.add((Pair<MeasurementPath, List<TimeValuePair>>)new Pair((Object)measurementPath, tvPairList));
    }

    private synchronized void prepareData() throws IOException {
        if (this.dataReady) {
            return;
        }
        if (this.tsFileFullSeqReader == null) {
            this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        }
        if (this.modsFileName != null) {
            this.buildModificationList();
        }
        if (this.fullPathToDeletionMap == null && this.modificationList != null) {
            this.fullPathToDeletionMap = new HashMap<String, DeletionGroup>();
        }
        if (this.indexToChunkInfoMap == null) {
            this.buildIndexToChunkMap();
        }
        this.dataReady = true;
    }

    @Override
    public Operation getOperation(long index, long length) throws IOException {
        long remain;
        long readCount;
        if (this.closed) {
            logger.error("TsFileOpBlock.getOperation(), can not access closed TsFileOpBlock: {}.", (Object)this);
            throw new IOException("can not access closed TsFileOpBlock: " + this);
        }
        long indexInTsFile = index - this.beginIndex;
        if (indexInTsFile < 0L || indexInTsFile >= this.dataCount) {
            logger.error("TsFileOpBlock.getOperation(), Error: index {} is out of range.", (Object)index);
            return null;
        }
        if (!this.dataReady) {
            this.prepareData();
        }
        LinkedList<Pair<MeasurementPath, List<TimeValuePair>>> dataList = new LinkedList<Pair<MeasurementPath, List<TimeValuePair>>>();
        String lastSensorFullPath = "";
        LinkedList<TimeValuePair> tvPairList = null;
        for (remain = length; remain > 0L; remain -= readCount) {
            Map.Entry<Long, ChunkInfo> entry = this.indexToChunkInfoMap.floorEntry(indexInTsFile);
            if (entry == null) {
                logger.error("TsFileOpBlock.getOperation(), indexInTsFile {} if out of indexToChunkOffsetMap.", (Object)indexInTsFile);
                throw new IOException("indexInTsFile is out of range.");
            }
            long indexInChunk = indexInTsFile - entry.getKey();
            ChunkInfo chunkInfo = entry.getValue();
            String sensorFullPath = chunkInfo.measurementFullPath;
            long chunkPointCount = chunkInfo.pointCount;
            long lengthInChunk = Math.min(chunkPointCount - indexInChunk, remain);
            if (!sensorFullPath.equals(lastSensorFullPath)) {
                if (tvPairList != null && tvPairList.size() > 0) {
                    this.insertToDataList(dataList, lastSensorFullPath, tvPairList);
                    tvPairList = null;
                }
                lastSensorFullPath = sensorFullPath;
            }
            if (tvPairList == null) {
                tvPairList = new LinkedList<TimeValuePair>();
            }
            if ((readCount = this.getChunkPoints(chunkInfo, indexInChunk, lengthInChunk, tvPairList)) == lengthInChunk) continue;
            String errMsg = String.format("TsFileOpBlock.getOperation(), error when read chunk from file %s. indexInTsFile=%d, lengthInChunk=%d, readCount=%d.", this.tsFileName, indexInTsFile, lengthInChunk, readCount);
            logger.error(errMsg);
            throw new IOException(errMsg);
        }
        if (tvPairList != null && tvPairList.size() > 0) {
            this.insertToDataList(dataList, lastSensorFullPath, (List<TimeValuePair>)tvPairList);
        }
        return new InsertOperation(this.storageGroup, index, index + length - remain, dataList);
    }

    @Override
    public void close() {
        super.close();
        if (this.tsFileFullSeqReader != null) {
            try {
                this.tsFileFullSeqReader.close();
            }
            catch (IOException e) {
                logger.error("tsFileFullSeqReader.close() exception, file = {}", (Object)this.tsFileName, (Object)e);
            }
            this.tsFileFullSeqReader = null;
        }
        this.dataReady = false;
    }

    public Collection<Modification> getModificationList() {
        return this.modificationList;
    }

    public Map<String, DeletionGroup> getFullPathToDeletionMap() {
        return this.fullPathToDeletionMap;
    }

    @Override
    public String toString() {
        return super.toString() + ", tsFileName=" + this.tsFileName + ", modsFileName=" + this.modsFileName;
    }

    private class TsFileFullReader
    extends TsFileSequenceReader {
        public TsFileFullReader(String file) throws IOException {
            super(file);
        }

        private void genTSMetadataFromMetaIndexEntry(long startOffset, MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (buffer.hasRemaining()) {
                    long pos = startOffset + (long)buffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom((ByteBuffer)buffer, (boolean)needChunkMetadata);
                    timeseriesMetadataMap.put(pos, (Pair<Path, TimeseriesMetadata>)new Pair((Object)new Path(deviceId, timeseriesMetadata.getMeasurementId(), true), (Object)timeseriesMetadata));
                }
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = metadataIndex.getName();
                }
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom((ByteBuffer)buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = ((MetadataIndexEntry)metadataIndexNode.getChildren().get(i + 1)).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), endOffset);
                    this.genTSMetadataFromMetaIndexEntry(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), (MetadataIndexEntry)metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }

        public Map<Long, Pair<Path, TimeseriesMetadata>> getAllTimeseriesMeta(boolean needChunkMetadata) throws IOException {
            if (this.tsFileMetaData == null) {
                this.readFileMetadata();
            }
            MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
            TreeMap<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<Long, Pair<Path, TimeseriesMetadata>>();
            List metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                MetadataIndexEntry metadataIndexEntry = (MetadataIndexEntry)metadataIndexEntryList.get(i);
                long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
                if (i != metadataIndexEntryList.size() - 1) {
                    endOffset = ((MetadataIndexEntry)metadataIndexEntryList.get(i + 1)).getOffset();
                }
                ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                this.genTSMetadataFromMetaIndexEntry(metadataIndexEntry.getOffset(), metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
            }
            return timeseriesMetadataMap;
        }

        public TsFileMetadata readFileMetadata() throws IOException {
            if (this.tsFileMetaData != null) {
                return this.tsFileMetaData;
            }
            try {
                this.tsFileMetaData = TsFileMetadata.deserializeFrom((ByteBuffer)this.readData(this.getFileMetadataPos(), (int)this.getFileMetadataSize()));
            }
            catch (BufferOverflowException e) {
                logger.error("readFileMetadata(), reading file metadata of file {}", (Object)this.file);
                throw e;
            }
            return this.tsFileMetaData;
        }
    }

    private class ChunkInfo {
        public String measurementFullPath;
        public long chunkOffsetInFile = -1L;
        public long startIndexInFile = -1L;
        public long pointCount = 0L;
        public boolean isTimeAligned = false;
        public long timeChunkOffsetInFile = -1L;
        public DeletionGroup.DeletedType deletedFlag = DeletionGroup.DeletedType.NO_DELETED;

        private ChunkInfo() {
        }
    }
}

