/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.TsFileMetricManager;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class FileMetrics
implements IMetricSet {
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private long walFileTotalSize = 0L;
    private long walFileTotalCount = 0L;
    private long sequenceFileTotalSize = 0L;
    private long sequenceFileTotalCount = 0L;
    private long unsequenceFileTotalSize = 0L;
    private long unsequenceFileTotalCount = 0L;
    private long innerSeqCompactionTempFileSize = 0L;
    private long innerUnseqCompactionTempFileSize = 0L;
    private long crossCompactionTempFileSize = 0L;
    private long innerSeqCompactionTempFileNum = 0L;
    private long innerUnseqCompactionTempFileNum = 0L;
    private long crossCompactionTempFileNum = 0L;

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalSize, new String[]{Tag.NAME.toString(), "wal"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalSize, new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalSize, new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalCount, new String[]{Tag.NAME.toString(), "wal"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalCount, new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalCount, new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getInnerSeqCompactionTempFileNum, new String[]{Tag.NAME.toString(), "inner-seq-temp-num"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getInnerUnseqCompactionTempFileNum, new String[]{Tag.NAME.toString(), "inner-unseq-temp-num"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getCrossCompactionTempFileNum, new String[]{Tag.NAME.toString(), "cross-temp-num"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getInnerSeqCompactionTempFileSize, new String[]{Tag.NAME.toString(), "inner-seq-temp-size"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getInnerUnseqCompactionTempFileSize, new String[]{Tag.NAME.toString(), "inner-unseq-temp-size"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getCrossCompactionTempFileSize, new String[]{Tag.NAME.toString(), "cross-temp-size"});
        if (null == this.currentServiceFuture) {
            this.currentServiceFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.service, this::collect, (long)1L, (long)MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(true);
            this.currentServiceFuture = null;
        }
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "unseq"});
    }

    private void collect() {
        this.walFileTotalSize = WALManager.getInstance().getTotalDiskUsage();
        this.sequenceFileTotalSize = TsFileMetricManager.getInstance().getFileSize(true);
        this.unsequenceFileTotalSize = TsFileMetricManager.getInstance().getFileSize(false);
        this.walFileTotalCount = WALManager.getInstance().getTotalFileNum();
        this.sequenceFileTotalCount = TsFileMetricManager.getInstance().getFileNum(true);
        this.unsequenceFileTotalCount = TsFileMetricManager.getInstance().getFileNum(false);
    }

    public long getWalFileTotalSize() {
        return this.walFileTotalSize;
    }

    public long getWalFileTotalCount() {
        return this.walFileTotalCount;
    }

    public long getSequenceFileTotalSize() {
        return this.sequenceFileTotalSize;
    }

    public long getSequenceFileTotalCount() {
        return this.sequenceFileTotalCount;
    }

    public long getUnsequenceFileTotalSize() {
        return this.unsequenceFileTotalSize;
    }

    public long getUnsequenceFileTotalCount() {
        return this.unsequenceFileTotalCount;
    }

    public long getInnerSeqCompactionTempFileSize() {
        return this.innerSeqCompactionTempFileSize;
    }

    public long getInnerUnseqCompactionTempFileSize() {
        return this.innerUnseqCompactionTempFileSize;
    }

    public long getCrossCompactionTempFileSize() {
        return this.crossCompactionTempFileSize;
    }

    public long getInnerSeqCompactionTempFileNum() {
        return this.innerSeqCompactionTempFileNum;
    }

    public long getInnerUnseqCompactionTempFileNum() {
        return this.innerUnseqCompactionTempFileNum;
    }

    public long getCrossCompactionTempFileNum() {
        return this.crossCompactionTempFileNum;
    }
}

