/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.HashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionMigrateFailedType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.rescon.AbstractPoolManager;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMigrateService
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionMigrateService.class);
    public static final String REGION_MIGRATE_PROCESS = "[REGION_MIGRATE_PROCESS]";
    private static final int MAX_RETRY_NUM = 5;
    private static final int SLEEP_MILLIS = 5000;
    private RegionMigratePool regionMigratePool;

    private RegionMigrateService() {
    }

    public static RegionMigrateService getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized boolean submitAddRegionPeerTask(TMaintainPeerReq req) {
        boolean submitSucceed = true;
        try {
            this.regionMigratePool.submit(new AddRegionPeerTask(req.getRegionId(), req.getDestNode()));
        }
        catch (Exception e) {
            LOGGER.error("{}, Submit AddRegionPeerTask error for Region: {}", new Object[]{REGION_MIGRATE_PROCESS, req.getRegionId(), e});
            submitSucceed = false;
        }
        return submitSucceed;
    }

    public synchronized boolean submitRemoveRegionPeerTask(TMaintainPeerReq req) {
        boolean submitSucceed = true;
        try {
            this.regionMigratePool.submit(new RemoveRegionPeerTask(req.getRegionId(), req.getDestNode()));
        }
        catch (Exception e) {
            LOGGER.error("{}, Submit RemoveRegionPeer task error for Region: {}", new Object[]{REGION_MIGRATE_PROCESS, req.getRegionId(), e});
            submitSucceed = false;
        }
        return submitSucceed;
    }

    public synchronized boolean submitDeleteOldRegionPeerTask(TMaintainPeerReq req) {
        boolean submitSucceed = true;
        try {
            this.regionMigratePool.submit(new DeleteOldRegionPeerTask(req.getRegionId(), req.getDestNode()));
        }
        catch (Exception e) {
            LOGGER.error("{}, Submit DeleteOldRegionPeerTask error for Region: {}", new Object[]{REGION_MIGRATE_PROCESS, req.getRegionId(), e});
            submitSucceed = false;
        }
        return submitSucceed;
    }

    public void start() throws StartupException {
        this.regionMigratePool = new RegionMigratePool();
        this.regionMigratePool.start();
        LOGGER.info("Region migrate service start");
    }

    public void stop() {
        if (this.regionMigratePool != null) {
            this.regionMigratePool.stop();
        }
        LOGGER.info("Region migrate service stop");
    }

    public ServiceType getID() {
        return ServiceType.DATA_NODE_REGION_MIGRATE_SERVICE;
    }

    private static void reportSucceed(TConsensusGroupId tRegionId, String migrateState) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        status.setMessage(String.format("Region: %s, state: %s, executed succeed", tRegionId, migrateState));
        TRegionMigrateResultReportReq req = new TRegionMigrateResultReportReq(tRegionId, status);
        try {
            RegionMigrateService.reportRegionMigrateResultToConfigNode(req);
        }
        catch (Throwable e) {
            LOGGER.error("{}, Report region {} migrate result error in reportSucceed, result: {}", new Object[]{REGION_MIGRATE_PROCESS, tRegionId, req, e});
        }
    }

    private static void reportFailed(TConsensusGroupId tRegionId, TDataNodeLocation failedNode, TRegionMigrateFailedType failedType, TSStatus status) {
        HashMap<TDataNodeLocation, TRegionMigrateFailedType> failedNodeAndReason = new HashMap<TDataNodeLocation, TRegionMigrateFailedType>();
        failedNodeAndReason.put(failedNode, failedType);
        TRegionMigrateResultReportReq req = new TRegionMigrateResultReportReq(tRegionId, status);
        req.setFailedNodeAndReason(failedNodeAndReason);
        try {
            RegionMigrateService.reportRegionMigrateResultToConfigNode(req);
        }
        catch (Throwable e) {
            LOGGER.error("{}, Report region {} migrate error in reportFailed, result:{}", new Object[]{REGION_MIGRATE_PROCESS, tRegionId, req, e});
        }
    }

    private static void reportRegionMigrateResultToConfigNode(TRegionMigrateResultReportReq req) throws TException {
        try (ConfigNodeClient client = new ConfigNodeClient();){
            TSStatus status = client.reportRegionMigrateResult(req);
            LOGGER.info("{}, Report region {} migrate result {} to Config node succeed, result: {}", new Object[]{REGION_MIGRATE_PROCESS, req.getRegionId(), req, status});
        }
    }

    private static boolean isSucceed(TSStatus status) {
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    private static boolean isFailed(TSStatus status) {
        return !RegionMigrateService.isSucceed(status);
    }

    private static TEndPoint getConsensusEndPoint(TDataNodeLocation nodeLocation, ConsensusGroupId regionId) {
        if (regionId instanceof DataRegionId) {
            return nodeLocation.getDataRegionConsensusEndPoint();
        }
        return nodeLocation.getSchemaRegionConsensusEndPoint();
    }

    private static class Holder {
        private static final RegionMigrateService INSTANCE = new RegionMigrateService();

        private Holder() {
        }
    }

    private static class DeleteOldRegionPeerTask
    implements Runnable {
        private static final Logger taskLogger = LoggerFactory.getLogger(DeleteOldRegionPeerTask.class);
        private final TConsensusGroupId tRegionId;
        private final TDataNodeLocation originalDataNode;

        public DeleteOldRegionPeerTask(TConsensusGroupId tRegionId, TDataNodeLocation originalDataNode) {
            this.tRegionId = tRegionId;
            this.originalDataNode = originalDataNode;
        }

        @Override
        public void run() {
            TSStatus runResult = this.deletePeer();
            if (RegionMigrateService.isFailed(runResult)) {
                RegionMigrateService.reportFailed(this.tRegionId, this.originalDataNode, TRegionMigrateFailedType.RemoveConsensusGroupFailed, runResult);
            }
            if (RegionMigrateService.isFailed(runResult = this.deleteRegion())) {
                RegionMigrateService.reportFailed(this.tRegionId, this.originalDataNode, TRegionMigrateFailedType.DeleteRegionFailed, runResult);
            }
            RegionMigrateService.reportSucceed(this.tRegionId, "DeletePeer");
        }

        private TSStatus deletePeer() {
            ConsensusGenericResponse resp;
            taskLogger.info("{}, Start to deletePeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, this.originalDataNode, this.tRegionId});
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            try {
                resp = regionId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().deletePeer(regionId) : SchemaRegionConsensusImpl.getInstance().deletePeer(regionId);
            }
            catch (Throwable e) {
                taskLogger.error("{}, deletePeer error, regionId: {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, regionId, e});
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage("deletePeer for region: " + regionId + " error. exception: " + e.getMessage());
                return status;
            }
            if (!resp.isSuccess()) {
                String errorMsg = String.format("deletePeer error, regionId: %s, errorMessage: %s", regionId, resp.getException().getMessage());
                taskLogger.error(errorMsg);
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage(errorMsg);
                return status;
            }
            taskLogger.info("{}, Succeed to deletePeer {} from consensus group", (Object)RegionMigrateService.REGION_MIGRATE_PROCESS, (Object)regionId);
            status.setMessage("deletePeer from consensus group " + regionId + "succeed");
            return status;
        }

        private TSStatus deleteRegion() {
            taskLogger.info("{}, Start to deleteRegion {} for datanode {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, this.tRegionId, this.originalDataNode});
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            try {
                if (regionId instanceof DataRegionId) {
                    StorageEngineV2.getInstance().deleteDataRegion((DataRegionId)regionId);
                } else {
                    SchemaEngine.getInstance().deleteSchemaRegion((SchemaRegionId)regionId);
                }
            }
            catch (Throwable e) {
                taskLogger.error("{}, deleteRegion {} error", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, regionId, e});
                status.setCode(TSStatusCode.DELETE_REGION_ERROR.getStatusCode());
                status.setMessage("deleteRegion " + regionId + " error, " + e.getMessage());
                return status;
            }
            status.setMessage("deleteRegion " + regionId + " succeed");
            taskLogger.info("{}, Succeed to deleteRegion {}", (Object)RegionMigrateService.REGION_MIGRATE_PROCESS, (Object)regionId);
            return status;
        }
    }

    private static class RemoveRegionPeerTask
    implements Runnable {
        private static final Logger taskLogger = LoggerFactory.getLogger(RemoveRegionPeerTask.class);
        private final TConsensusGroupId tRegionId;
        private final TDataNodeLocation destDataNode;

        public RemoveRegionPeerTask(TConsensusGroupId tRegionId, TDataNodeLocation destDataNode) {
            this.tRegionId = tRegionId;
            this.destDataNode = destDataNode;
        }

        @Override
        public void run() {
            TSStatus runResult = this.removePeer();
            if (RegionMigrateService.isSucceed(runResult)) {
                RegionMigrateService.reportSucceed(this.tRegionId, "RemovePeer");
            } else {
                RegionMigrateService.reportFailed(this.tRegionId, this.destDataNode, TRegionMigrateFailedType.RemovePeerFailed, runResult);
            }
        }

        private TSStatus removePeer() {
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            TEndPoint destEndPoint = RegionMigrateService.getConsensusEndPoint(this.destDataNode, regionId);
            taskLogger.info("{}, Start to removePeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId});
            ConsensusGenericResponse resp = null;
            boolean removePeerSucceed = true;
            for (int i = 0; i < 5; ++i) {
                try {
                    if (!removePeerSucceed) {
                        Thread.sleep(5000L);
                    }
                    resp = this.removeRegionPeer(regionId, new Peer(regionId, this.destDataNode.getDataNodeId(), destEndPoint));
                }
                catch (Throwable e) {
                    removePeerSucceed = false;
                    taskLogger.error("{}, executed removePeer {} for region {} error, retry times: {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId, i, e});
                }
                if (removePeerSucceed && resp != null && resp.isSuccess()) break;
            }
            if (!removePeerSucceed || resp == null || !resp.isSuccess()) {
                String errorMsg = String.format("%s, RemovePeer for region error after max retry times, peerId: %s, regionId: %s, resp: %s", RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId, resp);
                taskLogger.error(errorMsg);
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage(errorMsg);
                return status;
            }
            taskLogger.info("{}, Succeed to removePeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId});
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setMessage("removePeer " + destEndPoint + " for region " + regionId + " succeed");
            return status;
        }

        private ConsensusGenericResponse removeRegionPeer(ConsensusGroupId regionId, Peer oldPeer) {
            ConsensusGenericResponse resp = regionId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().removePeer(regionId, oldPeer) : SchemaRegionConsensusImpl.getInstance().removePeer(regionId, oldPeer);
            return resp;
        }
    }

    private static class AddRegionPeerTask
    implements Runnable {
        private static final Logger taskLogger = LoggerFactory.getLogger(AddRegionPeerTask.class);
        private final TConsensusGroupId tRegionId;
        private final TDataNodeLocation destDataNode;

        public AddRegionPeerTask(TConsensusGroupId tRegionId, TDataNodeLocation destDataNode) {
            this.tRegionId = tRegionId;
            this.destDataNode = destDataNode;
        }

        @Override
        public void run() {
            TSStatus runResult = this.addPeer();
            if (RegionMigrateService.isFailed(runResult)) {
                RegionMigrateService.reportFailed(this.tRegionId, this.destDataNode, TRegionMigrateFailedType.AddPeerFailed, runResult);
                return;
            }
            RegionMigrateService.reportSucceed(this.tRegionId, "AddPeer");
        }

        private TSStatus addPeer() {
            taskLogger.info("{}, Start to addPeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, this.destDataNode, this.tRegionId});
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            ConsensusGenericResponse resp = null;
            TEndPoint destEndpoint = RegionMigrateService.getConsensusEndPoint(this.destDataNode, regionId);
            boolean addPeerSucceed = true;
            for (int i = 0; i < 5; ++i) {
                try {
                    if (!addPeerSucceed) {
                        Thread.sleep(5000L);
                    }
                    resp = this.addRegionPeer(regionId, new Peer(regionId, this.destDataNode.getDataNodeId(), destEndpoint));
                }
                catch (Throwable e) {
                    addPeerSucceed = false;
                    taskLogger.error("{}, executed addPeer {} for region {} error, retry times: {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndpoint, regionId, i, e});
                }
                if (addPeerSucceed && resp != null && resp.isSuccess()) break;
            }
            if (!addPeerSucceed || resp == null || !resp.isSuccess()) {
                String errorMsg = String.format("%s, AddPeer for region error after max retry times, peerId: %s, regionId: %s, resp: %s", RegionMigrateService.REGION_MIGRATE_PROCESS, destEndpoint, regionId, resp);
                taskLogger.error(errorMsg);
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage(errorMsg);
                return status;
            }
            taskLogger.info("{}, Succeed to addPeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndpoint, regionId});
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setMessage("addPeer " + destEndpoint + " for region " + regionId + " succeed");
            return status;
        }

        private ConsensusGenericResponse addRegionPeer(ConsensusGroupId regionId, Peer newPeer) {
            ConsensusGenericResponse resp = regionId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().addPeer(regionId, newPeer) : SchemaRegionConsensusImpl.getInstance().addPeer(regionId, newPeer);
            return resp;
        }
    }

    private static class RegionMigratePool
    extends AbstractPoolManager {
        private final Logger poolLogger = LoggerFactory.getLogger(RegionMigratePool.class);

        private RegionMigratePool() {
            this.pool = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"Region-Migrate-Pool");
        }

        @Override
        public Logger getLogger() {
            return this.poolLogger;
        }

        @Override
        public void start() {
            if (this.pool != null) {
                this.poolLogger.info("DataNode region migrate pool start");
            }
        }

        @Override
        public String getName() {
            return "migrate region";
        }
    }
}

