/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryChecker;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.wal.WALManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBShutdownHook.class);

    @Override
    public void run() {
        if (SchemaEngineMode.valueOf(IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode()).equals((Object)SchemaEngineMode.Rocksdb_based)) {
            IoTDB.configManager.clear();
        }
        CommonDescriptor.getInstance().getConfig().setNodeStatusToShutdown();
        WALManager.getInstance().waitAllWALFlushed();
        if (!IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            StorageEngineV2.getInstance().syncCloseAllProcessor();
        }
        WALManager.getInstance().deleteOutdatedWALFiles();
        if (IoTDBDescriptor.getInstance().getConfig().isClusterMode() && IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            DataRegionConsensusImpl.getInstance().getAllConsensusGroupIds().parallelStream().forEach(id -> DataRegionConsensusImpl.getInstance().triggerSnapshot(id));
        }
        DirectoryChecker.getInstance().deregisterAll();
        if (logger.isInfoEnabled()) {
            logger.info("IoTDB exits. Jvm memory usage: {}", (Object)MemUtils.bytesCntToStr(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        }
    }
}

