/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.Arrays;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FillClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class FillQueryOperator
extends QueryOperator {
    @Override
    public void check() throws LogicalOperatorException {
        super.check();
        if (!this.isAlignByTime()) {
            throw new LogicalOperatorException("FILL doesn't support disable align clause.");
        }
        if (this.hasTimeSeriesGeneratingFunction() || this.selectComponent.hasUserDefinedAggregationFunction()) {
            throw new LogicalOperatorException("Fill functions are not supported in UDF queries.");
        }
        if (this.whereComponent == null || this.whereComponent.getFilterOperator() == null) {
            throw new SQLParserException("FILL must be used with a WHERE clause");
        }
        FilterOperator filterOperator = this.whereComponent.getFilterOperator();
        if (!filterOperator.isLeaf() || filterOperator.getFilterType() != FilterConstant.FilterType.EQUAL || !Arrays.equals(SQLConstant.getSingleTimeArray(), this.whereComponent.getFilterOperator().getSinglePath().getNodes())) {
            throw new LogicalOperatorException("The condition of WHERE clause must be like time=constant");
        }
        if (!filterOperator.isSingle()) {
            throw new LogicalOperatorException("Slice query must select a single time point");
        }
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return this.isAlignByDevice() ? this.generateAlignByDevicePlan(generator) : super.generateRawDataQueryPlan(generator, this.initFillQueryPlan());
    }

    @Override
    protected AlignByDevicePlan generateAlignByDevicePlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan alignByDevicePlan = super.generateAlignByDevicePlan(generator);
        alignByDevicePlan.setFillQueryPlan(this.initFillQueryPlan());
        return alignByDevicePlan;
    }

    private FillQueryPlan initFillQueryPlan() {
        FillQueryPlan fillQueryPlan = new FillQueryPlan();
        FilterOperator timeFilter = this.whereComponent.getFilterOperator();
        long time = Long.parseLong(((BasicFunctionOperator)timeFilter).getValue());
        fillQueryPlan.setQueryTime(time);
        fillQueryPlan.setSingleFill(((FillClauseComponent)this.specialClauseComponent).getSingleFill());
        fillQueryPlan.setFillType(((FillClauseComponent)this.specialClauseComponent).getFillTypes());
        return fillQueryPlan;
    }
}

