/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.util;

import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class FilterUtils {
    public static String getFilterStringValue(Filter filter) {
        String filterString = filter.toString();
        if (filter instanceof ValueFilter.ValueEq) {
            return filterString.split("== ")[1];
        }
        if (filter instanceof ValueFilter.ValueNotEq) {
            return filterString.split("!= ")[1];
        }
        if (filter instanceof ValueFilter.ValueLtEq) {
            return filterString.split("<= ")[1];
        }
        if (filter instanceof ValueFilter.ValueLt) {
            return filterString.split("< ")[1];
        }
        if (filter instanceof ValueFilter.ValueGtEq) {
            return filterString.split(">= ")[1];
        }
        if (filter instanceof ValueFilter.ValueGt) {
            return filterString.split("> ")[1];
        }
        throw new UnSupportedDataTypeException("Unsupported filter :" + filter);
    }

    public static String getFilerSymbol(Filter filter) {
        if (filter instanceof ValueFilter.ValueEq) {
            return "=";
        }
        if (filter instanceof ValueFilter.ValueNotEq) {
            return "!=";
        }
        if (filter instanceof ValueFilter.ValueLtEq) {
            return "<=";
        }
        if (filter instanceof ValueFilter.ValueLt) {
            return "<";
        }
        if (filter instanceof ValueFilter.ValueGtEq) {
            return ">=";
        }
        if (filter instanceof ValueFilter.ValueGt) {
            return ">";
        }
        throw new UnSupportedDataTypeException("Unsupported filter :" + filter);
    }

    public static Filter filterTypeToFilter(FilterConstant.FilterType filterType, String value) {
        switch (filterType) {
            case EQUAL: {
                return ValueFilter.eq((Comparable)((Object)value));
            }
            case NOTEQUAL: {
                return ValueFilter.notEq((Comparable)((Object)value));
            }
            case LESSTHANOREQUALTO: {
                return ValueFilter.ltEq((Comparable)((Object)value));
            }
            case LESSTHAN: {
                return ValueFilter.lt((Comparable)((Object)value));
            }
            case GREATERTHANOREQUALTO: {
                return ValueFilter.gtEq((Comparable)((Object)value));
            }
            case GREATERTHAN: {
                return ValueFilter.gt((Comparable)((Object)value));
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + (Object)((Object)filterType));
    }
}

