/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler.load;

import io.airlift.units.Duration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.load.ChunkData;
import org.apache.iotdb.db.engine.load.TsFileData;
import org.apache.iotdb.db.engine.load.TsFileSplitter;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInfo;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.mpp.plan.scheduler.IScheduler;
import org.apache.iotdb.db.mpp.plan.scheduler.load.LoadTsFileDispatcherImpl;
import org.apache.iotdb.mpp.rpc.thrift.TLoadCommandReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileScheduler
implements IScheduler {
    private static final Logger logger = LoggerFactory.getLogger(LoadTsFileScheduler.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final long LOAD_TASK_MAX_TIME_IN_SECOND = 5184000L;
    private static final long MAX_MEMORY_SIZE = Math.min((long)(config.getThriftMaxFrameSize() / 2), (long)((double)config.getAllocateMemoryForStorageEngine() * config.getLoadTsFileProportion()));
    private final MPPQueryContext queryContext;
    private final QueryStateMachine stateMachine;
    private final LoadTsFileDispatcherImpl dispatcher;
    private final List<LoadSingleTsFileNode> tsFileNodeList;
    private final PlanFragmentId fragmentId;
    private Set<TRegionReplicaSet> allReplicaSets;

    public LoadTsFileScheduler(DistributedQueryPlan distributedQueryPlan, MPPQueryContext queryContext, QueryStateMachine stateMachine, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.queryContext = queryContext;
        this.stateMachine = stateMachine;
        this.tsFileNodeList = new ArrayList<LoadSingleTsFileNode>();
        this.fragmentId = distributedQueryPlan.getRootSubPlan().getPlanFragment().getId();
        this.dispatcher = new LoadTsFileDispatcherImpl(internalServiceClientManager);
        this.allReplicaSets = new HashSet<TRegionReplicaSet>();
        for (FragmentInstance fragmentInstance : distributedQueryPlan.getInstances()) {
            this.tsFileNodeList.add((LoadSingleTsFileNode)fragmentInstance.getFragment().getPlanNodeTree());
        }
    }

    @Override
    public void start() {
        this.stateMachine.transitionToRunning();
        for (LoadSingleTsFileNode node : this.tsFileNodeList) {
            if (!node.needDecodeTsFile()) {
                boolean isLoadLocallySuccess = this.loadLocally(node);
                node.clean();
                if (isLoadLocallySuccess) continue;
                return;
            }
            String uuid = UUID.randomUUID().toString();
            this.dispatcher.setUuid(uuid);
            this.allReplicaSets.clear();
            boolean isFirstPhaseSuccess = this.firstPhase(node);
            boolean isSecondPhaseSuccess = this.secondPhase(isFirstPhaseSuccess, uuid, node.getTsFileResource().getTsFile());
            node.clean();
            if (isFirstPhaseSuccess && isSecondPhaseSuccess) continue;
            return;
        }
        this.stateMachine.transitionToFinished();
    }

    private boolean firstPhase(LoadSingleTsFileNode node) {
        try {
            TsFileDataManager tsFileDataManager = new TsFileDataManager(this, node);
            new TsFileSplitter(node.getTsFileResource().getTsFile(), x$0 -> tsFileDataManager.addOrSendTsFileData(x$0)).splitTsFileByDataPartition();
            if (!tsFileDataManager.sendAllTsFileData()) {
                return false;
            }
        }
        catch (IllegalStateException e) {
            logger.warn(String.format("Dispatch TsFileData error when parsing TsFile %s.", node.getTsFileResource().getTsFile()), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.stateMachine.transitionToFailed(e);
            logger.warn(String.format("Parse or send TsFile %s error.", node.getTsFileResource().getTsFile()), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean dispatchOnePieceNode(LoadTsFilePieceNode pieceNode, TRegionReplicaSet replicaSet) {
        this.allReplicaSets.add(replicaSet);
        FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, pieceNode), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
        instance.setExecutorAndHost((ExecutorType)new StorageExecutor(replicaSet));
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatch(Collections.singletonList(instance));
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get(5184000L, TimeUnit.SECONDS);
            if (!result.isSuccessful()) {
                logger.warn(String.format("Dispatch one piece to ReplicaSet %s error. Result status code %s. Result status message %s. Dispatch piece node error:%n%s", replicaSet, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage(), pieceNode));
                if (result.getFailureStatus().getSubStatus() != null) {
                    for (TSStatus status : result.getFailureStatus().getSubStatus()) {
                        logger.warn(String.format("Sub status code %s. Sub status message %s.", TSStatusCode.representOf((int)status.getCode()).name(), status.getMessage()));
                    }
                }
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s piece error in 1st phase. Because ", pieceNode.getTsFile()) + status.getMessage());
                this.stateMachine.transitionToFailed(status);
                return false;
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.warn("Interrupt or Execution error.", (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        catch (TimeoutException e) {
            dispatchResultFuture.cancel(true);
            logger.warn(String.format("Wait for loading %s time out.", LoadTsFilePieceNode.class.getName()), (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        return true;
    }

    private boolean secondPhase(boolean isFirstPhaseSuccess, String uuid, File tsFile) {
        logger.info(String.format("Start dispatching Load command for uuid %s", uuid));
        TLoadCommandReq loadCommandReq = new TLoadCommandReq((isFirstPhaseSuccess ? LoadCommand.EXECUTE : LoadCommand.ROLLBACK).ordinal(), uuid);
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatchCommand(loadCommandReq, this.allReplicaSets);
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get();
            if (!result.isSuccessful()) {
                logger.warn(String.format("Dispatch load command %s of TsFile %s error to replicaSets %s error. Result status code %s. Result status message %s.", loadCommandReq, tsFile, this.allReplicaSets, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage()));
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s error in 2nd phase. Because ", tsFile) + status.getMessage());
                this.stateMachine.transitionToFailed(status);
                return false;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.warn("Interrupt or Execution error.", (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        return true;
    }

    private boolean loadLocally(LoadSingleTsFileNode node) {
        logger.info(String.format("Start load TsFile %s locally.", node.getTsFileResource().getTsFile().getPath()));
        try {
            FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, node), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
            instance.setExecutorAndHost((ExecutorType)new StorageExecutor(node.getLocalRegionReplicaSet()));
            this.dispatcher.dispatchLocally(instance);
        }
        catch (FragmentInstanceDispatchException e) {
            logger.warn(String.format("Dispatch tsFile %s error to local error. Result status code %s. Result status message %s.", node.getTsFileResource().getTsFile(), TSStatusCode.representOf((int)e.getFailureStatus().getCode()).name(), e.getFailureStatus().getMessage()));
            this.stateMachine.transitionToFailed(e.getFailureStatus());
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
    }

    @Override
    public Duration getTotalCpuTime() {
        return null;
    }

    @Override
    public FragmentInfo getFragmentInfo() {
        return null;
    }

    @Override
    public void abortFragmentInstance(FragmentInstanceId instanceId, Throwable failureCause) {
    }

    @Override
    public void cancelFragment(PlanFragmentId planFragmentId) {
    }

    private class TsFileDataManager {
        private final LoadTsFileScheduler scheduler;
        private final LoadSingleTsFileNode singleTsFileNode;
        private long dataSize;
        private Map<TRegionReplicaSet, LoadTsFilePieceNode> replicaSet2Piece;

        public TsFileDataManager(LoadTsFileScheduler scheduler, LoadSingleTsFileNode singleTsFileNode) {
            this.scheduler = scheduler;
            this.singleTsFileNode = singleTsFileNode;
            this.dataSize = 0L;
            this.replicaSet2Piece = new HashMap<TRegionReplicaSet, LoadTsFilePieceNode>();
        }

        private boolean addOrSendTsFileData(TsFileData tsFileData) {
            return tsFileData.isModification() ? this.addOrSendDeletionData(tsFileData) : this.addOrSendChunkData((ChunkData)tsFileData);
        }

        private boolean addOrSendChunkData(ChunkData chunkData) {
            TRegionReplicaSet replicaSet = this.singleTsFileNode.getDataPartition().getDataRegionReplicaSetForWriting(chunkData.getDevice(), chunkData.getTimePartitionSlot());
            this.dataSize += (long)(1 + replicaSet.getDataNodeLocationsSize()) * chunkData.getDataSize();
            if (this.dataSize > MAX_MEMORY_SIZE) {
                TRegionReplicaSet sortedReplicaSet;
                LoadTsFilePieceNode pieceNode;
                List sortedReplicaSets = this.replicaSet2Piece.keySet().stream().sorted(Comparator.comparingLong(o -> this.replicaSet2Piece.get(o).getDataSize()).reversed()).collect(Collectors.toList());
                Iterator iterator = sortedReplicaSets.iterator();
                while (iterator.hasNext() && (pieceNode = this.replicaSet2Piece.get(sortedReplicaSet = (TRegionReplicaSet)iterator.next())).getDataSize() != 0L) {
                    if (!this.scheduler.dispatchOnePieceNode(pieceNode, sortedReplicaSet)) {
                        return false;
                    }
                    this.dataSize -= (long)(1 + sortedReplicaSet.getDataNodeLocationsSize()) * pieceNode.getDataSize();
                    this.replicaSet2Piece.put(sortedReplicaSet, new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile()));
                    if (this.dataSize > MAX_MEMORY_SIZE) continue;
                    break;
                }
            }
            this.replicaSet2Piece.computeIfAbsent(replicaSet, o -> new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile())).addTsFileData(chunkData);
            return true;
        }

        private boolean addOrSendDeletionData(TsFileData deletionData) {
            for (Map.Entry<TRegionReplicaSet, LoadTsFilePieceNode> entry : this.replicaSet2Piece.entrySet()) {
                this.dataSize += deletionData.getDataSize();
                entry.getValue().addTsFileData(deletionData);
            }
            return true;
        }

        private boolean sendAllTsFileData() {
            for (Map.Entry<TRegionReplicaSet, LoadTsFilePieceNode> entry : this.replicaSet2Piece.entrySet()) {
                if (this.scheduler.dispatchOnePieceNode(entry.getValue(), entry.getKey())) continue;
                logger.warn(String.format("Dispatch piece node %s of TsFile %s error.", entry.getValue(), this.singleTsFileNode.getTsFileResource().getTsFile()));
                return false;
            }
            return true;
        }
    }

    public static enum LoadCommand {
        EXECUTE,
        ROLLBACK;

    }
}

