/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import com.google.common.util.concurrent.Futures;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.mpp.execution.executor.RegionReadExecutor;
import org.apache.iotdb.db.mpp.execution.executor.RegionWriteExecutor;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceDispatcher;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstance;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceDispatcherImpl
implements IFragInstanceDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(FragmentInstanceDispatcherImpl.class);
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final QueryType type;
    private final MPPQueryContext queryContext;
    private final String localhostIpAddr;
    private final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public FragmentInstanceDispatcherImpl(QueryType type, MPPQueryContext queryContext, ExecutorService executor, ExecutorService writeOperationExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.type = type;
        this.queryContext = queryContext;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.internalServiceClientManager = internalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    @Override
    public Future<FragInstanceDispatchResult> dispatch(List<FragmentInstance> instances) {
        if (this.type == QueryType.READ) {
            return this.dispatchRead(instances);
        }
        return this.dispatchWriteSync(instances);
    }

    private Future<FragInstanceDispatchResult> dispatchRead(List<FragmentInstance> instances) {
        return this.executor.submit(() -> {
            for (FragmentInstance instance : instances) {
                try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId());){
                    this.dispatchOneInstance(instance);
                }
                catch (FragmentInstanceDispatchException e) {
                    return new FragInstanceDispatchResult(e.getFailureStatus());
                }
                catch (Throwable t) {
                    logger.warn("[DispatchFailed]", t);
                    return new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage())));
                }
            }
            return new FragInstanceDispatchResult(true);
        });
    }

    private Future<FragInstanceDispatchResult> dispatchWriteSync(List<FragmentInstance> instances) {
        for (FragmentInstance instance : instances) {
            try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId());){
                this.dispatchOneInstance(instance);
            }
            catch (FragmentInstanceDispatchException e) {
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(e.getFailureStatus()));
            }
            catch (Throwable t) {
                logger.warn("[DispatchFailed]", t);
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage()))));
            }
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
    }

    private void dispatchOneInstance(FragmentInstance instance) throws FragmentInstanceDispatchException {
        TEndPoint endPoint = instance.getHostDataNode().getInternalEndPoint();
        if (this.isDispatchedToLocal(endPoint)) {
            this.dispatchLocally(instance);
        } else {
            this.dispatchRemote(instance, endPoint);
        }
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    private void dispatchRemote(FragmentInstance instance, TEndPoint endPoint) throws FragmentInstanceDispatchException {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            switch (instance.getType()) {
                case READ: {
                    TSendFragmentInstanceReq sendFragmentInstanceReq = new TSendFragmentInstanceReq(new TFragmentInstance(instance.serializeToByteBuffer()));
                    if (instance.getExecutorType().isStorageExecutor()) {
                        sendFragmentInstanceReq.setConsensusGroupId(instance.getRegionReplicaSet().getRegionId());
                    }
                    TSendFragmentInstanceResp sendFragmentInstanceResp = client.sendFragmentInstance(sendFragmentInstanceReq);
                    if (!sendFragmentInstanceResp.accepted) {
                        logger.warn(sendFragmentInstanceResp.message);
                        throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)sendFragmentInstanceResp.message));
                    }
                    break;
                }
                case WRITE: {
                    TSendPlanNodeReq sendPlanNodeReq = new TSendPlanNodeReq(new TPlanNode(instance.getFragment().getPlanNodeTree().serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId());
                    TSendPlanNodeResp sendPlanNodeResp = client.sendPlanNode(sendPlanNodeReq);
                    if (!sendPlanNodeResp.accepted) {
                        logger.warn("dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{sendPlanNodeResp.status, TSStatusCode.representOf((int)sendPlanNodeResp.status.code), sendPlanNodeResp.message, endPoint});
                        if (sendPlanNodeResp.getStatus() == null) {
                            throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)sendPlanNodeResp.getMessage()));
                        }
                        throw new FragmentInstanceDispatchException(sendPlanNodeResp.getStatus());
                    }
                    break;
                }
                default: {
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown query type [%s]", new Object[]{instance.getType()})));
                }
            }
        }
        catch (ClientManagerException | TException e) {
            logger.warn("can't connect to node {}", (Object)endPoint, (Object)e);
            TSStatus status = new TSStatus();
            status.setCode(TSStatusCode.SYNC_CONNECTION_ERROR.getStatusCode());
            status.setMessage("can't connect to node " + endPoint);
            this.queryContext.addFailedEndPoint(endPoint);
            throw new FragmentInstanceDispatchException(status);
        }
    }

    private void dispatchLocally(FragmentInstance instance) throws FragmentInstanceDispatchException {
        ConsensusGroupId groupId = null;
        if (instance.getExecutorType().isStorageExecutor()) {
            try {
                groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)instance.getRegionReplicaSet().getRegionId());
            }
            catch (Throwable t) {
                logger.warn("Deserialize ConsensusGroupId failed. ", t);
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Deserialize ConsensusGroupId failed: " + t.getMessage())));
            }
        }
        switch (instance.getType()) {
            case READ: {
                RegionExecutionResult readResult;
                RegionReadExecutor readExecutor = new RegionReadExecutor();
                RegionExecutionResult regionExecutionResult = readResult = groupId == null ? readExecutor.execute(instance) : readExecutor.execute(groupId, instance);
                if (readResult.isAccepted()) break;
                logger.warn(readResult.getMessage());
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)readResult.getMessage()));
            }
            case WRITE: {
                PlanNode planNode = instance.getFragment().getPlanNodeTree();
                RegionWriteExecutor writeExecutor = new RegionWriteExecutor();
                RegionExecutionResult writeResult = writeExecutor.execute(groupId, planNode);
                if (writeResult.isAccepted()) break;
                logger.warn("write locally failed. TSStatus: {}, message: {}", (Object)writeResult.getStatus(), (Object)writeResult.getMessage());
                if (writeResult.getStatus() == null) {
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)writeResult.getMessage()));
                }
                throw new FragmentInstanceDispatchException(writeResult.getStatus());
            }
            default: {
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown query type [%s]", new Object[]{instance.getType()})));
            }
        }
    }

    @Override
    public void abort() {
    }
}

