/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceStateTracker;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceInfoReq;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceInfoResp;
import org.apache.thrift.TException;

public abstract class AbstractFragInsStateTracker
implements IFragInstanceStateTracker {
    protected QueryStateMachine stateMachine;
    protected ScheduledExecutorService scheduledExecutor;
    protected List<FragmentInstance> instances;
    protected final String localhostIpAddr;
    protected final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public AbstractFragInsStateTracker(QueryStateMachine stateMachine, ScheduledExecutorService scheduledExecutor, List<FragmentInstance> instances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.stateMachine = stateMachine;
        this.scheduledExecutor = scheduledExecutor;
        this.instances = instances;
        this.internalServiceClientManager = internalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    @Override
    public abstract void start();

    @Override
    public abstract void abort();

    protected FragmentInstanceInfo fetchInstanceInfo(FragmentInstance instance) throws ClientManagerException, TException {
        TEndPoint endPoint = instance.getHostDataNode().internalEndPoint;
        if (this.isInstanceRunningLocally(endPoint)) {
            FragmentInstanceInfo info = FragmentInstanceManager.getInstance().getInstanceInfo(instance.getId());
            if (info != null) {
                return info;
            }
            return new FragmentInstanceInfo(FragmentInstanceState.NO_SUCH_INSTANCE);
        }
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            TFragmentInstanceInfoResp resp = client.fetchFragmentInstanceInfo(new TFetchFragmentInstanceInfoReq(this.getTId(instance)));
            String failedMessage = "";
            if (resp.getFailedMessages() != null) {
                failedMessage = String.join((CharSequence)";", resp.getFailedMessages());
            }
            ArrayList<FragmentInstanceFailureInfo> failureInfoList = new ArrayList<FragmentInstanceFailureInfo>();
            if (resp.getFailureInfoList() != null) {
                for (ByteBuffer buffer : resp.getFailureInfoList()) {
                    failureInfoList.add(FragmentInstanceFailureInfo.deserialize(buffer));
                }
            }
            FragmentInstanceInfo fragmentInstanceInfo = new FragmentInstanceInfo(FragmentInstanceState.valueOf(resp.getState()), resp.getEndTime(), failedMessage, failureInfoList);
            return fragmentInstanceInfo;
        }
    }

    private boolean isInstanceRunningLocally(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    private TFragmentInstanceId getTId(FragmentInstance instance) {
        return new TFragmentInstanceId(instance.getId().getQueryId().getId(), instance.getId().getFragmentId().getId(), instance.getId().getInstanceId());
    }
}

