/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.QueryExecutor;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.constant.DataNodeEndPoints;
import org.apache.iotdb.db.mpp.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFragmentParallelPlanner
implements IFragmentParallelPlaner {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFragmentParallelPlanner.class);
    private SubPlan subPlan;
    private Analysis analysis;
    private MPPQueryContext queryContext;
    Map<PlanFragmentId, FragmentInstance> instanceMap;
    Map<PlanNodeId, PlanFragmentId> planNodeMap;
    List<FragmentInstance> fragmentInstanceList;

    public SimpleFragmentParallelPlanner(SubPlan subPlan, Analysis analysis, MPPQueryContext context) {
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = context;
        this.instanceMap = new HashMap<PlanFragmentId, FragmentInstance>();
        this.planNodeMap = new HashMap<PlanNodeId, PlanFragmentId>();
        this.fragmentInstanceList = new ArrayList<FragmentInstance>();
    }

    @Override
    public List<FragmentInstance> parallelPlan() {
        this.prepare();
        this.calculateNodeTopologyBetweenInstance();
        return this.fragmentInstanceList;
    }

    private void prepare() {
        List<PlanFragment> fragments = this.subPlan.getPlanFragmentList();
        for (PlanFragment fragment : fragments) {
            this.recordPlanNodeRelation(fragment.getPlanNodeTree(), fragment.getId());
            this.produceFragmentInstance(fragment);
        }
    }

    private void produceFragmentInstance(PlanFragment fragment) {
        PlanNode rootCopy = PlanNodeUtil.deepCopy(fragment.getPlanNodeTree());
        Filter timeFilter = this.analysis.getGlobalTimeFilter();
        FragmentInstance fragmentInstance = new FragmentInstance(new PlanFragment(fragment.getId(), rootCopy), fragment.getId().genFragmentInstanceId(), timeFilter, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession(), fragment.isRoot());
        TRegionReplicaSet regionReplicaSet = fragment.getTargetRegion();
        if ((this.analysis.getDataPartitionInfo() == null || this.analysis.getDataPartitionInfo().isEmpty()) && this.analysis.getStatement() instanceof QueryStatement && ((QueryStatement)this.analysis.getStatement()).isAggregationQuery()) {
            fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(new TDataNodeLocation().setInternalEndPoint(DataNodeEndPoints.LOCAL_HOST_INTERNAL_ENDPOINT).setMPPDataExchangeEndPoint(DataNodeEndPoints.LOCAL_HOST_DATA_BLOCK_ENDPOINT)));
        } else {
            fragmentInstance.setExecutorAndHost((ExecutorType)new StorageExecutor(regionReplicaSet));
            fragmentInstance.setHostDataNode(this.selectTargetDataNode(regionReplicaSet));
        }
        if (this.analysis.getStatement() instanceof QueryStatement) {
            fragmentInstance.getFragment().generateTypeProvider(this.queryContext.getTypeProvider());
        }
        this.instanceMap.putIfAbsent(fragment.getId(), fragmentInstance);
        this.fragmentInstanceList.add(fragmentInstance);
    }

    private TDataNodeLocation selectTargetDataNode(TRegionReplicaSet regionReplicaSet) {
        if (regionReplicaSet == null || regionReplicaSet.getDataNodeLocations() == null || regionReplicaSet.getDataNodeLocations().size() == 0) {
            throw new IllegalArgumentException(String.format("regionReplicaSet is invalid: %s", regionReplicaSet));
        }
        String readConsistencyLevel = IoTDBDescriptor.getInstance().getConfig().getReadConsistencyLevel();
        boolean selectRandomDataNode = "weak".equals(readConsistencyLevel);
        List<TDataNodeLocation> availableDataNodes = this.filterAvailableTDataNode(regionReplicaSet.getDataNodeLocations());
        if (availableDataNodes.size() == 0) {
            String errorMsg = String.format("all replicas for region[%s] are not available in these DataNodes[%s]", regionReplicaSet.getRegionId(), regionReplicaSet.getDataNodeLocations());
            throw new IllegalArgumentException(errorMsg);
        }
        if (regionReplicaSet.getDataNodeLocationsSize() != availableDataNodes.size()) {
            logger.info("available replicas: " + availableDataNodes);
        }
        int targetIndex = !selectRandomDataNode || this.queryContext.getSession() == null ? 0 : (int)(this.queryContext.getSession().getSessionId() % (long)availableDataNodes.size());
        return availableDataNodes.get(targetIndex);
    }

    private List<TDataNodeLocation> filterAvailableTDataNode(List<TDataNodeLocation> originalDataNodeList) {
        LinkedList<TDataNodeLocation> result = new LinkedList<TDataNodeLocation>();
        for (TDataNodeLocation dataNodeLocation : originalDataNodeList) {
            if (!this.isAvailableDataNode(dataNodeLocation)) continue;
            result.add(dataNodeLocation);
        }
        return result;
    }

    private boolean isAvailableDataNode(TDataNodeLocation dataNodeLocation) {
        for (TEndPoint endPoint : this.queryContext.getEndPointBlackList()) {
            if (!endPoint.equals(dataNodeLocation.internalEndPoint)) continue;
            return false;
        }
        return true;
    }

    private void calculateNodeTopologyBetweenInstance() {
        for (FragmentInstance instance : this.fragmentInstanceList) {
            PlanNode rootNode = instance.getFragment().getPlanNodeTree();
            if (!(rootNode instanceof FragmentSinkNode)) continue;
            FragmentSinkNode sinkNode = (FragmentSinkNode)rootNode;
            PlanNodeId downStreamNodeId = sinkNode.getDownStreamPlanNodeId();
            FragmentInstance downStreamInstance = this.findDownStreamInstance(downStreamNodeId);
            sinkNode.setDownStream(downStreamInstance.getHostDataNode().getMPPDataExchangeEndPoint(), downStreamInstance.getId(), downStreamNodeId);
            PlanNode downStreamExchangeNode = downStreamInstance.getFragment().getPlanNodeById(downStreamNodeId);
            ((ExchangeNode)downStreamExchangeNode).setUpstream(instance.getHostDataNode().getMPPDataExchangeEndPoint(), instance.getId(), sinkNode.getPlanNodeId());
        }
    }

    private FragmentInstance findDownStreamInstance(PlanNodeId exchangeNodeId) {
        return this.instanceMap.get(this.planNodeMap.get(exchangeNodeId));
    }

    private void recordPlanNodeRelation(PlanNode root, PlanFragmentId planFragmentId) {
        this.planNodeMap.put(root.getPlanNodeId(), planFragmentId);
        for (PlanNode child : root.getChildren()) {
            this.recordPlanNodeRelation(child, planFragmentId);
        }
    }
}

