/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.join;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class VerticallyConcatOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final int inputOperatorsCount;
    private final TsBlock[] inputTsBlocks;
    private final int[] inputIndex;
    private final int outputColumnCount;
    private final TsBlockBuilder tsBlockBuilder;
    private boolean finished;

    public VerticallyConcatOperator(OperatorContext operatorContext, List<Operator> children, List<TSDataType> dataTypes) {
        Preconditions.checkArgument((children != null && children.size() > 0 ? 1 : 0) != 0, (Object)"child size of VerticallyConcatOperator should be larger than 0");
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.inputIndex = new int[this.inputOperatorsCount];
        this.outputColumnCount = dataTypes.size();
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            ListenableFuture<?> blocked;
            if (!this.empty(i) || (blocked = this.children.get(i).isBlocked()).isDone()) continue;
            listenableFutures.add(blocked);
        }
        return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() {
        this.tsBlockBuilder.reset();
        int maxRowCanBuild = Integer.MAX_VALUE;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.empty(i)) {
                this.inputIndex[i] = 0;
                this.inputTsBlocks[i] = this.children.get(i).next();
                if (this.empty(i)) {
                    return null;
                }
            }
            maxRowCanBuild = Math.min(maxRowCanBuild, this.inputTsBlocks[i].getPositionCount() - this.inputIndex[i]);
        }
        TimeColumn firstTimeColumn = this.inputTsBlocks[0].getTimeColumn();
        TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        int currTsBlockIndex = this.inputIndex[0];
        for (int row = 0; row < maxRowCanBuild; ++row) {
            timeColumnBuilder.writeLong(firstTimeColumn.getLong(currTsBlockIndex + row));
            this.tsBlockBuilder.declarePosition();
        }
        int valueBuilderIndex = 0;
        int i = 0;
        while (i < this.inputOperatorsCount) {
            currTsBlockIndex = this.inputIndex[i];
            for (Column column : this.inputTsBlocks[i].getValueColumns()) {
                for (int row = 0; row < maxRowCanBuild; ++row) {
                    if (column.isNull(currTsBlockIndex + row)) {
                        valueColumnBuilders[valueBuilderIndex].appendNull();
                        continue;
                    }
                    valueColumnBuilders[valueBuilderIndex].write(column, currTsBlockIndex + row);
                }
                ++valueBuilderIndex;
            }
            int n = i++;
            this.inputIndex[n] = this.inputIndex[n] + maxRowCanBuild;
        }
        return this.tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        return !this.empty(0) || this.children.get(0).hasNext();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    @Override
    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        this.finished = this.empty(0) && !this.children.get(0).hasNext();
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemory());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize(), childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        return (1L + (long)this.outputColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }

    private boolean empty(int tsBlockIndex) {
        return this.inputTsBlocks[tsBlockIndex] == null || this.inputTsBlocks[tsBlockIndex].getPositionCount() == this.inputIndex[tsBlockIndex];
    }
}

