/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.filter;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.common.filter.BasicFunctionFilter;
import org.apache.iotdb.db.mpp.common.filter.FunctionFilter;
import org.apache.iotdb.db.mpp.common.filter.InFilter;
import org.apache.iotdb.db.mpp.common.filter.LikeFilter;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.common.filter.RegexpFilter;

public class FilterDeserializeUtil {
    public static QueryFilter deserialize(ByteBuffer buffer) {
        byte filterType = buffer.get();
        switch (filterType) {
            case 0: {
                return QueryFilter.deserialize(buffer);
            }
            case 1: {
                return FunctionFilter.deserialize(buffer);
            }
            case 2: {
                return BasicFunctionFilter.deserialize(buffer);
            }
            case 3: {
                return InFilter.deserialize(buffer);
            }
            case 4: {
                return LikeFilter.deserialize(buffer);
            }
            case 5: {
                return RegexpFilter.deserialize(buffer);
            }
        }
        throw new IllegalArgumentException("Invalid filter type: " + filterType);
    }
}

