/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.filter;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.mpp.common.filter.BasicFilterType;
import org.apache.iotdb.db.mpp.common.filter.FilterTypes;
import org.apache.iotdb.db.mpp.common.filter.FunctionFilter;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.plan.constant.FilterConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.StringContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFunctionFilter
extends FunctionFilter {
    protected String value;
    private final Logger logger = LoggerFactory.getLogger(BasicFunctionFilter.class);
    private BasicFilterType funcToken;

    public BasicFunctionFilter(FilterConstant.FilterType filterType, PartialPath path, String value) throws SQLParserException {
        super(filterType);
        this.funcToken = BasicFilterType.getBasicOpBySymbol(filterType);
        this.singlePath = path;
        this.value = value;
        this.isLeaf = true;
        this.isSingle = true;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void reverseFunc() {
        FilterConstant.FilterType filterType = FilterConstant.filterReverseWords.get((Object)this.filterType);
        this.setFilterType(filterType);
        this.funcToken = BasicFilterType.getBasicOpBySymbol(filterType);
    }

    @Override
    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws StatementAnalyzeException, MetadataException {
        IUnaryExpression ret;
        TSDataType type = pathTSDataTypeHashMap.get(this.singlePath);
        if (type == null) {
            throw new MetadataException("given seriesPath:{" + this.singlePath.getFullPath() + "} don't exist in metadata");
        }
        switch (type) {
            case INT32: {
                ret = this.funcToken.getUnaryExpression((Path)this.singlePath, Integer.valueOf(this.value));
                break;
            }
            case INT64: {
                ret = this.funcToken.getUnaryExpression((Path)this.singlePath, Long.valueOf(this.value));
                break;
            }
            case BOOLEAN: {
                ret = this.funcToken.getUnaryExpression((Path)this.singlePath, Boolean.valueOf(this.value));
                break;
            }
            case FLOAT: {
                ret = this.funcToken.getUnaryExpression((Path)this.singlePath, Float.valueOf(this.value));
                break;
            }
            case DOUBLE: {
                ret = this.funcToken.getUnaryExpression((Path)this.singlePath, Double.valueOf(this.value));
                break;
            }
            case TEXT: {
                if (this.funcToken.equals((Object)BasicFilterType.EQ) || this.funcToken.equals((Object)BasicFilterType.NOTEQUAL)) {
                    ret = this.funcToken.getUnaryExpression((Path)this.singlePath, this.value.startsWith("'") && this.value.endsWith("'") || this.value.startsWith("\"") && this.value.endsWith("\"") ? new Binary(this.value.substring(1, this.value.length() - 1)) : new Binary(this.value));
                    break;
                }
                throw new StatementAnalyzeException("For Basic operator,TEXT type only support EQUAL or NOTEQUAL operator");
            }
            default: {
                throw new StatementAnalyzeException(type.toString(), "");
            }
        }
        return new Pair((Object)ret, (Object)this.singlePath.getFullPath());
    }

    @Override
    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.singlePath.getFullPath(), this.getFilterSymbol(), this.value, ", single\n"});
        return sc.toString();
    }

    @Override
    public BasicFunctionFilter copy() {
        BasicFunctionFilter ret;
        try {
            ret = new BasicFunctionFilter(this.filterType, this.singlePath.clone(), this.value);
        }
        catch (SQLParserException e) {
            this.logger.error("error copy:", (Throwable)e);
            return null;
        }
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        ret.pathSet = this.pathSet;
        return ret;
    }

    @Override
    public String toString() {
        return "[" + this.singlePath.getFullPath() + this.getFilterSymbol() + this.value + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicFunctionFilter that = (BasicFunctionFilter)o;
        return Objects.equals(this.singlePath, that.singlePath) && Objects.equals(this.value, that.value) && this.funcToken == that.funcToken;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.singlePath, this.value, this.funcToken});
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        FilterTypes.BasicFunction.serialize(byteBuffer);
        super.serializeWithoutType(byteBuffer);
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.funcToken.ordinal(), (ByteBuffer)byteBuffer);
    }

    public static BasicFunctionFilter deserialize(ByteBuffer byteBuffer) {
        QueryFilter queryFilter = QueryFilter.deserialize(byteBuffer);
        BasicFunctionFilter basicFunctionFilter = new BasicFunctionFilter(queryFilter.filterType, queryFilter.singlePath, ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        basicFunctionFilter.funcToken = BasicFilterType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        return basicFunctionFilter;
    }
}

