/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.container.IMNodeContainer;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;

public class MetaUtils {
    private MetaUtils() {
    }

    public static PartialPath getStorageGroupPathByLevel(PartialPath path, int level) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= level || !nodeNames[0].equals("root")) {
            throw new IllegalPathException(path.getFullPath());
        }
        String[] storageGroupNodes = new String[level + 1];
        System.arraycopy(nodeNames, 0, storageGroupNodes, 0, level + 1);
        return new PartialPath(storageGroupNodes);
    }

    public static List<PartialPath> groupAlignedPaths(List<PartialPath> fullPaths) {
        LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        AlignedPath alignedPath = null;
        for (PartialPath path : fullPaths) {
            MeasurementPath measurementPath = (MeasurementPath)path;
            if (!measurementPath.isUnderAlignedEntity()) {
                result.add((PartialPath)measurementPath);
                alignedPath = null;
                continue;
            }
            if (alignedPath == null || !alignedPath.equals(measurementPath.getDevice())) {
                alignedPath = new AlignedPath(measurementPath);
                result.add((PartialPath)alignedPath);
                continue;
            }
            alignedPath.addMeasurement(measurementPath);
        }
        return result;
    }

    public static List<PartialPath> groupAlignedSeries(List<PartialPath> fullPaths) {
        return MetaUtils.groupAlignedSeries(fullPaths, new HashMap<String, AlignedPath>());
    }

    public static List<PartialPath> groupAlignedSeriesWithOrder(List<PartialPath> fullPaths, OrderByParameter orderByParameter) {
        List<PartialPath> res = MetaUtils.groupAlignedSeries(fullPaths, new HashMap<String, AlignedPath>());
        res.sort(orderByParameter.getSortItemList().get(0).getOrdering() == Ordering.ASC ? Comparator.naturalOrder() : Comparator.reverseOrder());
        return res;
    }

    private static List<PartialPath> groupAlignedSeries(List<PartialPath> fullPaths, Map<String, AlignedPath> deviceToAlignedPathMap) {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        for (PartialPath path : fullPaths) {
            AlignedPath alignedPath;
            MeasurementPath measurementPath = (MeasurementPath)path;
            if (!measurementPath.isUnderAlignedEntity()) {
                result.add((PartialPath)measurementPath);
                continue;
            }
            String deviceName = measurementPath.getDevice();
            if (!deviceToAlignedPathMap.containsKey(deviceName)) {
                alignedPath = new AlignedPath(measurementPath);
                deviceToAlignedPathMap.put(deviceName, alignedPath);
                continue;
            }
            alignedPath = deviceToAlignedPathMap.get(deviceName);
            alignedPath.addMeasurement(measurementPath);
        }
        result.addAll(deviceToAlignedPathMap.values());
        return result;
    }

    public static List<String> getMultiFullPaths(IMNode node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<IMNode> lastNodeList = new ArrayList<IMNode>();
        MetaUtils.collectLastNode(node, lastNodeList);
        ArrayList<String> result = new ArrayList<String>();
        for (IMNode lastNode : lastNodeList) {
            result.add(lastNode.getFullPath());
        }
        return result;
    }

    public static void collectLastNode(IMNode node, List<IMNode> lastNodeList) {
        if (node != null) {
            IMNodeContainer children = node.getChildren();
            if (children.isEmpty()) {
                lastNodeList.add(node);
            }
            for (Map.Entry entry : children.entrySet()) {
                IMNode childNode = (IMNode)entry.getValue();
                MetaUtils.collectLastNode(childNode, lastNodeList);
            }
        }
    }

    public static Map<PartialPath, List<Integer>> groupAggregationsBySeries(List<? extends Path> selectedPaths) {
        HashMap<PartialPath, List<Integer>> pathToAggrIndexesMap = new HashMap<PartialPath, List<Integer>>();
        for (int i = 0; i < selectedPaths.size(); ++i) {
            PartialPath series = (PartialPath)selectedPaths.get(i);
            pathToAggrIndexesMap.computeIfAbsent(series, key -> new ArrayList()).add(i);
        }
        return pathToAggrIndexesMap;
    }

    public static Map<AlignedPath, List<List<Integer>>> groupAlignedSeriesWithAggregations(Map<PartialPath, List<Integer>> pathToAggrIndexesMap) {
        HashMap<AlignedPath, List<List<Integer>>> alignedPathToAggrIndexesMap = new HashMap<AlignedPath, List<List<Integer>>>();
        HashMap<String, AlignedPath> temp = new HashMap<String, AlignedPath>();
        ArrayList<PartialPath> seriesPaths = new ArrayList<PartialPath>(pathToAggrIndexesMap.keySet());
        for (PartialPath seriesPath : seriesPaths) {
            List subIndexes;
            AlignedPath groupPath;
            List<Integer> indexes;
            if (seriesPath instanceof AlignedPath) {
                indexes = pathToAggrIndexesMap.remove(seriesPath);
                groupPath = (AlignedPath)temp.get(seriesPath.getFullPath());
                if (groupPath == null) {
                    groupPath = (AlignedPath)seriesPath.copy();
                    temp.put(groupPath.getFullPath(), groupPath);
                    alignedPathToAggrIndexesMap.computeIfAbsent(groupPath, key -> new ArrayList()).add(indexes);
                    continue;
                }
                subIndexes = (List)alignedPathToAggrIndexesMap.remove(groupPath);
                subIndexes.add(indexes);
                groupPath.addMeasurements(((AlignedPath)seriesPath).getMeasurementList());
                groupPath.addSchemas(((AlignedPath)seriesPath).getSchemaList());
                alignedPathToAggrIndexesMap.put(groupPath, subIndexes);
                continue;
            }
            if (!((MeasurementPath)seriesPath).isUnderAlignedEntity()) continue;
            indexes = pathToAggrIndexesMap.remove(seriesPath);
            groupPath = (AlignedPath)temp.get(seriesPath.getDevice());
            if (groupPath == null) {
                groupPath = new AlignedPath((MeasurementPath)seriesPath);
                temp.put(seriesPath.getDevice(), groupPath);
                alignedPathToAggrIndexesMap.computeIfAbsent(groupPath, key -> new ArrayList()).add(indexes);
                continue;
            }
            subIndexes = (List)alignedPathToAggrIndexesMap.remove(groupPath);
            subIndexes.add(indexes);
            groupPath.addMeasurement((MeasurementPath)seriesPath);
            alignedPathToAggrIndexesMap.put(groupPath, subIndexes);
        }
        return alignedPathToAggrIndexesMap;
    }

    public static Map<PartialPath, List<AggregationDescriptor>> groupAlignedAggregations(Map<PartialPath, List<AggregationDescriptor>> pathToAggregations) {
        HashMap<PartialPath, List<AggregationDescriptor>> result = new HashMap<PartialPath, List<AggregationDescriptor>>();
        HashMap<String, List> deviceToAlignedPathsMap = new HashMap<String, List>();
        for (PartialPath partialPath : pathToAggregations.keySet()) {
            MeasurementPath measurementPath = (MeasurementPath)partialPath;
            if (!measurementPath.isUnderAlignedEntity()) {
                result.computeIfAbsent((PartialPath)measurementPath, key -> new ArrayList()).addAll((Collection)pathToAggregations.get(partialPath));
                continue;
            }
            deviceToAlignedPathsMap.computeIfAbsent(partialPath.getDevice(), key -> new ArrayList()).add(measurementPath);
        }
        for (Map.Entry entry : deviceToAlignedPathsMap.entrySet()) {
            List measurementPathList = (List)entry.getValue();
            AlignedPath alignedPath = null;
            ArrayList aggregationDescriptorList = new ArrayList();
            for (int i = 0; i < measurementPathList.size(); ++i) {
                MeasurementPath measurementPath = (MeasurementPath)measurementPathList.get(i);
                if (i == 0) {
                    alignedPath = new AlignedPath(measurementPath);
                } else {
                    alignedPath.addMeasurement(measurementPath);
                }
                aggregationDescriptorList.addAll(pathToAggregations.get(measurementPath));
            }
            result.put((PartialPath)alignedPath, aggregationDescriptorList);
        }
        return result;
    }

    public static Pair<String, String> parseDeadbandInfo(Map<String, String> props) {
        if (props == null) {
            return new Pair(null, null);
        }
        String deadband = props.get("loss");
        deadband = deadband == null ? null : deadband.toUpperCase(Locale.ROOT);
        HashMap<String, String> deadbandParameters = new HashMap<String, String>();
        for (String k : IoTDBConstant.SDT_PARAMETERS) {
            if (!props.containsKey(k)) continue;
            deadbandParameters.put(k, props.get(k));
        }
        return new Pair((Object)deadband, deadbandParameters.isEmpty() ? null : String.format("%s", deadbandParameters));
    }
}

