/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.Objects;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;
import org.apache.iotdb.db.metadata.rescon.SchemaStatisticsManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaResourceManagerMetrics
implements IMetricSet {
    private final SchemaStatisticsManager schemaStatisticsManager;
    private final MemoryStatistics memoryStatistics;

    public SchemaResourceManagerMetrics(SchemaStatisticsManager schemaStatisticsManager, MemoryStatistics memoryStatistics) {
        this.schemaStatisticsManager = schemaStatisticsManager;
        this.memoryStatistics = memoryStatistics;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, (Object)this.schemaStatisticsManager, SchemaStatisticsManager::getTotalSeriesNumber, new String[]{Tag.NAME.toString(), "timeSeries"});
        metricService.createAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, (Object)this.memoryStatistics, MemoryStatistics::getMemoryUsage, new String[]{Tag.NAME.toString(), "schema_region_total_usage"});
        metricService.createAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, (Object)this.memoryStatistics, memoryStatistics -> memoryStatistics.getMemoryCapacity() - memoryStatistics.getMemoryUsage(), new String[]{Tag.NAME.toString(), "schema_region_total_remaining"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUANTITY.toString(), new String[]{Tag.NAME.toString(), "timeSeries"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), "schema_region_total_usage"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), "schema_region_total_remaining"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaResourceManagerMetrics that = (SchemaResourceManagerMetrics)o;
        return Objects.equals(this.schemaStatisticsManager, that.schemaStatisticsManager);
    }

    public int hashCode() {
        return Objects.hash(this.schemaStatisticsManager);
    }
}

