/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;

public abstract class EntityCollector<T>
extends CollectorTraverser<T> {
    public EntityCollector(IMNode startNode, PartialPath path, IMTreeStore store) throws MetadataException {
        super(startNode, path, store);
    }

    public EntityCollector(IMNode startNode, PartialPath path, IMTreeStore store, int limit, int offset) throws MetadataException {
        super(startNode, path, store, limit, offset);
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (node.isEntity()) {
            if (this.hasLimit) {
                ++this.curOffset;
                if (this.curOffset < this.offset) {
                    return true;
                }
            }
            this.collectEntity(node.getAsEntityMNode());
            if (this.hasLimit) {
                ++this.count;
            }
        }
        return false;
    }

    protected abstract void collectEntity(IEntityMNode var1) throws MetadataException;
}

