/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.CachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaFile;

public class MockSchemaFile
implements ISchemaFile {
    private PartialPath storageGroupPath;
    private IStorageGroupMNode storageGroupMNode;
    private long fileTail = 0L;
    private final Map<Long, Map<String, IMNode>> mockFile = new HashMap<Long, Map<String, IMNode>>();

    public MockSchemaFile(PartialPath storageGroupPath) {
        this.storageGroupPath = storageGroupPath;
    }

    @Override
    public IMNode init() {
        this.storageGroupMNode = new StorageGroupMNode(null, this.storageGroupPath.getTailNode(), CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
        this.writeMNode(this.storageGroupMNode);
        return MockSchemaFile.cloneMNode(this.storageGroupMNode);
    }

    @Override
    public boolean updateStorageGroupNode(IStorageGroupMNode sgNode) throws IOException {
        this.storageGroupMNode = MockSchemaFile.cloneMNode(sgNode).getAsStorageGroupMNode();
        return true;
    }

    @Override
    public IMNode getChildNode(IMNode parent, String childName) {
        Map<String, IMNode> segment = this.getSegment(parent);
        IMNode result = null;
        if (segment != null && (result = MockSchemaFile.cloneMNode(segment.get(childName))) == null && parent.isEntity()) {
            for (IMNode node : segment.values()) {
                if (!node.isMeasurement() || !childName.equals(node.getAsMeasurementMNode().getAlias())) continue;
                result = MockSchemaFile.cloneMNode(node);
                break;
            }
        }
        return result;
    }

    @Override
    public Iterator<IMNode> getChildren(IMNode parent) {
        Map<String, IMNode> segment = this.getSegment(parent);
        if (segment == null) {
            return Collections.emptyIterator();
        }
        return new MockSchemaFileIterator(this.getSegment(parent).values().iterator());
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        return false;
    }

    @Override
    public void writeMNode(IMNode parent) {
        ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
        long address = container.getSegmentAddress();
        if (container.isVolatile()) {
            address = this.allocateSegment();
            container.setSegmentAddress(address);
        }
        this.write(address, container.getUpdatedChildBuffer());
        this.write(address, container.getNewChildBuffer());
    }

    private void write(long address, Map<String, IMNode> nodeMap) {
        for (IMNode node : nodeMap.values()) {
            ICachedMNodeContainer container;
            if (!node.isMeasurement() && (container = ICachedMNodeContainer.getCachedMNodeContainer(node)).isVolatile()) {
                container.setSegmentAddress(this.allocateSegment());
            }
            this.mockFile.get(address).put(node.getName(), MockSchemaFile.cloneMNode(node));
        }
    }

    @Override
    public void delete(IMNode targetNode) {
        IMNode removedNode = this.getSegment(targetNode.getParent()).remove(targetNode.getName());
        if (removedNode == null || removedNode.isMeasurement()) {
            return;
        }
        this.deleteMNodeRecursively(removedNode);
    }

    private void deleteMNodeRecursively(IMNode node) {
        ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(node);
        Map<String, IMNode> removedSegment = this.mockFile.remove(container.getSegmentAddress());
        if (removedSegment != null) {
            for (IMNode child : removedSegment.values()) {
                this.deleteMNodeRecursively(child);
            }
        }
    }

    @Override
    public void sync() {
    }

    @Override
    public void close() {
    }

    @Override
    public void clear() {
        this.mockFile.clear();
    }

    private long getSegmentAddress(IMNode node) {
        return ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress();
    }

    private Map<String, IMNode> getSegment(IMNode node) {
        return this.mockFile.get(this.getSegmentAddress(node));
    }

    private long allocateSegment() {
        long address = this.fileTail++;
        this.mockFile.put(address, new ConcurrentHashMap());
        return address;
    }

    static IMNode cloneMNode(IMNode node) {
        if (node == null) {
            return null;
        }
        if (node.isMeasurement()) {
            IMeasurementMNode measurementMNode = node.getAsMeasurementMNode();
            IMeasurementMNode result = MeasurementMNode.getMeasurementMNode(null, measurementMNode.getName(), measurementMNode.getSchema(), measurementMNode.getAlias());
            result.setOffset(measurementMNode.getOffset());
            return result;
        }
        if (node.isStorageGroup() && node.isEntity()) {
            StorageGroupEntityMNode result = new StorageGroupEntityMNode(null, node.getName(), node.getAsStorageGroupMNode().getDataTTL());
            result.setAligned(node.getAsEntityMNode().isAligned());
            MockSchemaFile.cloneInternalMNodeData(node, result);
            return result;
        }
        if (node.isEntity()) {
            EntityMNode result = new EntityMNode(null, node.getName());
            result.setAligned(node.getAsEntityMNode().isAligned());
            MockSchemaFile.cloneInternalMNodeData(node, result);
            return result;
        }
        if (node.isStorageGroup()) {
            StorageGroupMNode result = new StorageGroupMNode(null, node.getName(), node.getAsStorageGroupMNode().getDataTTL());
            MockSchemaFile.cloneInternalMNodeData(node, result);
            return result;
        }
        InternalMNode result = new InternalMNode(null, node.getName());
        MockSchemaFile.cloneInternalMNodeData(node, result);
        return result;
    }

    private static void cloneInternalMNodeData(IMNode node, IMNode result) {
        result.setUseTemplate(node.isUseTemplate());
        CachedMNodeContainer container = new CachedMNodeContainer();
        container.setSegmentAddress(ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress());
        result.setChildren(container);
    }

    private class MockSchemaFileIterator
    implements Iterator<IMNode> {
        Iterator<IMNode> iterator;

        MockSchemaFileIterator(Iterator<IMNode> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public IMNode next() {
            return MockSchemaFile.cloneMNode(this.iterator.next());
        }
    }
}

