/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementInBlackListException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.template.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.IMTreeBelowSG;
import org.apache.iotdb.db.metadata.mtree.store.CachedMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.CounterTraverser;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MNodeLevelCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementGroupByLevelCounter;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MTreeBelowSGCachedImpl
implements IMTreeBelowSG {
    private final CachedMTreeStore store;
    private volatile IStorageGroupMNode storageGroupMNode;
    private final Function<IMeasurementMNode, Map<String, String>> tagGetter;
    private final int levelOfSG;

    public MTreeBelowSGCachedImpl(PartialPath storageGroupPath, Function<IMeasurementMNode, Map<String, String>> tagGetter, int schemaRegionId) throws MetadataException, IOException {
        this.tagGetter = tagGetter;
        this.store = new CachedMTreeStore(storageGroupPath, schemaRegionId);
        this.storageGroupMNode = this.store.getRoot().getAsStorageGroupMNode();
        this.storageGroupMNode.setParent(this.generatePrefix(storageGroupPath));
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
    }

    private IMNode generatePrefix(PartialPath storageGroupPath) {
        String[] nodes = storageGroupPath.getNodes();
        InternalMNode cur = new InternalMNode(null, nodes[0]);
        for (int i = 1; i < nodes.length - 1; ++i) {
            InternalMNode child = new InternalMNode(cur, nodes[i]);
            cur.addChild(nodes[i], child);
            cur = child;
        }
        return cur;
    }

    private MTreeBelowSGCachedImpl(PartialPath storageGroupPath, CachedMTreeStore store, final Consumer<IMeasurementMNode> measurementProcess, Function<IMeasurementMNode, Map<String, String>> tagGetter) throws MetadataException {
        this.store = store;
        this.storageGroupMNode = store.getRoot().getAsStorageGroupMNode();
        this.storageGroupMNode.setParent(this.generatePrefix(storageGroupPath));
        this.levelOfSG = this.storageGroupMNode.getPartialPath().getNodeLength() - 1;
        this.tagGetter = tagGetter;
        MeasurementCollector<Void> collector = new MeasurementCollector<Void>((IMNode)this.storageGroupMNode, new PartialPath(this.storageGroupMNode.getFullPath()), (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                measurementProcess.accept(node);
            }
        };
        collector.setPrefixMatch(true);
        collector.traverse();
    }

    @Override
    public void clear() {
        this.store.clear();
        this.storageGroupMNode = null;
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        return this.store.createSnapshot(snapshotDir);
    }

    public static MTreeBelowSGCachedImpl loadFromSnapshot(File snapshotDir, String storageGroupFullPath, int schemaRegionId, Consumer<IMeasurementMNode> measurementProcess, Function<IMeasurementMNode, Map<String, String>> tagGetter) throws IOException, MetadataException {
        return new MTreeBelowSGCachedImpl(new PartialPath(storageGroupFullPath), CachedMTreeStore.loadFromSnapshot(snapshotDir, storageGroupFullPath, schemaRegionId), measurementProcess, tagGetter);
    }

    @Override
    public IMeasurementMNode createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        IMeasurementMNode measurementMNode = this.createTimeseriesWithPinnedReturn(path, dataType, encoding, compressor, props, alias);
        this.unPinMNode(measurementMNode);
        return measurementMNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode createTimeseriesWithPinnedReturn(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        IMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        try {
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                IMeasurementMNode iMeasurementMNode;
                IMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
                try {
                    IEntityMNode entityMNode;
                    MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
                    String leafName = path.getMeasurement();
                    if (alias != null && this.store.hasChild(device, alias)) {
                        throw new AliasAlreadyExistException(path.getFullPath(), alias);
                    }
                    if (this.store.hasChild(device, leafName)) {
                        throw new PathAlreadyExistException(path.getFullPath());
                    }
                    if (device.isEntity() && device.getAsEntityMNode().isAligned()) {
                        throw new AlignedTimeseriesException("timeseries under this entity is aligned, please use createAlignedTimeseries or change entity.", device.getFullPath());
                    }
                    if (device.isEntity()) {
                        entityMNode = device.getAsEntityMNode();
                    } else {
                        entityMNode = this.store.setToEntity(device);
                        if (entityMNode.isStorageGroup()) {
                            this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
                        }
                        device = entityMNode;
                    }
                    IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
                    this.store.addChild(entityMNode, leafName, measurementMNode);
                    if (alias != null) {
                        entityMNode.addAlias(alias, measurementMNode);
                    }
                    iMeasurementMNode = measurementMNode;
                    this.unPinMNode(device);
                }
                catch (Throwable throwable) {
                    this.unPinMNode(device);
                    throw throwable;
                }
                return iMeasurementMNode;
            }
        }
        finally {
            if (deviceParent != null) {
                this.unPinMNode(deviceParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMeasurementMNode> createAlignedTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList) throws MetadataException {
        ArrayList<IMeasurementMNode> measurementMNodeList = new ArrayList<IMeasurementMNode>();
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        IMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        try {
            MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
            synchronized (mTreeBelowSGCachedImpl) {
                ArrayList<IMeasurementMNode> arrayList;
                IMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
                try {
                    IEntityMNode entityMNode;
                    for (int i = 0; i < measurements.size(); ++i) {
                        if (this.store.hasChild(device, measurements.get(i))) {
                            throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i));
                        }
                        if (aliasList == null || aliasList.get(i) == null || !this.store.hasChild(device, aliasList.get(i))) continue;
                        throw new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), aliasList.get(i));
                    }
                    if (device.isEntity() && !device.getAsEntityMNode().isAligned()) {
                        throw new AlignedTimeseriesException("Timeseries under this entity is not aligned, please use createTimeseries or change entity.", devicePath.getFullPath());
                    }
                    if (device.isEntity()) {
                        entityMNode = device.getAsEntityMNode();
                    } else {
                        entityMNode = this.store.setToEntity(device);
                        entityMNode.setAligned(true);
                        if (entityMNode.isStorageGroup()) {
                            this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
                        }
                        device = entityMNode;
                    }
                    for (int i = 0; i < measurements.size(); ++i) {
                        IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), aliasList == null ? null : aliasList.get(i));
                        this.store.addChild(entityMNode, measurements.get(i), measurementMNode);
                        if (aliasList != null && aliasList.get(i) != null) {
                            entityMNode.addAlias(aliasList.get(i), measurementMNode);
                        }
                        measurementMNodeList.add(measurementMNode);
                    }
                    arrayList = measurementMNodeList;
                    this.unPinMNode(device);
                }
                catch (Throwable throwable) {
                    this.unPinMNode(device);
                    throw throwable;
                }
                return arrayList;
            }
        }
        finally {
            if (deviceParent != null) {
                this.unPinMNode(deviceParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        IMNode device = null;
        try {
            device = this.getNodeByPath(devicePath);
        }
        catch (MetadataException e) {
            return Collections.emptyMap();
        }
        try {
            if (!device.isEntity()) {
                Map<Integer, MetadataException> e = Collections.emptyMap();
                return e;
            }
            HashMap<Integer, MetadataException> failingMeasurementMap = new HashMap<Integer, MetadataException>();
            for (int i = 0; i < measurementList.size(); ++i) {
                IMNode node = null;
                try {
                    node = this.store.getChild(device, measurementList.get(i));
                    if (node != null) {
                        if (node.isMeasurement()) {
                            if (node.getAsMeasurementMNode().isPreDeleted()) {
                                failingMeasurementMap.put(i, new MeasurementInBlackListException(devicePath.concatNode(measurementList.get(i))));
                            } else {
                                failingMeasurementMap.put(i, new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), node.getAsMeasurementMNode().getMeasurementPath()));
                            }
                        } else {
                            failingMeasurementMap.put(i, new PathAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i)));
                        }
                    }
                    if (aliasList != null && aliasList.get(i) != null && this.store.hasChild(device, aliasList.get(i))) {
                        failingMeasurementMap.put(i, new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), aliasList.get(i)));
                    }
                    if (node == null) continue;
                    this.unPinMNode(node);
                    continue;
                }
                catch (MetadataException e) {
                    try {
                        failingMeasurementMap.put(i, e);
                        if (node == null) continue;
                        this.unPinMNode(node);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (node != null) {
                            this.unPinMNode(node);
                        }
                        throw throwable;
                    }
                }
            }
            HashMap<Integer, MetadataException> hashMap = failingMeasurementMap;
            return hashMap;
        }
        finally {
            this.unPinMNode(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMNode checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        MetaFormatUtils.checkTimeseries(devicePath);
        if (nodeNames.length == this.levelOfSG + 1) {
            return null;
        }
        IMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodeNames.length - 1; ++i) {
                String childName = nodeNames[i];
                IMNode child = this.store.getChild(cur, childName);
                if (child == null) {
                    child = this.store.addChild(cur, childName, new InternalMNode(cur, childName));
                }
                if (!(cur = child).isMeasurement()) continue;
                throw new PathAlreadyExistException(cur.getFullPath());
            }
            this.pinMNode(cur);
            IStorageGroupMNode iStorageGroupMNode = cur;
            return iStorageGroupMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    private IMNode checkAndAutoCreateDeviceNode(String deviceName, IMNode deviceParent) throws MetadataException {
        if (deviceParent == null) {
            this.pinMNode(this.storageGroupMNode);
            return this.storageGroupMNode;
        }
        IMNode device = this.store.getChild(deviceParent, deviceName);
        if (device == null) {
            device = this.store.addChild(deviceParent, deviceName, new InternalMNode(deviceParent, deviceName));
        }
        if (device.isMeasurement()) {
            throw new PathAlreadyExistException(device.getFullPath());
        }
        return device;
    }

    @Override
    public Pair<PartialPath, IMeasurementMNode> deleteTimeseriesAndReturnEmptyStorageGroup(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMeasurementMNode deletedNode = this.getMeasurementMNode(path);
        IEntityMNode parent = deletedNode.getParent();
        this.store.deleteChild(parent, path.getMeasurement());
        if (deletedNode.getAlias() != null) {
            parent.addAlias(deletedNode.getAlias(), deletedNode);
        }
        return new Pair((Object)this.deleteEmptyInternalMNodeAndReturnEmptyStorageGroup(parent), (Object)deletedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartialPath deleteEmptyInternalMNodeAndReturnEmptyStorageGroup(IEntityMNode entityMNode) throws MetadataException {
        IMNode curNode = entityMNode;
        if (!entityMNode.isUseTemplate()) {
            boolean hasMeasurement = false;
            try (IMNodeIterator iterator = this.store.getChildrenIterator(entityMNode);){
                while (iterator.hasNext()) {
                    IMNode child = (IMNode)iterator.next();
                    this.unPinMNode(child);
                    if (!child.isMeasurement()) continue;
                    hasMeasurement = true;
                    break;
                }
            }
            if (!hasMeasurement) {
                MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
                synchronized (mTreeBelowSGCachedImpl) {
                    curNode = this.store.setToInternal(entityMNode);
                    if (curNode.isStorageGroup()) {
                        this.storageGroupMNode = curNode.getAsStorageGroupMNode();
                    }
                }
            }
        }
        while (this.isEmptyInternalMNode(curNode)) {
            if (curNode.isStorageGroup()) {
                return curNode.getPartialPath();
            }
            this.store.deleteChild(curNode.getParent(), curNode.getName());
            curNode = curNode.getParent();
        }
        this.unPinMNode(curNode);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyInternalMNode(IMNode node) throws MetadataException {
        try (IMNodeIterator iterator = this.store.getChildrenIterator(node);){
            boolean bl = !"root".equals(node.getName()) && !node.isMeasurement() && !node.isUseTemplate() && !iterator.hasNext();
            return bl;
        }
    }

    @Override
    public List<PartialPath> getPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        MeasurementCollector<List<PartialPath>> collector = new MeasurementCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                if (node.isPreDeleted()) {
                    result.add(this.getCurrentPartialPath(node));
                }
            }
        };
        collector.setResultSet(result);
        collector.setShouldTraverseTemplate(false);
        collector.traverse();
        return result;
    }

    @Override
    public Set<PartialPath> getDevicesOfPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        MeasurementCollector<List<PartialPath>> collector = new MeasurementCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                if (node.isPreDeleted()) {
                    result.add(this.getCurrentPartialPath(node).getDevicePath());
                }
            }
        };
        collector.traverse();
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) throws MetadataException {
        this.store.setAlias(measurementMNode, alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode getDeviceNodeWithAutoCreating(PartialPath deviceId) throws MetadataException {
        String[] nodeNames = deviceId.getNodes();
        MetaFormatUtils.checkTimeseries(deviceId);
        IMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
                IMNode child = this.store.getChild(cur, nodeNames[i]);
                if (child == null) {
                    child = this.store.addChild(cur, nodeNames[i], new InternalMNode(cur, nodeNames[i]));
                }
                cur = child;
            }
            this.pinMNode(cur);
            IStorageGroupMNode iStorageGroupMNode = cur;
            return iStorageGroupMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEntityMNode setToEntity(IMNode node) throws MetadataException {
        MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
        synchronized (mTreeBelowSGCachedImpl) {
            IEntityMNode entityMNode = this.store.setToEntity(node);
            if (entityMNode.isStorageGroup()) {
                this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
            }
            return entityMNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPathExist(PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
                IMNode child = this.store.getChild(cur, nodeNames[i]);
                if (child == null) {
                    boolean bl = false;
                    return bl;
                }
                if (child.isMeasurement()) {
                    cur = child;
                    boolean bl = i == nodeNames.length - 1;
                    return bl;
                }
                cur = child;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    @Override
    public Set<PartialPath> getDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        final TreeSet<PartialPath> result = new TreeSet<PartialPath>();
        EntityCollector<Set<PartialPath>> collector = new EntityCollector<Set<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectEntity(IEntityMNode node) {
                result.add(this.getCurrentPartialPath(node));
            }
        };
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return result;
    }

    @Override
    public Pair<List<ShowDevicesResult>, Integer> getDevices(final ShowDevicesPlan plan) throws MetadataException {
        final ArrayList res = new ArrayList();
        EntityCollector<List<ShowDevicesResult>> collector = new EntityCollector<List<ShowDevicesResult>>((IMNode)this.storageGroupMNode, plan.getPath(), (IMTreeStore)this.store, plan.getLimit(), plan.getOffset()){

            @Override
            protected void collectEntity(IEntityMNode node) {
                PartialPath device = this.getCurrentPartialPath(node);
                if (plan.hasSgCol()) {
                    res.add(new ShowDevicesResult(device.getFullPath(), node.isAligned(), this.getStorageGroupNodeInTraversePath(node).getFullPath()));
                } else {
                    res.add(new ShowDevicesResult(device.getFullPath(), node.isAligned()));
                }
            }
        };
        collector.setPrefixMatch(plan.isPrefixMatch());
        collector.traverse();
        return new Pair(res, (Object)(collector.getCurOffset() + 1));
    }

    @Override
    public Set<PartialPath> getDevicesByTimeseries(PartialPath timeseries) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        MeasurementCollector<Set<PartialPath>> collector = new MeasurementCollector<Set<PartialPath>>((IMNode)this.storageGroupMNode, timeseries, (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                result.add(this.getCurrentPartialPath(node).getDevicePath());
            }
        };
        collector.traverse();
        return result;
    }

    @Override
    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch, (boolean)false).left;
    }

    @Override
    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern) throws MetadataException {
        return this.getMeasurementPaths(pathPattern, false);
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch, final boolean withTags) throws MetadataException {
        final LinkedList result = new LinkedList();
        MeasurementCollector<List<PartialPath>> collector = new MeasurementCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store, limit, offset){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                    path.setMeasurementAlias(node.getAlias());
                }
                if (withTags) {
                    path.setTagMap((Map)MTreeBelowSGCachedImpl.this.tagGetter.apply(node));
                }
                result.add(path);
            }
        };
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        offset = collector.getCurOffset() + 1;
        return new Pair(result, (Object)offset);
    }

    @Override
    public Pair<List<Pair<PartialPath, String[]>>, Integer> getAllMeasurementSchema(ShowTimeSeriesPlan plan, QueryContext queryContext) throws MetadataException {
        boolean needLast = plan.isOrderByHeat();
        int limit = needLast ? 0 : plan.getLimit();
        int offset = needLast ? 0 : plan.getOffset();
        MeasurementCollector<List<Pair<PartialPath, String[]>>> collector = new MeasurementCollector<List<Pair<PartialPath, String[]>>>((IMNode)this.storageGroupMNode, plan.getPath(), (IMTreeStore)this.store, limit, offset){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                IMeasurementSchema measurementSchema = node.getSchema();
                Pair<String, String> deadbandInfo = MetaUtils.parseDeadbandInfo(measurementSchema.getProps());
                String[] tsRow = new String[]{node.getAlias(), this.getStorageGroupNodeInTraversePath(node).getFullPath(), measurementSchema.getType().toString(), measurementSchema.getEncodingType().toString(), measurementSchema.getCompressor().toString(), String.valueOf(node.getOffset()), null, (String)deadbandInfo.left, (String)deadbandInfo.right};
                Pair temp = new Pair((Object)this.getCurrentPartialPath(node), (Object)tsRow);
                ((List)this.resultSet).add(temp);
            }
        };
        collector.setPrefixMatch(plan.isPrefixMatch());
        collector.setResultSet(new LinkedList());
        collector.traverse();
        List result = (List)collector.getResult();
        if (needLast) {
            Stream<Object> stream = result.stream();
            limit = plan.getLimit();
            offset = plan.getOffset();
            stream = stream.sorted(Comparator.comparingLong(p -> Long.parseLong(((String[])p.right)[6])).reversed().thenComparing(p -> (PartialPath)p.left));
            if (limit != 0) {
                stream = stream.skip(offset).limit(limit);
            }
            result = stream.collect(Collectors.toList());
        }
        return new Pair((Object)result, (Object)(collector.getCurOffset() + 1));
    }

    @Override
    public Set<TSchemaNode> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        try {
            MNodeCollector<Set<TSchemaNode>> collector = new MNodeCollector<Set<TSchemaNode>>((IMNode)this.storageGroupMNode, pathPattern.concatNode("*"), (IMTreeStore)this.store){

                @Override
                protected void transferToResult(IMNode node) {
                    ((Set)this.resultSet).add(new TSchemaNode(this.getCurrentPartialPath(node).getFullPath(), node.getMNodeType(false).getNodeType()));
                }
            };
            collector.setResultSet(new TreeSet());
            collector.traverse();
            return (Set)collector.getResult();
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    @Override
    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        try {
            MNodeCollector<Set<String>> collector = new MNodeCollector<Set<String>>((IMNode)this.storageGroupMNode, pathPattern.concatNode("*"), (IMTreeStore)this.store){

                @Override
                protected void transferToResult(IMNode node) {
                    ((Set)this.resultSet).add(node.getName());
                }
            };
            collector.setResultSet(new TreeSet());
            collector.traverse();
            return (Set)collector.getResult();
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    @Override
    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) throws MetadataException {
        MNodeCollector<List<PartialPath>> collector = new MNodeCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void transferToResult(IMNode node) {
                ((List)this.resultSet).add(this.getCurrentPartialPath(node));
            }
        };
        collector.setResultSet(new LinkedList());
        collector.setTargetLevel(nodeLevel);
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return (List)collector.getResult();
    }

    @Override
    public long getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        MeasurementCounter counter = new MeasurementCounter(this.storageGroupMNode, pathPattern, this.store);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public long getAllTimeseriesCount(PartialPath pathPattern, Map<Integer, Template> templateMap, boolean isPrefixMatch) throws MetadataException {
        MeasurementCounter counter = new MeasurementCounter(this.storageGroupMNode, pathPattern, this.store);
        counter.setPrefixMatch(isPrefixMatch);
        counter.setTemplateMap(templateMap);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public long getAllTimeseriesCount(PartialPath pathPattern) throws MetadataException {
        return this.getAllTimeseriesCount(pathPattern, false);
    }

    @Override
    public long getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch, List<String> timeseries, boolean hasTag) throws MetadataException {
        MeasurementCounter counter = new MeasurementCounter(this.storageGroupMNode, pathPattern, this.store, timeseries, hasTag);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public long getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        EntityCounter counter = new EntityCounter(this.storageGroupMNode, pathPattern, this.store);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public long getDevicesNum(PartialPath pathPattern) throws MetadataException {
        return this.getDevicesNum(pathPattern, false);
    }

    @Override
    public long getNodesCountInGivenLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        MNodeLevelCounter counter = new MNodeLevelCounter(this.storageGroupMNode, pathPattern, this.store, level);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public Map<PartialPath, Long> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        MeasurementGroupByLevelCounter counter = new MeasurementGroupByLevelCounter(this.storageGroupMNode, pathPattern, this.store, level);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getResult();
    }

    @Override
    public Map<PartialPath, Long> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch, List<String> timeseries, boolean hasTag) throws MetadataException {
        MeasurementGroupByLevelCounter counter = new MeasurementGroupByLevelCounter(this.storageGroupMNode, pathPattern, this.store, level, timeseries, hasTag);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode getNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        try {
            for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                IMNode next = this.store.getChild(cur, nodes[i]);
                if (next == null) {
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                if (next.isMeasurement()) {
                    if (i == nodes.length - 1) {
                        IMNode iMNode = next;
                        return iMNode;
                    }
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                cur = next;
            }
            this.pinMNode(cur);
            IStorageGroupMNode iStorageGroupMNode = cur;
            return iStorageGroupMNode;
        }
        finally {
            this.unPinPath(cur);
        }
    }

    @Override
    public IMeasurementMNode getMeasurementMNode(PartialPath path) throws MetadataException {
        IMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        this.unPinMNode(node);
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    @Override
    public List<MeasurementPath> fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, final boolean withTags) throws MetadataException {
        final LinkedList<MeasurementPath> result = new LinkedList<MeasurementPath>();
        MeasurementCollector<List<PartialPath>> collector = new MeasurementCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                if (node.isPreDeleted()) {
                    return;
                }
                MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                    path.setMeasurementAlias(node.getAlias());
                }
                if (withTags) {
                    path.setTagMap((Map)MTreeBelowSGCachedImpl.this.tagGetter.apply(node));
                }
                result.add(path);
            }
        };
        collector.setTemplateMap(templateMap);
        collector.traverse();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMeasurementMNode> getAllMeasurementMNode() throws MetadataException {
        IStorageGroupMNode cur = this.storageGroupMNode;
        LinkedList<IMeasurementMNode> leafMNodes = new LinkedList<IMeasurementMNode>();
        LinkedList<IMNode> queue = new LinkedList<IMNode>();
        try {
            this.pinMNode(cur);
            queue.add(cur);
            while (!queue.isEmpty()) {
                IMNode node = (IMNode)queue.poll();
                try (IMNodeIterator iterator = this.store.getChildrenIterator(node);){
                    while (iterator.hasNext()) {
                        IMNode child = (IMNode)iterator.next();
                        if (child.isMeasurement()) {
                            leafMNodes.add(child.getAsMeasurementMNode());
                            this.unPinMNode(child);
                            continue;
                        }
                        queue.add(child);
                    }
                }
                finally {
                    this.unPinMNode(node);
                }
            }
            LinkedList<IMeasurementMNode> linkedList = leafMNodes;
            return linkedList;
        }
        finally {
            while (!queue.isEmpty()) {
                this.unPinMNode((IMNode)queue.poll());
            }
        }
    }

    @Override
    public List<IMeasurementMNode> getMatchedMeasurementMNode(PartialPath pathPattern) throws MetadataException {
        final ArrayList<IMeasurementMNode> result = new ArrayList<IMeasurementMNode>();
        MeasurementCollector<List<IMeasurementMNode>> collector = new MeasurementCollector<List<IMeasurementMNode>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) throws MetadataException {
                MTreeBelowSGCachedImpl.this.pinMNode(node);
                result.add(node);
            }
        };
        collector.setShouldTraverseTemplate(false);
        collector.traverse();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateTemplate(PartialPath activatePath, Template template) throws MetadataException {
        ArrayList<IMNode> pinnedNodes;
        block15: {
            String[] nodes = activatePath.getNodes();
            IMNode cur = this.storageGroupMNode;
            pinnedNodes = new ArrayList<IMNode>();
            IEntityMNode entityMNode = null;
            try {
                for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
                    cur = this.store.getChild(cur, nodes[i]);
                    pinnedNodes.add(cur);
                }
                MTreeBelowSGCachedImpl mTreeBelowSGCachedImpl = this;
                synchronized (mTreeBelowSGCachedImpl) {
                    for (String measurement : template.getSchemaMap().keySet()) {
                        if (!this.store.hasChild(cur, measurement)) continue;
                        throw new TemplateImcompatibeException(activatePath.concatNode(measurement).getFullPath(), template.getName());
                    }
                    if (cur.isUseTemplate()) {
                        throw new TemplateIsInUseException(cur.getFullPath());
                    }
                    if (cur.isEntity()) {
                        entityMNode = cur.getAsEntityMNode();
                    } else {
                        entityMNode = this.store.setToEntity(cur);
                        if (entityMNode.isStorageGroup()) {
                            this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
                        }
                    }
                }
                if (!entityMNode.isAligned()) {
                    entityMNode.setAligned(template.isDirectAligned());
                }
                entityMNode.setUseTemplate(true);
                entityMNode.setSchemaTemplateId(template.getId());
                if (entityMNode == null) break block15;
            }
            catch (Throwable throwable) {
                if (entityMNode != null) {
                    this.store.updateMNode(entityMNode);
                }
                for (IMNode node : pinnedNodes) {
                    this.store.unPin(node);
                }
                throw throwable;
            }
            this.store.updateMNode(entityMNode);
        }
        for (IMNode node : pinnedNodes) {
            this.store.unPin(node);
        }
    }

    @Override
    public List<String> getPathsUsingTemplate(PartialPath pathPattern, final int templateId) throws MetadataException {
        final HashSet result = new HashSet();
        EntityCollector<Set<String>> collector = new EntityCollector<Set<String>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectEntity(IEntityMNode node) {
                if (node.getSchemaTemplateId() == templateId) {
                    result.add(node.getFullPath());
                }
            }
        };
        collector.traverse();
        return new ArrayList<String>(result);
    }

    public Map<PartialPath, List<Integer>> constructSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            EntityCollector<List<IEntityMNode>> collector = new EntityCollector<List<IEntityMNode>>((IMNode)this.storageGroupMNode, entry.getKey(), (IMTreeStore)this.store){

                @Override
                protected void collectEntity(IEntityMNode node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId())) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.preDeactivateTemplate();
                        this.store.updateMNode(node);
                    }
                }
            };
            collector.traverse();
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> rollbackSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            EntityCollector<List<IEntityMNode>> collector = new EntityCollector<List<IEntityMNode>>((IMNode)this.storageGroupMNode, entry.getKey(), (IMTreeStore)this.store){

                @Override
                protected void collectEntity(IEntityMNode node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.rollbackPreDeactivateTemplate();
                        this.store.updateMNode(node);
                    }
                }
            };
            collector.traverse();
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> deactivateTemplateInBlackList(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            EntityCollector<List<IEntityMNode>> collector = new EntityCollector<List<IEntityMNode>>((IMNode)this.storageGroupMNode, entry.getKey(), (IMTreeStore)this.store){

                @Override
                protected void collectEntity(IEntityMNode node) throws MetadataException {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.deactivateTemplate();
                        this.store.updateMNode(node);
                        MTreeBelowSGCachedImpl.this.deleteEmptyInternalMNodeAndReturnEmptyStorageGroup(node);
                    }
                }
            };
            collector.traverse();
        }
        return resultTemplateSetInfo;
    }

    @Override
    public long countPathsUsingTemplate(PartialPath pathPattern, final int templateId) throws MetadataException {
        CounterTraverser counterTraverser = new CounterTraverser(this.storageGroupMNode, pathPattern, this.store){

            @Override
            protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
                return false;
            }

            @Override
            protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
                if (node.isEntity() && node.getAsEntityMNode().getSchemaTemplateId() == templateId) {
                    ++this.count;
                }
                return false;
            }
        };
        counterTraverser.traverse();
        return counterTraverser.getCount();
    }

    public void pinMNode(IMNode node) throws MetadataException {
        this.store.pin(node);
    }

    public void unPinMNode(IMNode node) {
        this.store.unPin(node);
    }

    private void unPinPath(IMNode node) {
        this.store.unPinPath(node);
    }

    public void updateMNode(IMNode node) throws MetadataException {
        this.store.updateMNode(node);
    }

    public IMNode getChildFromPinnedMNode(IMNode parent, String measurement) throws MetadataException {
        return this.store.getChild(parent, measurement);
    }
}

