/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.constant.CompactionType;
import org.apache.iotdb.db.engine.compaction.constant.ProcessChunkType;
import org.apache.iotdb.db.service.metrics.recorder.CompactionMetricsRecorder;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.chunk.ValueChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public abstract class AbstractCompactionWriter
implements AutoCloseable {
    protected int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    private RateLimiter compactionRateLimiter = CompactionTaskManager.getInstance().getMergeWriteRateLimiter();
    protected long[] lastTime = new long[this.subTaskNum];
    protected IChunkWriter[] chunkWriters = new IChunkWriter[this.subTaskNum];
    protected int[] chunkPointNumArray = new int[this.subTaskNum];
    protected long targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    protected long targetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
    private final long checkPoint = (this.targetChunkPointNum >= 10L ? this.targetChunkPointNum : 10L) / 10L;
    private long lastCheckIndex = 0L;
    protected long chunkSizeLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
    protected long chunkPointNumLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
    protected long pageSizeLowerBoundInCompaction = this.chunkSizeLowerBoundInCompaction / 10L;
    protected long pagePointNumLowerBoundInCompaction = this.chunkPointNumLowerBoundInCompaction / 10L;
    protected boolean isAlign;
    protected String deviceId;
    protected String[] measurementId = new String[this.subTaskNum];

    public abstract void startChunkGroup(String var1, boolean var2) throws IOException;

    public abstract void endChunkGroup() throws IOException;

    public void startMeasurement(List<IMeasurementSchema> measurementSchemaList, int subTaskId) {
        this.lastCheckIndex = 0L;
        this.lastTime[subTaskId] = Long.MIN_VALUE;
        if (this.isAlign) {
            this.chunkWriters[subTaskId] = new AlignedChunkWriterImpl(measurementSchemaList);
            this.measurementId[subTaskId] = "";
        } else {
            this.chunkWriters[subTaskId] = new ChunkWriterImpl(measurementSchemaList.get(0), true);
            this.measurementId[subTaskId] = measurementSchemaList.get(0).getMeasurementId();
        }
    }

    public abstract void endMeasurement(int var1) throws IOException;

    public abstract void write(TimeValuePair var1, int var2) throws IOException;

    public abstract void write(TimeColumn var1, Column[] var2, int var3, int var4) throws IOException;

    public abstract void endFile() throws IOException;

    public abstract long getWriterSize() throws IOException;

    public abstract void checkAndMayFlushChunkMetadata() throws IOException;

    protected void writeDataPoint(long timestamp, TsPrimitiveType value, IChunkWriter iChunkWriter) {
        if (iChunkWriter instanceof ChunkWriterImpl) {
            ChunkWriterImpl chunkWriter = (ChunkWriterImpl)iChunkWriter;
            switch (chunkWriter.getDataType()) {
                case TEXT: {
                    chunkWriter.write(timestamp, value.getBinary());
                    break;
                }
                case DOUBLE: {
                    chunkWriter.write(timestamp, value.getDouble());
                    break;
                }
                case BOOLEAN: {
                    chunkWriter.write(timestamp, value.getBoolean());
                    break;
                }
                case INT64: {
                    chunkWriter.write(timestamp, value.getLong());
                    break;
                }
                case INT32: {
                    chunkWriter.write(timestamp, value.getInt());
                    break;
                }
                case FLOAT: {
                    chunkWriter.write(timestamp, value.getFloat());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown data type " + chunkWriter.getDataType());
                }
            }
        } else {
            AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)iChunkWriter;
            alignedChunkWriter.write(timestamp, value.getVector());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sealChunk(TsFileIOWriter targetWriter, IChunkWriter iChunkWriter, int subTaskId) throws IOException {
        CompactionTaskManager.mergeRateLimiterAcquire(this.compactionRateLimiter, iChunkWriter.estimateMaxSeriesMemSize());
        TsFileIOWriter tsFileIOWriter = targetWriter;
        synchronized (tsFileIOWriter) {
            iChunkWriter.writeToFileWriter(targetWriter);
        }
        this.chunkPointNumArray[subTaskId] = 0;
    }

    public abstract boolean flushNonAlignedChunk(Chunk var1, ChunkMetadata var2, int var3) throws IOException;

    public abstract boolean flushAlignedChunk(Chunk var1, IChunkMetadata var2, List<Chunk> var3, List<IChunkMetadata> var4, int var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushNonAlignedChunkToFileWriter(TsFileIOWriter targetWriter, Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) throws IOException {
        CompactionTaskManager.mergeRateLimiterAcquire(this.compactionRateLimiter, this.getChunkSize(chunk));
        TsFileIOWriter tsFileIOWriter = targetWriter;
        synchronized (tsFileIOWriter) {
            this.chunkWriters[subTaskId].writeToFileWriter(targetWriter);
            this.chunkPointNumArray[subTaskId] = 0;
            targetWriter.writeChunk(chunk, chunkMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushAlignedChunkToFileWriter(TsFileIOWriter targetWriter, Chunk timeChunk, IChunkMetadata timeChunkMetadata, List<Chunk> valueChunks, List<IChunkMetadata> valueChunkMetadatas, int subTaskId) throws IOException {
        TsFileIOWriter tsFileIOWriter = targetWriter;
        synchronized (tsFileIOWriter) {
            AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
            alignedChunkWriter.writeToFileWriter(targetWriter);
            this.chunkPointNumArray[subTaskId] = 0;
            CompactionTaskManager.mergeRateLimiterAcquire(this.compactionRateLimiter, this.getChunkSize(timeChunk));
            targetWriter.writeChunk(timeChunk, (ChunkMetadata)timeChunkMetadata);
            for (int i = 0; i < valueChunks.size(); ++i) {
                Chunk valueChunk = valueChunks.get(i);
                if (valueChunk == null) {
                    ValueChunkWriter valueChunkWriter = alignedChunkWriter.getValueChunkWriterByIndex(i);
                    targetWriter.writeEmptyValueChunk(valueChunkWriter.getMeasurementId(), valueChunkWriter.getCompressionType(), valueChunkWriter.getDataType(), valueChunkWriter.getEncodingType(), valueChunkWriter.getStatistics());
                    continue;
                }
                CompactionTaskManager.mergeRateLimiterAcquire(this.compactionRateLimiter, this.getChunkSize(valueChunk));
                targetWriter.writeChunk(valueChunk, (ChunkMetadata)valueChunkMetadatas.get(i));
            }
        }
    }

    public abstract boolean flushNonAlignedPage(ByteBuffer var1, PageHeader var2, int var3) throws IOException, PageException;

    protected void flushNonAlignedPageToChunkWriter(ChunkWriterImpl chunkWriter, ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) throws PageException {
        chunkWriter.sealCurrentPage();
        chunkWriter.writePageHeaderAndDataIntoBuff(compressedPageData, pageHeader);
        int n = subTaskId;
        this.chunkPointNumArray[n] = (int)((long)this.chunkPointNumArray[n] + pageHeader.getStatistics().getCount());
    }

    public abstract boolean flushAlignedPage(ByteBuffer var1, PageHeader var2, List<ByteBuffer> var3, List<PageHeader> var4, int var5) throws IOException, PageException;

    protected void flushAlignedPageToChunkWriter(AlignedChunkWriterImpl alignedChunkWriter, ByteBuffer compressedTimePageData, PageHeader timePageHeader, List<ByteBuffer> compressedValuePageDatas, List<PageHeader> valuePageHeaders, int subTaskId) throws IOException, PageException {
        alignedChunkWriter.sealCurrentPage();
        alignedChunkWriter.writePageHeaderAndDataIntoTimeBuff(compressedTimePageData, timePageHeader);
        for (int i = 0; i < valuePageHeaders.size(); ++i) {
            if (valuePageHeaders.get(i) == null) {
                alignedChunkWriter.getValueChunkWriterByIndex(i).writeEmptyPageToPageBuffer();
                continue;
            }
            alignedChunkWriter.writePageHeaderAndDataIntoValueBuff(compressedValuePageDatas.get(i), valuePageHeaders.get(i), i);
        }
        int n = subTaskId;
        this.chunkPointNumArray[n] = (int)((long)this.chunkPointNumArray[n] + timePageHeader.getStatistics().getCount());
    }

    protected void checkChunkSizeAndMayOpenANewChunk(TsFileIOWriter fileWriter, IChunkWriter iChunkWriter, int subTaskId, boolean isCrossSpace) throws IOException {
        if ((long)this.chunkPointNumArray[subTaskId] >= (this.lastCheckIndex + 1L) * this.checkPoint) {
            this.lastCheckIndex = (long)this.chunkPointNumArray[subTaskId] / this.checkPoint;
            if (iChunkWriter.checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, false)) {
                this.sealChunk(fileWriter, iChunkWriter, subTaskId);
                this.lastCheckIndex = 0L;
                CompactionMetricsRecorder.recordWriteInfo(isCrossSpace ? CompactionType.CROSS_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION, ProcessChunkType.DESERIALIZE_CHUNK, this.isAlign, iChunkWriter.estimateMaxSeriesMemSize());
            }
        }
    }

    protected long getChunkSize(Chunk chunk) {
        return chunk.getHeader().getSerializedSize() + chunk.getHeader().getDataSize();
    }
}

