/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceEstimator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPointCrossCompactionEstimator
extends AbstractCrossSpaceEstimator {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private long maxCostOfReadingSeqFile = 0L;
    private Pair<Integer, Integer> maxUnseqChunkNumInDevice;
    private final List<Pair<Integer, Integer>> maxSeqChunkNumInDeviceList;
    private final int subCompactionTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();

    public ReadPointCrossCompactionEstimator() {
        this.maxSeqChunkNumInDeviceList = new ArrayList<Pair<Integer, Integer>>();
    }

    @Override
    public long estimateCrossCompactionMemory(List<TsFileResource> seqResources, TsFileResource unseqResource) throws IOException {
        long cost = 0L;
        cost += this.calculateReadingUnseqFile(unseqResource);
        cost += this.calculateReadingSeqFiles(seqResources);
        this.maxSeqChunkNumInDeviceList.clear();
        return cost += this.calculatingWritingTargetFiles(seqResources, unseqResource);
    }

    private long calculateReadingUnseqFile(TsFileResource unseqResource) throws IOException {
        TsFileSequenceReader reader = this.getFileReader(unseqResource);
        int[] fileInfo = this.getSeriesAndDeviceChunkNum(reader);
        int concurrentSeriesNum = fileInfo[2] == -1 ? this.subCompactionTaskNum : fileInfo[2];
        this.maxUnseqChunkNumInDevice = new Pair((Object)fileInfo[3], (Object)fileInfo[0]);
        if (fileInfo[0] == 0) {
            logger.warn("calculateReadingUnseqFile(), find 1 empty unSeq tsFile: {}.", (Object)unseqResource.getTsFilePath());
            return 0L;
        }
        return (long)(2 * concurrentSeriesNum) * (unseqResource.getTsFileSize() * (long)fileInfo[1] / (long)fileInfo[0]);
    }

    private long calculateReadingSeqFiles(List<TsFileResource> seqResources) throws IOException {
        long cost = 0L;
        for (TsFileResource seqResource : seqResources) {
            TsFileSequenceReader reader = this.getFileReader(seqResource);
            int[] fileInfo = this.getSeriesAndDeviceChunkNum(reader);
            int concurrentSeriesNum = fileInfo[2] == -1 ? this.subCompactionTaskNum : fileInfo[2];
            long seqFileCost = 0L;
            if (fileInfo[0] == 0) {
                logger.warn("calculateReadingSeqFiles(), find 1 empty seq tsFile: {}.", (Object)seqResource.getTsFilePath());
                seqFileCost = 0L;
            } else {
                seqFileCost = (long)concurrentSeriesNum * (seqResource.getTsFileSize() * (long)fileInfo[1] / (long)fileInfo[0]);
            }
            if (seqFileCost > this.maxCostOfReadingSeqFile) {
                cost -= 2L * this.maxCostOfReadingSeqFile;
                cost += 2L * seqFileCost;
                this.maxCostOfReadingSeqFile = seqFileCost;
            }
            this.maxSeqChunkNumInDeviceList.add((Pair<Integer, Integer>)new Pair((Object)fileInfo[3], (Object)fileInfo[0]));
        }
        return cost;
    }

    private long calculatingWritingTargetFiles(List<TsFileResource> seqResources, TsFileResource unseqResource) throws IOException {
        long cost = 0L;
        for (TsFileResource seqResource : seqResources) {
            TsFileSequenceReader reader = this.getFileReader(seqResource);
            cost += reader.getFileMetadataSize();
            int totalSeqChunkNum = (Integer)this.maxSeqChunkNumInDeviceList.get((int)0).right;
            if (totalSeqChunkNum <= 0) continue;
            cost += seqResource.getTsFileSize() * (long)((Integer)this.maxSeqChunkNumInDeviceList.get((int)0).left).intValue() / (long)totalSeqChunkNum;
        }
        int totalUnSeqChunkNum = (Integer)this.maxUnseqChunkNumInDevice.right;
        if (totalUnSeqChunkNum > 0) {
            cost += unseqResource.getTsFileSize() * (long)((Integer)this.maxUnseqChunkNumInDevice.left).intValue() / (long)totalUnSeqChunkNum;
        }
        return cost;
    }

    private int[] getSeriesAndDeviceChunkNum(TsFileSequenceReader reader) throws IOException {
        int totalChunkNum = 0;
        int maxChunkNum = 0;
        int maxAlignedSeriesNumInDevice = -1;
        int maxDeviceChunkNum = 0;
        Map deviceMetadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : deviceMetadata.entrySet()) {
            int deviceChunkNum = 0;
            List deviceTimeseriesMetadata = (List)entry.getValue();
            if (((TimeseriesMetadata)deviceTimeseriesMetadata.get(0)).getMeasurementId().equals("")) {
                maxAlignedSeriesNumInDevice = Math.max(maxAlignedSeriesNumInDevice, deviceTimeseriesMetadata.size());
            }
            for (TimeseriesMetadata timeseriesMetadata : deviceTimeseriesMetadata) {
                deviceChunkNum += timeseriesMetadata.getChunkMetadataList().size();
                totalChunkNum += timeseriesMetadata.getChunkMetadataList().size();
                maxChunkNum = Math.max(maxChunkNum, timeseriesMetadata.getChunkMetadataList().size());
            }
            maxDeviceChunkNum = Math.max(maxDeviceChunkNum, deviceChunkNum);
        }
        return new int[]{totalChunkNum, maxChunkNum, maxAlignedSeriesNumInDevice, maxDeviceChunkNum};
    }
}

