/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.ICrossSpaceSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.CrossCompactionTaskResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.engine.compaction.cross.utils.AbstractCompactionEstimator;
import org.apache.iotdb.db.engine.compaction.task.ICompactionSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionSelector
implements ICrossSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final int SELECT_WARN_THRESHOLD = 10;
    protected String logicalStorageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected TsFileManager tsFileManager;
    private long totalCost;
    private final long memoryBudget;
    private final int maxCrossCompactionFileNum;
    private final long maxCrossCompactionFileSize;
    private int seqSelectedNum;
    private AbstractCompactionEstimator compactionEstimator;

    public RewriteCrossSpaceCompactionSelector(String logicalStorageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager) {
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.memoryBudget = (long)((double)(SystemInfo.getInstance().getMemorySizeForCompaction() / (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount()) * config.getUsableCompactionMemoryProportion());
        this.maxCrossCompactionFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileNum();
        this.maxCrossCompactionFileSize = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileSize();
        this.compactionEstimator = ICompactionSelector.getCompactionEstimator(IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer(), false);
    }

    private CrossCompactionTaskResource selectOneTaskResources(CrossSpaceCompactionCandidate candidate) throws MergeException {
        long startTime = System.currentTimeMillis();
        try {
            LOGGER.debug("Selecting cross compaction task resources from {} seqFile, {} unseqFiles", (Object)candidate.getSeqFiles().size(), (Object)candidate.getUnseqFiles().size());
            CrossCompactionTaskResource taskResource = this.executeTaskResourceSelection(candidate);
            LOGGER.info("selected one cross compaction task resource. is valid: {}, {} seqFiles, {} unseqFiles, total memory cost {}, time consumption {}ms", new Object[]{taskResource.isValid(), taskResource.getSeqFiles().size(), taskResource.getUnseqFiles().size(), taskResource.getTotalMemoryCost(), System.currentTimeMillis() - startTime});
            CrossCompactionTaskResource crossCompactionTaskResource = taskResource;
            return crossCompactionTaskResource;
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
        finally {
            try {
                this.compactionEstimator.clear();
            }
            catch (IOException e) {
                throw new MergeException(e);
            }
        }
    }

    private boolean isAllFileCandidateValid(List<CrossSpaceCompactionCandidate.TsFileResourceCandidate> tsFileResourceCandidates) {
        for (CrossSpaceCompactionCandidate.TsFileResourceCandidate candidate : tsFileResourceCandidates) {
            if (candidate.isValidCandidate) continue;
            return false;
        }
        return true;
    }

    private CrossCompactionTaskResource executeTaskResourceSelection(CrossSpaceCompactionCandidate candidate) throws IOException {
        CrossCompactionTaskResource taskResource = new CrossCompactionTaskResource();
        while (candidate.hasNextSplit()) {
            long memoryCost;
            CrossSpaceCompactionCandidate.CrossCompactionTaskResourceSplit split = candidate.nextSplit();
            TsFileResource unseqFile = split.unseqFile.resource;
            List<TsFileResource> targetSeqFiles = split.seqFiles.stream().map(c -> c.resource).collect(Collectors.toList());
            if (!this.canAddToTaskResource(taskResource, unseqFile, targetSeqFiles, memoryCost = this.compactionEstimator.estimateCrossCompactionMemory(targetSeqFiles, unseqFile))) break;
            taskResource.putResources(unseqFile, targetSeqFiles, memoryCost);
            LOGGER.debug("Adding a new unseqFile {} and seqFiles {} as candidates, new cost {}, total cost {}", new Object[]{unseqFile, targetSeqFiles, memoryCost, this.totalCost});
        }
        taskResource.sortSeqFiles(candidate.getSeqFiles());
        return taskResource;
    }

    private boolean canAddToTaskResource(CrossCompactionTaskResource taskResource, TsFileResource unseqFile, List<TsFileResource> seqFiles, long memoryCost) {
        if (taskResource.getUnseqFiles().size() == 0) {
            return true;
        }
        long totalFileSize = unseqFile.getTsFileSize();
        for (TsFileResource f : seqFiles) {
            totalFileSize += f.getTsFileSize();
        }
        return taskResource.getTotalFileNums() + 1L + (long)seqFiles.size() <= (long)this.maxCrossCompactionFileNum && taskResource.getTotalFileSize() + totalFileSize <= this.maxCrossCompactionFileSize && taskResource.getTotalMemoryCost() + memoryCost < this.memoryBudget;
    }

    private boolean canSubmitCrossTask() {
        return config.isEnableCrossSpaceCompaction() && CompactionTaskManager.currentTaskNum.get() < config.getCompactionThreadCount();
    }

    @Override
    public List<CrossCompactionTaskResource> selectCrossSpaceTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList) {
        if (!this.canSubmitCrossTask()) {
            return Collections.emptyList();
        }
        if (sequenceFileList.isEmpty() || unsequenceFileList.isEmpty()) {
            return Collections.emptyList();
        }
        long ttlLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(sequenceFileList, unsequenceFileList, ttlLowerBound);
        try {
            CrossCompactionTaskResource taskResources = this.selectOneTaskResources(candidate);
            if (!taskResources.isValid()) {
                LOGGER.info("{} [Compaction] Cannot select any files, because source files may be occupied by other compaction threads.", (Object)(this.logicalStorageGroupName + "-" + this.dataRegionId));
                return Collections.emptyList();
            }
            LOGGER.info("{} [Compaction] submit a task with {} sequence file and {} unseq files", new Object[]{this.logicalStorageGroupName + "-" + this.dataRegionId, taskResources.getSeqFiles().size(), taskResources.getUnseqFiles().size()});
            return Collections.singletonList(taskResources);
        }
        catch (MergeException e) {
            LOGGER.error("{} cannot select file for cross space compaction", (Object)this.logicalStorageGroupName, (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Long> getCompactionMemoryCost() {
        return Collections.singletonList(this.totalCost);
    }
}

