/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TsFileMetricManager {
    private static final TsFileMetricManager INSTANCE = new TsFileMetricManager();
    private final AtomicLong seqFileSize = new AtomicLong(0L);
    private final AtomicLong unseqFileSize = new AtomicLong(0L);
    private final AtomicInteger seqFileNum = new AtomicInteger(0);
    private final AtomicInteger unseqFileNum = new AtomicInteger(0);
    private final AtomicLong innerSeqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong innerUnseqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong crossCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicInteger innerSeqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger innerUnseqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger crossCompactionTempFileNum = new AtomicInteger(0);

    private TsFileMetricManager() {
    }

    public static TsFileMetricManager getInstance() {
        return INSTANCE;
    }

    public void addFile(long size, boolean seq) {
        if (seq) {
            this.seqFileSize.getAndAdd(size);
            this.seqFileNum.incrementAndGet();
        } else {
            this.unseqFileSize.getAndAdd(size);
            this.unseqFileNum.incrementAndGet();
        }
    }

    public void deleteFile(long size, boolean seq, int num) {
        if (seq) {
            this.seqFileSize.getAndAdd(-size);
            this.seqFileNum.getAndAdd(-num);
        } else {
            this.unseqFileSize.getAndAdd(-size);
            this.unseqFileNum.getAndAdd(-num);
        }
    }

    public long getFileSize(boolean seq) {
        return seq ? this.seqFileSize.get() : this.unseqFileSize.get();
    }

    public long getFileNum(boolean seq) {
        return seq ? (long)this.seqFileNum.get() : (long)this.unseqFileNum.get();
    }

    public void addCompactionTempFileSize(boolean innerSpace, boolean seq, long delta) {
        if (innerSpace) {
            long l = seq ? this.innerSeqCompactionTempFileSize.addAndGet(delta) : this.innerUnseqCompactionTempFileSize.addAndGet(delta);
        } else {
            this.crossCompactionTempFileSize.addAndGet(delta);
        }
    }

    public void addCompactionTempFileNum(boolean innerSpace, boolean seq, int delta) {
        if (innerSpace) {
            long l = seq ? (long)this.innerSeqCompactionTempFileNum.addAndGet(delta) : (long)this.innerUnseqCompactionTempFileNum.addAndGet(delta);
        } else {
            this.crossCompactionTempFileNum.addAndGet(delta);
        }
    }

    public long getCompactionTempFileSize(boolean innerSpace, boolean seq) {
        if (innerSpace) {
            return seq ? this.innerSeqCompactionTempFileSize.get() : this.innerUnseqCompactionTempFileSize.get();
        }
        return this.crossCompactionTempFileSize.get();
    }

    public int getCompactionTempFileNum(boolean innerSpace, boolean seq) {
        if (innerSpace) {
            return seq ? this.innerSeqCompactionTempFileNum.get() : this.innerUnseqCompactionTempFileNum.get();
        }
        return this.crossCompactionTempFileNum.get();
    }
}

