/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.db.auth.BasicAuthorityCache;
import org.apache.iotdb.db.auth.ClusterAuthorityFetcher;
import org.apache.iotdb.db.auth.IAuthorityFetcher;
import org.apache.iotdb.db.auth.StandaloneAuthorityFetcher;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.rpc.ConfigNodeConnectionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizerManager
implements IAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizerManager.class);
    private IAuthorizer iAuthorizer;
    private ReentrantReadWriteLock authReadWriteLock;
    private IoTDBDescriptor conf = IoTDBDescriptor.getInstance();
    private IAuthorityFetcher authorityFetcher;

    public AuthorizerManager() {
        try {
            this.iAuthorizer = BasicAuthorizer.getInstance();
            this.authReadWriteLock = new ReentrantReadWriteLock();
            this.authorityFetcher = this.conf.getConfig().isClusterMode() ? new ClusterAuthorityFetcher(new BasicAuthorityCache()) : new StandaloneAuthorityFetcher();
        }
        catch (AuthException e) {
            logger.error(e.getMessage());
        }
    }

    public static AuthorizerManager getInstance() {
        return AuthorizerManagerHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String username, String password) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            boolean bl = this.iAuthorizer.login(username, password);
            return bl;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public void createUser(String username, String password) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.createUser(username, password);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    public void deleteUser(String username) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.deleteUser(username);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPrivilegeToUser(String username, String path, int privilegeId) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.grantPrivilegeToUser(username, path, privilegeId);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePrivilegeFromUser(String username, String path, int privilegeId) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.revokePrivilegeFromUser(username, path, privilegeId);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    public void createRole(String roleName) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.createRole(roleName);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    public void deleteRole(String roleName) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.deleteRole(roleName);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPrivilegeToRole(String roleName, String path, int privilegeId) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.grantPrivilegeToRole(roleName, path, privilegeId);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePrivilegeFromRole(String roleName, String path, int privilegeId) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.revokePrivilegeFromRole(roleName, path, privilegeId);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    public void grantRoleToUser(String roleName, String username) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.grantRoleToUser(roleName, username);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    public void revokeRoleFromUser(String roleName, String username) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.revokeRoleFromUser(roleName, username);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getPrivileges(String username, String path) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            Set set = this.iAuthorizer.getPrivileges(username, path);
            return set;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public void updateUserPassword(String username, String newPassword) throws AuthException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.updateUserPassword(username, newPassword);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserPrivileges(String username, String path, int privilegeId) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            boolean bl = this.iAuthorizer.checkUserPrivileges(username, path, privilegeId);
            return bl;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public void reset() throws AuthException {
        this.iAuthorizer.reset();
    }

    public List<String> listAllUsers() {
        this.authReadWriteLock.readLock().lock();
        try {
            List list = this.iAuthorizer.listAllUsers();
            return list;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public List<String> listAllRoles() {
        this.authReadWriteLock.readLock().lock();
        try {
            List list = this.iAuthorizer.listAllRoles();
            return list;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public Role getRole(String roleName) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            Role role = this.iAuthorizer.getRole(roleName);
            return role;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public User getUser(String username) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            User user = this.iAuthorizer.getUser(username);
            return user;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public boolean isUserUseWaterMark(String userName) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            boolean bl = this.iAuthorizer.isUserUseWaterMark(userName);
            return bl;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public void setUserUseWaterMark(String userName, boolean useWaterMark) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            this.iAuthorizer.setUserUseWaterMark(userName, useWaterMark);
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public Map<String, Boolean> getAllUserWaterMarkStatus() {
        this.authReadWriteLock.readLock().lock();
        try {
            Map map = this.iAuthorizer.getAllUserWaterMarkStatus();
            return map;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public Map<String, User> getAllUsers() {
        this.authReadWriteLock.readLock().lock();
        try {
            Map map = this.iAuthorizer.getAllUsers();
            return map;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public Map<String, Role> getAllRoles() {
        this.authReadWriteLock.readLock().lock();
        try {
            Map map = this.iAuthorizer.getAllRoles();
            return map;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public void replaceAllUsers(Map<String, User> users) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            this.iAuthorizer.replaceAllUsers(users);
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public void replaceAllRoles(Map<String, Role> roles) throws AuthException {
        this.authReadWriteLock.readLock().lock();
        try {
            this.iAuthorizer.replaceAllRoles(roles);
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        this.authReadWriteLock.writeLock().lock();
        try {
            boolean bl = this.iAuthorizer.processTakeSnapshot(snapshotDir);
            return bl;
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.authReadWriteLock.writeLock().lock();
        try {
            this.iAuthorizer.processLoadSnapshot(snapshotDir);
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus checkPath(String username, List<String> allPath, int permission) {
        this.authReadWriteLock.readLock().lock();
        try {
            TSStatus tSStatus = this.authorityFetcher.checkUserPrivileges(username, allPath, permission);
            return tSStatus;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus checkUser(String username, String password) throws ConfigNodeConnectionException {
        this.authReadWriteLock.readLock().lock();
        try {
            TSStatus tSStatus = this.authorityFetcher.checkUser(username, password);
            return tSStatus;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public boolean invalidateCache(String username, String roleName) {
        return this.authorityFetcher.getAuthorCache().invalidateCache(username, roleName);
    }

    public SettableFuture<ConfigTaskResult> queryPermission(AuthorStatement authorStatement) {
        this.authReadWriteLock.readLock().lock();
        try {
            SettableFuture<ConfigTaskResult> settableFuture = this.authorityFetcher.queryPermission(authorStatement);
            return settableFuture;
        }
        finally {
            this.authReadWriteLock.readLock().unlock();
        }
    }

    public SettableFuture<ConfigTaskResult> operatePermission(AuthorStatement authorStatement) {
        this.authReadWriteLock.writeLock().lock();
        try {
            SettableFuture<ConfigTaskResult> settableFuture = this.authorityFetcher.operatePermission(authorStatement);
            return settableFuture;
        }
        finally {
            this.authReadWriteLock.writeLock().unlock();
        }
    }

    public void buildTSBlock(Map<String, List<String>> authorizerInfo, SettableFuture<ConfigTaskResult> future) {
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        for (int i = 0; i < authorizerInfo.size(); ++i) {
            types.add(TSDataType.TEXT);
        }
        TsBlockBuilder builder = new TsBlockBuilder(types);
        ArrayList<ColumnHeader> headerList = new ArrayList<ColumnHeader>();
        for (String header : authorizerInfo.keySet()) {
            headerList.add(new ColumnHeader(header, TSDataType.TEXT));
        }
        for (String value : authorizerInfo.get(((ColumnHeader)headerList.get(0)).getColumnName())) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(value));
            builder.declarePosition();
        }
        for (int i = 1; i < headerList.size(); ++i) {
            for (String value : authorizerInfo.get(((ColumnHeader)headerList.get(i)).getColumnName())) {
                builder.getColumnBuilder(i).writeBinary(new Binary(value));
            }
        }
        DatasetHeader datasetHeader = new DatasetHeader(headerList, true);
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static class AuthorizerManagerHolder {
        private static final AuthorizerManager INSTANCE = new AuthorizerManager();

        private AuthorizerManagerHolder() {
        }
    }
}

