/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.security.encrypt.AsymmetricEncryptFactory;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(AuthUtils.class);
    private static final int MIN_PASSWORD_LENGTH = 4;
    private static final int MIN_USERNAME_LENGTH = 4;
    private static final int MIN_ROLENAME_LENGTH = 4;
    private static final String ROOT_PREFIX = "root";
    private static final String ENCRYPT_ALGORITHM = "MD5";
    private static final String STRING_ENCODING = "utf-8";
    public static final String ROOT_PATH_PRIVILEGE = "root.**";

    private AuthUtils() {
    }

    public static void validatePassword(String password) throws AuthException {
        if (password.length() < 4) {
            throw new AuthException("Password's size must be greater than or equal to 4");
        }
        if (password.contains(" ")) {
            throw new AuthException("Password cannot contain spaces");
        }
    }

    public static void validateUsername(String username) throws AuthException {
        if (username.length() < 4) {
            throw new AuthException("Username's size must be greater than or equal to 4");
        }
        if (username.contains(" ")) {
            throw new AuthException("Username cannot contain spaces");
        }
    }

    public static void validateRolename(String rolename) throws AuthException {
        if (rolename.length() < 4) {
            throw new AuthException("Role name's size must be greater than or equal to 4");
        }
        if (rolename.contains(" ")) {
            throw new AuthException("Rolename cannot contain spaces");
        }
    }

    public static void validatePrivilege(int privilegeId) throws AuthException {
        if (privilegeId < 0 || privilegeId >= PrivilegeType.values().length) {
            throw new AuthException(String.format("Invalid privilegeId %d", privilegeId));
        }
    }

    public static void validatePath(String path) throws AuthException {
        if (!path.startsWith(ROOT_PREFIX)) {
            throw new AuthException(String.format("Illegal seriesPath %s, seriesPath should start with \"%s\"", path, ROOT_PREFIX));
        }
    }

    public static void validatePrivilegeOnPath(String path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilege(privilegeId);
        PrivilegeType type = PrivilegeType.values()[privilegeId];
        if (!path.equals(ROOT_PATH_PRIVILEGE)) {
            AuthUtils.validatePath(path);
            switch (type) {
                case READ_TIMESERIES: 
                case CREATE_DATABASE: 
                case DELETE_DATABASE: 
                case CREATE_TIMESERIES: 
                case DELETE_TIMESERIES: 
                case INSERT_TIMESERIES: 
                case ALTER_TIMESERIES: 
                case CREATE_TRIGGER: 
                case DROP_TRIGGER: 
                case START_TRIGGER: 
                case STOP_TRIGGER: 
                case APPLY_TEMPLATE: {
                    return;
                }
            }
            throw new AuthException(String.format("Illegal privilege %s on seriesPath %s", new Object[]{type, path}));
        }
        switch (type) {
            case READ_TIMESERIES: 
            case CREATE_DATABASE: 
            case DELETE_DATABASE: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case INSERT_TIMESERIES: 
            case ALTER_TIMESERIES: {
                AuthUtils.validatePath(path);
                return;
            }
        }
    }

    public static String encryptPassword(String password) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).encrypt(password);
    }

    public static boolean validatePassword(String originPassword, String encryptPassword) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).validate(originPassword, encryptPassword);
    }

    public static boolean pathBelongsTo(String pathA, String pathB) throws AuthException {
        try {
            PartialPath partialPathA = new PartialPath(pathA);
            PartialPath partialPathB = new PartialPath(pathB);
            return partialPathB.matchFullPath(partialPathA);
        }
        catch (IllegalPathException e) {
            throw new AuthException(e);
        }
    }

    public static boolean checkPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) throws AuthException {
        if (privilegeList == null) {
            return false;
        }
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!(path != null ? pathPrivilege.getPath() != null && AuthUtils.pathBelongsTo(path, pathPrivilege.getPath()) && pathPrivilege.getPrivileges().contains(privilegeId) : pathPrivilege.getPath() == null && pathPrivilege.getPrivileges().contains(privilegeId))) continue;
            return true;
        }
        return false;
    }

    public static Set<Integer> getPrivileges(String path, List<PathPrivilege> privilegeList) throws AuthException {
        if (privilegeList == null) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> privileges = new HashSet<Integer>();
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (path != null) {
                if (pathPrivilege.getPath() == null || !AuthUtils.pathBelongsTo(path, pathPrivilege.getPath())) continue;
                privileges.addAll(pathPrivilege.getPrivileges());
                continue;
            }
            if (pathPrivilege.getPath() != null) continue;
            privileges.addAll(pathPrivilege.getPrivileges());
        }
        return privileges;
    }

    public static boolean hasPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path) || !pathPrivilege.getPrivileges().contains(privilegeId)) continue;
            pathPrivilege.getReferenceCnt().incrementAndGet();
            return true;
        }
        return false;
    }

    public static void addPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            if (privilegeId != PrivilegeType.ALL.ordinal()) {
                pathPrivilege.getPrivileges().add(privilegeId);
            } else {
                for (PrivilegeType privilegeType : PrivilegeType.values()) {
                    pathPrivilege.getPrivileges().add(privilegeType.ordinal());
                }
            }
            return;
        }
        PathPrivilege pathPrivilege = new PathPrivilege(path);
        if (privilegeId != PrivilegeType.ALL.ordinal()) {
            pathPrivilege.getPrivileges().add(privilegeId);
        } else {
            for (PrivilegeType privilegeType : PrivilegeType.values()) {
                pathPrivilege.getPrivileges().add(privilegeType.ordinal());
            }
        }
        privilegeList.add(pathPrivilege);
    }

    public static void removePrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        PathPrivilege emptyPrivilege = null;
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            if (privilegeId == PrivilegeType.ALL.ordinal()) {
                privilegeList.remove(pathPrivilege);
                return;
            }
            pathPrivilege.getPrivileges().remove(privilegeId);
            if (!pathPrivilege.getPrivileges().isEmpty()) break;
            emptyPrivilege = pathPrivilege;
            break;
        }
        if (emptyPrivilege != null) {
            privilegeList.remove(emptyPrivilege);
        }
    }

    public static TPermissionInfoResp generateEmptyPermissionInfoResp() {
        TPermissionInfoResp permissionInfoResp = new TPermissionInfoResp();
        permissionInfoResp.setUserInfo(new TUserResp("", "", new ArrayList(), new ArrayList(), false));
        HashMap<String, TRoleResp> roleInfo = new HashMap<String, TRoleResp>();
        roleInfo.put("", new TRoleResp("", new ArrayList()));
        permissionInfoResp.setRoleInfo(roleInfo);
        return permissionInfoResp;
    }

    public static Set<Integer> strToPermissions(String[] authorizationList) throws AuthException {
        HashSet<Integer> result = new HashSet<Integer>();
        if (authorizationList == null) {
            return result;
        }
        for (String s : authorizationList) {
            PrivilegeType[] types = PrivilegeType.values();
            boolean legal = false;
            if ("SET_STORAGE_GROUP".equalsIgnoreCase(s)) {
                s = PrivilegeType.CREATE_DATABASE.name();
            }
            if ("DELETE_STORAGE_GROUP".equalsIgnoreCase(s)) {
                s = PrivilegeType.DELETE_DATABASE.name();
            }
            for (PrivilegeType privilegeType : types) {
                if (!s.equalsIgnoreCase(privilegeType.name())) continue;
                result.add(privilegeType.ordinal());
                legal = true;
                break;
            }
            if (legal) continue;
            throw new AuthException("No such privilege " + s);
        }
        return result;
    }
}

