/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.commons.udf.utils.KDTreeUtil;
import org.apache.iotdb.udf.api.access.Row;

public class MasterRepairUtil {
    private final ArrayList<ArrayList<Double>> td = new ArrayList();
    private final ArrayList<ArrayList<Double>> tdCleaned = new ArrayList();
    private final ArrayList<ArrayList<Double>> md = new ArrayList();
    private final ArrayList<Long> tdTime = new ArrayList();
    private final int columnCnt;
    private long omega;
    private Double eta;
    private int k;
    private double[] std;
    private KDTreeUtil kdTreeUtil;

    public MasterRepairUtil(int columnCnt, long omega, double eta, int k) {
        this.columnCnt = columnCnt;
        this.omega = omega;
        this.eta = eta;
        this.k = k;
    }

    public boolean isNullRow(Row row) {
        boolean flag = true;
        for (int i = 0; i < row.size(); ++i) {
            if (row.isNull(i)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public void addRow(Row row) throws Exception {
        ArrayList<Double> tt = new ArrayList<Double>();
        boolean containsNotNull = false;
        for (int i = 0; i < this.columnCnt; ++i) {
            if (!row.isNull(i)) {
                containsNotNull = true;
                BigDecimal bd = BigDecimal.valueOf(MasterRepairUtil.getValueAsDouble(row, i));
                tt.add(bd.doubleValue());
                continue;
            }
            tt.add(null);
        }
        if (containsNotNull) {
            this.td.add(tt);
            this.tdTime.add(row.getTime());
        }
        ArrayList<Double> mt = new ArrayList<Double>();
        containsNotNull = false;
        for (int i = this.columnCnt; i < row.size(); ++i) {
            if (!row.isNull(i)) {
                containsNotNull = true;
                BigDecimal bd = BigDecimal.valueOf(MasterRepairUtil.getValueAsDouble(row, i));
                mt.add(bd.doubleValue());
                continue;
            }
            mt.add(null);
        }
        if (containsNotNull) {
            this.md.add(mt);
        }
    }

    public static double getValueAsDouble(Row row, int index) throws Exception {
        double ans;
        try {
            switch (row.getDataType(index)) {
                case INT32: {
                    ans = row.getInt(index);
                    break;
                }
                case INT64: {
                    ans = row.getLong(index);
                    break;
                }
                case FLOAT: {
                    ans = row.getFloat(index);
                    break;
                }
                case DOUBLE: {
                    ans = row.getDouble(index);
                    break;
                }
                default: {
                    throw new Exception("The value of the input time series is not numeric.\n");
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Fail to get data type in row " + row.getTime(), e);
        }
        return ans;
    }

    public void buildKDTree() {
        this.kdTreeUtil = KDTreeUtil.build(this.md, this.columnCnt);
    }

    public ArrayList<Double> getCleanResultColumn(int columnPos) {
        ArrayList<Double> column = new ArrayList<Double>();
        for (ArrayList<Double> tuple : this.tdCleaned) {
            column.add(tuple.get(columnPos - 1));
        }
        return column;
    }

    public ArrayList<Long> getTime() {
        return this.tdTime;
    }

    public double getTmDistance(ArrayList<Double> tTuple, ArrayList<Double> mTuple) {
        double distance = 0.0;
        for (int pos = 0; pos < this.columnCnt; ++pos) {
            double temp = tTuple.get(pos) - mTuple.get(pos);
            distance += (temp /= this.std[pos]) * temp;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    public ArrayList<Integer> calW(int i) {
        ArrayList<Integer> Wi = new ArrayList<Integer>();
        for (int l = i - 1; l >= 0; --l) {
            if (this.tdTime.get(i) > this.tdTime.get(l) + this.omega) continue;
            Wi.add(l);
        }
        return Wi;
    }

    public ArrayList<ArrayList<Double>> calC(int i, ArrayList<Integer> Wi) {
        ArrayList<ArrayList<Double>> Ci = new ArrayList<ArrayList<Double>>();
        if (Wi.size() == 0) {
            Ci.add(this.kdTreeUtil.query(this.td.get(i), this.std));
        } else {
            Ci.addAll(this.kdTreeUtil.queryKNN(this.td.get(i), this.k, this.std));
            for (Integer integer : Wi) {
                Ci.addAll(this.kdTreeUtil.queryKNN(this.tdCleaned.get(integer), this.k, this.std));
            }
        }
        return Ci;
    }

    public void masterRepair() {
        for (int i = 0; i < this.td.size(); ++i) {
            ArrayList<Double> tuple = this.td.get(i);
            ArrayList<Integer> Wi = this.calW(i);
            ArrayList<ArrayList<Double>> Ci = this.calC(i, Wi);
            double minDis = Double.MAX_VALUE;
            ArrayList<Object> repairTuple = new ArrayList();
            for (ArrayList<Double> ci : Ci) {
                double dis;
                boolean smooth = true;
                for (Integer wi : Wi) {
                    ArrayList<Double> wis = this.tdCleaned.get(wi);
                    if (!(this.getTmDistance(ci, wis) > this.eta)) continue;
                    smooth = false;
                    break;
                }
                if (!smooth || !((dis = this.getTmDistance(ci, tuple)) < minDis)) continue;
                minDis = dis;
                repairTuple = ci;
            }
            this.tdCleaned.add(repairTuple);
        }
    }

    public void setParameters() {
        if (this.omega == -1L) {
            ArrayList<Long> intervals = this.getIntervals();
            Collections.sort(intervals);
            long interval = intervals.get(intervals.size() / 2);
            this.omega = interval * 10L;
        }
        if (Double.isNaN(this.eta)) {
            ArrayList<Double> distanceList = new ArrayList<Double>();
            for (int i = 1; i < this.td.size(); ++i) {
                for (int l = i - 1; l >= 0 && this.tdTime.get(i) <= this.tdTime.get(l) + this.omega; --l) {
                    distanceList.add(this.getTmDistance(this.td.get(i), this.td.get(l)));
                }
            }
            Collections.sort(distanceList);
            this.eta = (Double)distanceList.get((int)((double)distanceList.size() * 0.9973));
        }
        if (this.k == -1) {
            for (int tempK = 2; tempK <= 5; ++tempK) {
                ArrayList<Double> distanceList = new ArrayList<Double>();
                for (ArrayList<Double> tuple : this.td) {
                    ArrayList<ArrayList<Double>> neighbors = this.kdTreeUtil.queryKNN(tuple, tempK, this.std);
                    for (ArrayList<Double> neighbor : neighbors) {
                        distanceList.add(this.getTmDistance(tuple, neighbor));
                    }
                }
                Collections.sort(distanceList);
                if (!((Double)distanceList.get((int)((double)distanceList.size() * 0.9)) > this.eta)) continue;
                this.k = tempK;
                break;
            }
            if (this.k == -1) {
                this.k = Integer.min(5, this.md.size());
            }
        }
    }

    private double varianceImperative(double[] value) {
        double average = 0.0;
        int cnt = 0;
        for (double p : value) {
            if (Double.isNaN(p)) continue;
            ++cnt;
            average += p;
        }
        if (cnt == 0) {
            return 0.0;
        }
        average /= (double)cnt;
        double variance = 0.0;
        for (double p : value) {
            if (Double.isNaN(p)) continue;
            variance += (p - average) * (p - average);
        }
        return variance / (double)cnt;
    }

    private double[] getColumn(int pos) {
        double[] column = new double[this.td.size()];
        for (int i = 0; i < this.td.size(); ++i) {
            column[i] = this.td.get(i).get(pos);
        }
        return column;
    }

    public void callStd() {
        this.std = new double[this.columnCnt];
        for (int i = 0; i < this.columnCnt; ++i) {
            this.std[i] = Math.sqrt(this.varianceImperative(this.getColumn(i)));
        }
    }

    public void repair() {
        this.fillNullValue();
        this.buildKDTree();
        this.callStd();
        this.setParameters();
        this.masterRepair();
    }

    public ArrayList<Long> getIntervals() {
        ArrayList<Long> intervals = new ArrayList<Long>();
        for (int i = 1; i < this.tdTime.size(); ++i) {
            intervals.add(this.tdTime.get(i) - this.tdTime.get(i - 1));
        }
        return intervals;
    }

    public void fillNullValue() {
        for (int i = 0; i < this.columnCnt; ++i) {
            double temp = this.td.get(0).get(i);
            for (ArrayList<Double> arrayList : this.td) {
                if (arrayList.get(i) == null) {
                    arrayList.set(i, temp);
                    continue;
                }
                temp = arrayList.get(i);
            }
        }
    }
}

