/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.simple;

import java.io.File;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;

public class SimpleServerImpl
implements IStateMachine {
    private final Peer peer;
    private final IStateMachine stateMachine;

    public SimpleServerImpl(Peer peer, IStateMachine stateMachine) {
        this.peer = peer;
        this.stateMachine = stateMachine;
    }

    public Peer getPeer() {
        return this.peer;
    }

    public IStateMachine getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public void start() {
        this.stateMachine.start();
        this.stateMachine.event().notifyLeaderChanged(this.peer.getGroupId(), this.peer.getNodeId());
    }

    @Override
    public void stop() {
        this.stateMachine.stop();
    }

    @Override
    public boolean isReadOnly() {
        return this.stateMachine.isReadOnly();
    }

    @Override
    public TSStatus write(IConsensusRequest request) {
        return this.stateMachine.write(request);
    }

    @Override
    public DataSet read(IConsensusRequest request) {
        return this.stateMachine.read(request);
    }

    @Override
    public boolean takeSnapshot(File snapshotDir) {
        return this.stateMachine.takeSnapshot(snapshotDir);
    }

    @Override
    public void loadSnapshot(File latestSnapshotRootDir) {
        this.stateMachine.loadSnapshot(latestSnapshotRootDir);
    }
}

