/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.DataStreamException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public interface ClientProtoUtils {
    public static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(ByteString requestorId, ByteString replyId, RaftGroupId groupId, Long callId, boolean success) {
        return RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(requestorId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)).setCallId(Optional.ofNullable(callId).orElseGet(CallId::getDefault).longValue()).setSuccess(success);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftGroupMemberId requestorId, RaftPeerId replyId) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(requestorId.getPeerId().toByteString(), replyId.toByteString(), requestorId.getGroupId(), null, false, null, null, 0L);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ByteString requesterId, ByteString replyId, RaftGroupId groupId, Long callId, boolean toLeader, RaftProtos.SlidingWindowEntry slidingWindowEntry, RoutingTable routingTable, long timeoutMs) {
        if (slidingWindowEntry == null) {
            slidingWindowEntry = RaftProtos.SlidingWindowEntry.getDefaultInstance();
        }
        RaftProtos.RaftRpcRequestProto.Builder b = RaftProtos.RaftRpcRequestProto.newBuilder().setRequestorId(requesterId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)).setCallId(Optional.ofNullable(callId).orElseGet(CallId::getDefault).longValue()).setToLeader(toLeader).setSlidingWindowEntry(slidingWindowEntry).setTimeoutMs(timeoutMs);
        if (routingTable != null) {
            b.setRoutingTable(routingTable.toProto());
        }
        return b;
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ClientId requesterId, RaftPeerId replyId, RaftGroupId groupId, long callId, boolean toLeader, RaftProtos.SlidingWindowEntry slidingWindowEntry, RoutingTable routingTable, long timeoutMs) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(requesterId.toByteString(), replyId.toByteString(), groupId, (Long)callId, toLeader, slidingWindowEntry, routingTable, timeoutMs);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftClientRequest request) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(request.getClientId(), request.getServerId(), request.getRaftGroupId(), request.getCallId(), request.isToLeader(), request.getSlidingWindowEntry(), request.getRoutingTable(), request.getTimeoutMs());
    }

    public static RaftClientRequest.Type toRaftClientRequestType(RaftProtos.RaftClientRequestProto p) {
        switch (p.getTypeCase()) {
            case WRITE: {
                return RaftClientRequest.Type.valueOf((RaftProtos.WriteRequestTypeProto)p.getWrite());
            }
            case DATASTREAM: {
                return RaftClientRequest.Type.valueOf((RaftProtos.DataStreamRequestTypeProto)p.getDataStream());
            }
            case FORWARD: {
                return RaftClientRequest.Type.valueOf((RaftProtos.ForwardRequestTypeProto)p.getForward());
            }
            case MESSAGESTREAM: {
                return RaftClientRequest.Type.valueOf((RaftProtos.MessageStreamRequestTypeProto)p.getMessageStream());
            }
            case READ: {
                return RaftClientRequest.Type.valueOf((RaftProtos.ReadRequestTypeProto)p.getRead());
            }
            case STALEREAD: {
                return RaftClientRequest.Type.valueOf((RaftProtos.StaleReadRequestTypeProto)p.getStaleRead());
            }
            case WATCH: {
                return RaftClientRequest.Type.valueOf((RaftProtos.WatchRequestTypeProto)p.getWatch());
            }
        }
        throw new IllegalArgumentException("Unexpected request type: " + p.getTypeCase() + " in request proto " + p);
    }

    public static RoutingTable getRoutingTable(RaftProtos.RaftRpcRequestProto p) {
        if (!p.hasRoutingTable()) {
            return null;
        }
        RoutingTable.Builder builder = RoutingTable.newBuilder();
        for (RaftProtos.RouteProto routeProto : p.getRoutingTable().getRoutesList()) {
            RaftPeerId from = RaftPeerId.valueOf((ByteString)routeProto.getPeerId().getId());
            List to = routeProto.getSuccessorsList().stream().map(v -> RaftPeerId.valueOf((ByteString)v.getId())).collect(Collectors.toList());
            builder.addSuccessors(from, to);
        }
        return builder.build();
    }

    public static RaftClientRequest toRaftClientRequest(RaftProtos.RaftClientRequestProto p) {
        RaftClientRequest.Type type = ClientProtoUtils.toRaftClientRequestType(p);
        RaftProtos.RaftRpcRequestProto request = p.getRpcRequest();
        RaftClientRequest.Builder b = RaftClientRequest.newBuilder();
        RaftPeerId perrId = RaftPeerId.valueOf((ByteString)request.getReplyId());
        if (request.getToLeader()) {
            b.setLeaderId(perrId);
        } else {
            b.setServerId(perrId);
        }
        return b.setClientId(ClientId.valueOf((ByteString)request.getRequestorId())).setGroupId(ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId())).setCallId(request.getCallId()).setMessage(ClientProtoUtils.toMessage(p.getMessage())).setType(type).setSlidingWindowEntry(request.getSlidingWindowEntry()).setRoutingTable(ClientProtoUtils.getRoutingTable(request)).setTimeoutMs(request.getTimeoutMs()).build();
    }

    public static ByteBuffer toRaftClientRequestProtoByteBuffer(RaftClientRequest request) {
        return ClientProtoUtils.toRaftClientRequestProto(request).toByteString().asReadOnlyByteBuffer();
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(RaftClientRequest request) {
        RaftProtos.RaftClientRequestProto.Builder b = RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        if (request.getMessage() != null) {
            b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(request.getMessage()));
        }
        RaftClientRequest.Type type = request.getType();
        switch (type.getTypeCase()) {
            case WRITE: {
                b.setWrite(type.getWrite());
                break;
            }
            case DATASTREAM: {
                b.setDataStream(type.getDataStream());
                break;
            }
            case FORWARD: {
                b.setForward(type.getForward());
                break;
            }
            case MESSAGESTREAM: {
                b.setMessageStream(type.getMessageStream());
                break;
            }
            case READ: {
                b.setRead(type.getRead());
                break;
            }
            case STALEREAD: {
                b.setStaleRead(type.getStaleRead());
                break;
            }
            case WATCH: {
                b.setWatch(type.getWatch());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type: " + request.getType() + " in request " + request);
            }
        }
        return b.build();
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, long seqNum, ByteString content) {
        return RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(clientId, serverId, groupId, callId, false, ProtoUtils.toSlidingWindowEntry((long)seqNum, (boolean)false), null, 0L)).setWrite(RaftProtos.WriteRequestTypeProto.getDefaultInstance()).setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(content)).build();
    }

    public static RaftProtos.StateMachineExceptionProto.Builder toStateMachineExceptionProtoBuilder(StateMachineException e) {
        Throwable t = e.getCause() != null ? e.getCause() : e;
        return RaftProtos.StateMachineExceptionProto.newBuilder().setExceptionClassName(t.getClass().getName()).setErrorMsg(t.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString((Object)t.getStackTrace()));
    }

    public static RaftProtos.AlreadyClosedExceptionProto.Builder toAlreadyClosedExceptionProtoBuilder(AlreadyClosedException ace) {
        Throwable t = ace.getCause() != null ? ace.getCause() : ace;
        return RaftProtos.AlreadyClosedExceptionProto.newBuilder().setExceptionClassName(t.getClass().getName()).setErrorMsg(ace.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString((Object)ace.getStackTrace()));
    }

    public static RaftProtos.RaftClientReplyProto toRaftClientReplyProto(RaftClientReply reply) {
        RaftProtos.RaftClientReplyProto.Builder b = RaftProtos.RaftClientReplyProto.newBuilder();
        if (reply != null) {
            LeaderNotReadyException lnre;
            NotReplicatedException nre;
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            b.setLogIndex(reply.getLogIndex());
            if (reply.getMessage() != null) {
                b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(reply.getMessage()));
            }
            b.addAllCommitInfos((Iterable)reply.getCommitInfos());
            NotLeaderException nle = reply.getNotLeaderException();
            if (nle != null) {
                RaftProtos.NotLeaderExceptionProto.Builder nleBuilder = RaftProtos.NotLeaderExceptionProto.newBuilder();
                RaftPeer suggestedLeader = nle.getSuggestedLeader();
                if (suggestedLeader != null) {
                    nleBuilder.setSuggestedLeader(suggestedLeader.getRaftPeerProto());
                }
                nleBuilder.addAllPeersInConf(ProtoUtils.toRaftPeerProtos((Collection)nle.getPeers()));
                b.setNotLeaderException(nleBuilder.build());
            }
            if ((nre = reply.getNotReplicatedException()) != null) {
                RaftProtos.NotReplicatedExceptionProto.Builder nreBuilder = RaftProtos.NotReplicatedExceptionProto.newBuilder().setCallId(nre.getCallId()).setReplication(nre.getRequiredReplication()).setLogIndex(nre.getLogIndex());
                b.setNotReplicatedException(nreBuilder);
            }
            if ((lnre = reply.getLeaderNotReadyException()) != null) {
                RaftProtos.LeaderNotReadyExceptionProto.Builder lnreBuilder = RaftProtos.LeaderNotReadyExceptionProto.newBuilder().setServerId(ProtoUtils.toRaftGroupMemberIdProtoBuilder((RaftGroupMemberId)lnre.getServerId()));
                b.setLeaderNotReadyException(lnreBuilder);
            }
            Optional.ofNullable(reply.getStateMachineException()).map(ClientProtoUtils::toStateMachineExceptionProtoBuilder).ifPresent(arg_0 -> ((RaftProtos.RaftClientReplyProto.Builder)b).setStateMachineException(arg_0));
            Optional.ofNullable(reply.getDataStreamException()).map(ProtoUtils::toThrowableProto).ifPresent(arg_0 -> ((RaftProtos.RaftClientReplyProto.Builder)b).setDataStreamException(arg_0));
            Optional.ofNullable(reply.getAlreadyClosedException()).map(ClientProtoUtils::toAlreadyClosedExceptionProtoBuilder).ifPresent(arg_0 -> ((RaftProtos.RaftClientReplyProto.Builder)b).setAlreadyClosedException(arg_0));
            Optional.ofNullable(reply.getLeaderSteppingDownException()).map(ProtoUtils::toThrowableProto).ifPresent(arg_0 -> ((RaftProtos.RaftClientReplyProto.Builder)b).setLeaderSteppingDownException(arg_0));
            Optional.ofNullable(reply.getTransferLeadershipException()).map(ProtoUtils::toThrowableProto).ifPresent(arg_0 -> ((RaftProtos.RaftClientReplyProto.Builder)b).setTransferLeadershipException(arg_0));
            RaftProtos.RaftClientReplyProto serialized = b.build();
            RaftException e = reply.getException();
            if (e != null) {
                RaftClientReply deserialized = ClientProtoUtils.toRaftClientReply(serialized);
                if (!Optional.ofNullable(deserialized.getException()).map(Object::getClass).filter(e.getClass()::equals).isPresent()) {
                    throw new AssertionError("Corruption while serializing reply= " + reply + " but serialized=" + serialized + " and deserialized=" + deserialized, (Throwable)e);
                }
            }
            return serialized;
        }
        return b.build();
    }

    public static RaftProtos.GroupListReplyProto toGroupListReplyProto(GroupListReply reply) {
        RaftProtos.GroupListReplyProto.Builder b = RaftProtos.GroupListReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getGroupIds() != null) {
                reply.getGroupIds().forEach(groupId -> b.addGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)groupId)));
            }
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoReplyProto toGroupInfoReplyProto(GroupInfoReply reply) {
        RaftProtos.GroupInfoReplyProto.Builder b = RaftProtos.GroupInfoReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getRaftGroupId() != null) {
                b.setGroup(ProtoUtils.toRaftGroupProtoBuilder((RaftGroup)reply.getGroup()));
                b.setIsRaftStorageHealthy(reply.isRaftStorageHealthy());
                b.setRole(reply.getRoleInfoProto());
                b.addAllCommitInfos((Iterable)reply.getCommitInfos());
            }
        }
        return b.build();
    }

    public static RaftClientReply getRaftClientReply(DataStreamReply reply) {
        if (!(reply instanceof DataStreamReplyByteBuffer)) {
            throw new IllegalStateException("Unexpected " + reply.getClass() + ": reply is " + reply);
        }
        try {
            return ClientProtoUtils.toRaftClientReply(((DataStreamReplyByteBuffer)reply).slice());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Failed to getRaftClientReply from " + reply, e);
        }
    }

    public static RaftClientReply toRaftClientReply(ByteBuffer buffer) throws InvalidProtocolBufferException {
        return ClientProtoUtils.toRaftClientReply(RaftProtos.RaftClientReplyProto.parseFrom((ByteBuffer)buffer));
    }

    public static RaftClientReply toRaftClientReply(RaftProtos.RaftClientReplyProto replyProto) {
        Object e;
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        RaftGroupMemberId serverMemberId = ProtoUtils.toRaftGroupMemberId((ByteString)rp.getReplyId(), (RaftProtos.RaftGroupIdProto)rp.getRaftGroupId());
        if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTLEADEREXCEPTION)) {
            RaftProtos.NotLeaderExceptionProto nleProto = replyProto.getNotLeaderException();
            RaftPeer suggestedLeader = nleProto.hasSuggestedLeader() ? ProtoUtils.toRaftPeer((RaftProtos.RaftPeerProto)nleProto.getSuggestedLeader()) : null;
            List peers = ProtoUtils.toRaftPeers((List)nleProto.getPeersInConfList());
            e = new NotLeaderException(serverMemberId, suggestedLeader, (Collection)peers);
        } else if (replyProto.getExceptionDetailsCase() == RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTREPLICATEDEXCEPTION) {
            RaftProtos.NotReplicatedExceptionProto nre = replyProto.getNotReplicatedException();
            e = new NotReplicatedException(nre.getCallId(), nre.getReplication(), nre.getLogIndex());
        } else if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.STATEMACHINEEXCEPTION)) {
            e = ClientProtoUtils.toStateMachineException(serverMemberId, replyProto.getStateMachineException());
        } else if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.DATASTREAMEXCEPTION)) {
            e = (RaftException)ProtoUtils.toThrowable((RaftProtos.ThrowableProto)replyProto.getDataStreamException(), DataStreamException.class);
        } else if (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.LEADERNOTREADYEXCEPTION)) {
            RaftProtos.LeaderNotReadyExceptionProto lnreProto = replyProto.getLeaderNotReadyException();
            e = new LeaderNotReadyException(ProtoUtils.toRaftGroupMemberId((RaftProtos.RaftGroupMemberIdProto)lnreProto.getServerId()));
        } else {
            e = replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.ALREADYCLOSEDEXCEPTION) ? ClientProtoUtils.toAlreadyClosedException(replyProto.getAlreadyClosedException()) : (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.LEADERSTEPPINGDOWNEXCEPTION) ? (RaftException)ProtoUtils.toThrowable((RaftProtos.ThrowableProto)replyProto.getLeaderSteppingDownException(), LeaderSteppingDownException.class) : (replyProto.getExceptionDetailsCase().equals((Object)RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.TRANSFERLEADERSHIPEXCEPTION) ? (RaftException)ProtoUtils.toThrowable((RaftProtos.ThrowableProto)replyProto.getTransferLeadershipException(), TransferLeadershipException.class) : null));
        }
        return RaftClientReply.newBuilder().setClientId(ClientId.valueOf((ByteString)rp.getRequestorId())).setServerId(serverMemberId).setCallId(rp.getCallId()).setSuccess(rp.getSuccess()).setMessage(ClientProtoUtils.toMessage(replyProto.getMessage())).setException((RaftException)e).setLogIndex(replyProto.getLogIndex()).setCommitInfos((Collection)replyProto.getCommitInfosList()).build();
    }

    public static StateMachineException toStateMachineException(RaftGroupMemberId memberId, RaftProtos.StateMachineExceptionProto proto) {
        return ClientProtoUtils.toStateMachineException(memberId, proto.getExceptionClassName(), proto.getErrorMsg(), proto.getStacktrace());
    }

    public static StateMachineException toStateMachineException(RaftGroupMemberId memberId, String className, String errorMsg, ByteString stackTraceBytes) {
        StateMachineException sme;
        if (className == null) {
            sme = new StateMachineException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = (Exception)ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), (String)errorMsg);
                sme = new StateMachineException(memberId, (Throwable)e);
            }
            catch (Exception e) {
                sme = new StateMachineException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject((ByteString)stackTraceBytes);
        sme.setStackTrace(stacktrace);
        return sme;
    }

    public static AlreadyClosedException toAlreadyClosedException(RaftProtos.AlreadyClosedExceptionProto proto) {
        return ClientProtoUtils.toAlreadyClosedException(proto.getExceptionClassName(), proto.getErrorMsg(), proto.getStacktrace());
    }

    public static AlreadyClosedException toAlreadyClosedException(String className, String errorMsg, ByteString stackTraceBytes) {
        AlreadyClosedException ace;
        if (className == null) {
            ace = new AlreadyClosedException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = (Exception)ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), (String)errorMsg);
                ace = new AlreadyClosedException(errorMsg, (Throwable)e);
            }
            catch (Exception e) {
                ace = new AlreadyClosedException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject((ByteString)stackTraceBytes);
        ace.setStackTrace(stacktrace);
        return ace;
    }

    public static GroupListReply toGroupListReply(RaftProtos.GroupListReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rpc = replyProto.getRpcReply();
        List groupIds = replyProto.getGroupIdList().stream().map(ProtoUtils::toRaftGroupId).collect(Collectors.toList());
        return new GroupListReply(ClientId.valueOf((ByteString)rpc.getRequestorId()), RaftPeerId.valueOf((ByteString)rpc.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)rpc.getRaftGroupId()), rpc.getCallId(), groupIds);
    }

    public static GroupInfoReply toGroupInfoReply(RaftProtos.GroupInfoReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rpc = replyProto.getRpcReply();
        return new GroupInfoReply(ClientId.valueOf((ByteString)rpc.getRequestorId()), RaftPeerId.valueOf((ByteString)rpc.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)rpc.getRaftGroupId()), rpc.getCallId(), (Collection)replyProto.getCommitInfosList(), ProtoUtils.toRaftGroup((RaftProtos.RaftGroupProto)replyProto.getGroup()), replyProto.getRole(), replyProto.getIsRaftStorageHealthy());
    }

    public static Message toMessage(RaftProtos.ClientMessageEntryProto p) {
        return Message.valueOf((ByteString)p.getContent());
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(ByteString message) {
        return RaftProtos.ClientMessageEntryProto.newBuilder().setContent(message);
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(Message message) {
        return ClientProtoUtils.toClientMessageEntryProtoBuilder(message.getContent());
    }

    public static SetConfigurationRequest toSetConfigurationRequest(RaftProtos.SetConfigurationRequestProto p) {
        SetConfigurationRequest.Arguments arguments = SetConfigurationRequest.Arguments.newBuilder().setServersInNewConf(ProtoUtils.toRaftPeers((List)p.getPeersList())).setListenersInNewConf(ProtoUtils.toRaftPeers((List)p.getListenersList())).setServersInCurrentConf(ProtoUtils.toRaftPeers((List)p.getCurrentPeersList())).setListenersInCurrentConf(ProtoUtils.toRaftPeers((List)p.getCurrentListenersList())).setMode(ClientProtoUtils.toSetConfigurationMode(p.getMode())).build();
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        return new SetConfigurationRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), p.getRpcRequest().getCallId(), arguments);
    }

    public static SetConfigurationRequest.Mode toSetConfigurationMode(RaftProtos.SetConfigurationRequestProto.Mode p) {
        switch (p) {
            case SET_UNCONDITIONALLY: {
                return SetConfigurationRequest.Mode.SET_UNCONDITIONALLY;
            }
            case ADD: {
                return SetConfigurationRequest.Mode.ADD;
            }
            case COMPARE_AND_SET: {
                return SetConfigurationRequest.Mode.COMPARE_AND_SET;
            }
        }
        throw new IllegalArgumentException("Unexpected mode " + p);
    }

    public static RaftProtos.SetConfigurationRequestProto toSetConfigurationRequestProto(SetConfigurationRequest request) {
        SetConfigurationRequest.Arguments arguments = request.getArguments();
        return RaftProtos.SetConfigurationRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).addAllPeers(ProtoUtils.toRaftPeerProtos((Collection)arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.FOLLOWER))).addAllListeners(ProtoUtils.toRaftPeerProtos((Collection)arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.LISTENER))).addAllCurrentPeers(ProtoUtils.toRaftPeerProtos((Collection)arguments.getServersInCurrentConf())).addAllCurrentListeners(ProtoUtils.toRaftPeerProtos((Collection)arguments.getListenersInCurrentConf())).setMode(RaftProtos.SetConfigurationRequestProto.Mode.valueOf((String)arguments.getMode().name())).build();
    }

    public static TransferLeadershipRequest toTransferLeadershipRequest(RaftProtos.TransferLeadershipRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        RaftPeerId newLeader = p.hasNewLeader() ? ProtoUtils.toRaftPeer((RaftProtos.RaftPeerProto)p.getNewLeader()).getId() : null;
        return new TransferLeadershipRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), p.getRpcRequest().getCallId(), newLeader, m.getTimeoutMs());
    }

    public static RaftProtos.TransferLeadershipRequestProto toTransferLeadershipRequestProto(TransferLeadershipRequest request) {
        RaftProtos.TransferLeadershipRequestProto.Builder b = RaftProtos.TransferLeadershipRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request));
        Optional.ofNullable(request.getNewLeader()).map(l -> RaftPeer.newBuilder().setId(l).build()).map(RaftPeer::getRaftPeerProto).ifPresent(arg_0 -> ((RaftProtos.TransferLeadershipRequestProto.Builder)b).setNewLeader(arg_0));
        return b.build();
    }

    public static GroupManagementRequest toGroupManagementRequest(RaftProtos.GroupManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf((ByteString)m.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf((ByteString)m.getReplyId());
        switch (p.getOpCase()) {
            case GROUPADD: {
                return GroupManagementRequest.newAdd((ClientId)clientId, (RaftPeerId)serverId, (long)m.getCallId(), (RaftGroup)ProtoUtils.toRaftGroup((RaftProtos.RaftGroupProto)p.getGroupAdd().getGroup()));
            }
            case GROUPREMOVE: {
                RaftProtos.GroupRemoveRequestProto remove = p.getGroupRemove();
                return GroupManagementRequest.newRemove((ClientId)clientId, (RaftPeerId)serverId, (long)m.getCallId(), (RaftGroupId)ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)remove.getGroupId()), (boolean)remove.getDeleteDirectory(), (boolean)remove.getRenameDirectory());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static GroupInfoRequest toGroupInfoRequest(RaftProtos.GroupInfoRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        return new GroupInfoRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), m.getCallId());
    }

    public static GroupListRequest toGroupListRequest(RaftProtos.GroupListRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        return new GroupListRequest(ClientId.valueOf((ByteString)m.getRequestorId()), RaftPeerId.valueOf((ByteString)m.getReplyId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), m.getCallId());
    }

    public static RaftProtos.GroupManagementRequestProto toGroupManagementRequestProto(GroupManagementRequest request) {
        GroupManagementRequest.Remove remove;
        RaftProtos.GroupManagementRequestProto.Builder b = RaftProtos.GroupManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request));
        GroupManagementRequest.Add add = request.getAdd();
        if (add != null) {
            b.setGroupAdd(RaftProtos.GroupAddRequestProto.newBuilder().setGroup(ProtoUtils.toRaftGroupProtoBuilder((RaftGroup)add.getGroup())).build());
        }
        if ((remove = request.getRemove()) != null) {
            b.setGroupRemove(RaftProtos.GroupRemoveRequestProto.newBuilder().setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)remove.getGroupId())).setDeleteDirectory(remove.isDeleteDirectory()).setRenameDirectory(remove.isRenameDirectory()).build());
        }
        return b.build();
    }

    public static SnapshotManagementRequest toSnapshotManagementRequest(RaftProtos.SnapshotManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf((ByteString)m.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf((ByteString)m.getReplyId());
        switch (p.getOpCase()) {
            case CREATE: {
                return SnapshotManagementRequest.newCreate((ClientId)clientId, (RaftPeerId)serverId, (RaftGroupId)ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), (long)m.getCallId(), (long)m.getTimeoutMs());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static RaftProtos.SnapshotManagementRequestProto toSnapshotManagementRequestProto(SnapshotManagementRequest request) {
        RaftProtos.SnapshotManagementRequestProto.Builder b = RaftProtos.SnapshotManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request));
        SnapshotManagementRequest.Create create = request.getCreate();
        if (create != null) {
            b.setCreate(RaftProtos.SnapshotCreateRequestProto.newBuilder().build());
        }
        return b.build();
    }

    public static LeaderElectionManagementRequest toLeaderElectionManagementRequest(RaftProtos.LeaderElectionManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf((ByteString)m.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf((ByteString)m.getReplyId());
        switch (p.getOpCase()) {
            case PAUSE: {
                return LeaderElectionManagementRequest.newPause((ClientId)clientId, (RaftPeerId)serverId, (RaftGroupId)ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), (long)m.getCallId());
            }
            case RESUME: {
                return LeaderElectionManagementRequest.newResume((ClientId)clientId, (RaftPeerId)serverId, (RaftGroupId)ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)m.getRaftGroupId()), (long)m.getCallId());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static RaftProtos.LeaderElectionManagementRequestProto toLeaderElectionManagementRequestProto(LeaderElectionManagementRequest request) {
        LeaderElectionManagementRequest.Resume resume;
        RaftProtos.LeaderElectionManagementRequestProto.Builder b = RaftProtos.LeaderElectionManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request));
        LeaderElectionManagementRequest.Pause pause = request.getPause();
        if (pause != null) {
            b.setPause(RaftProtos.LeaderElectionPauseRequestProto.newBuilder().build());
        }
        if ((resume = request.getResume()) != null) {
            b.setResume(RaftProtos.LeaderElectionResumeRequestProto.newBuilder().build());
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoRequestProto toGroupInfoRequestProto(GroupInfoRequest request) {
        return RaftProtos.GroupInfoRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).build();
    }

    public static RaftProtos.GroupListRequestProto toGroupListRequestProto(GroupListRequest request) {
        return RaftProtos.GroupListRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftClientRequest)request)).build();
    }

    public static String toString(RaftProtos.RaftClientRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpc = proto.getRpcRequest();
        return ClientId.valueOf((ByteString)rpc.getRequestorId()) + "->" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId() + "-" + ProtoUtils.toString((RaftProtos.SlidingWindowEntry)rpc.getSlidingWindowEntry());
    }

    public static String toString(RaftProtos.RaftClientReplyProto proto) {
        RaftProtos.RaftRpcReplyProto rpc = proto.getRpcReply();
        return ClientId.valueOf((ByteString)rpc.getRequestorId()) + "<-" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId();
    }
}

