/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.sync.AbstractOperatePipeProcedure;
import org.apache.iotdb.confignode.procedure.state.sync.OperatePipeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipeProcedure
extends AbstractOperatePipeProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatePipeProcedure.class);
    private PipeInfo pipeInfo;
    private Set<Integer> executedDataNodeIds = new HashSet<Integer>();

    public CreatePipeProcedure() {
    }

    public CreatePipeProcedure(TCreatePipeReq req) throws PipeException {
        this.pipeInfo = SyncPipeUtil.parseTCreatePipeReqAsPipeInfo((TCreatePipeReq)req, (long)System.currentTimeMillis());
    }

    public void setExecutedDataNodeIds(Set<Integer> executedDataNodeIds) {
        this.executedDataNodeIds = executedDataNodeIds;
    }

    @Override
    boolean executeCheckCanSkip(ConfigNodeProcedureEnv env) throws PipeException, PipeSinkException {
        LOGGER.info("Start to create PIPE [{}]", (Object)this.pipeInfo.getPipeName());
        env.getConfigManager().getSyncManager().checkAddPipe(this.pipeInfo);
        return false;
    }

    @Override
    void executePreOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to pre-create PIPE [{}] on Config Nodes", (Object)this.pipeInfo.getPipeName());
        TSStatus status = env.getConfigManager().getSyncManager().preCreatePipe(this.pipeInfo);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    void executeOperatePipeOnDataNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to broadcast create PIPE [{}] on Data Nodes", (Object)this.pipeInfo.getPipeName());
        Map<Integer, TSStatus> responseMap = env.getConfigManager().getSyncManager().preCreatePipeOnDataNodes(this.pipeInfo);
        TSStatus status = RpcUtils.squashResponseStatusList(new ArrayList<TSStatus>(responseMap.values()));
        this.executedDataNodeIds.addAll(responseMap.keySet());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Fail to create PIPE [%s] because %s.", this.pipeInfo.getPipeName(), StringUtils.join((Object[])responseMap.values().stream().filter(i -> i.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()).map(TSStatus::getMessage).toArray(), (String)", ")));
        }
    }

    @Override
    void executeOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to create PIPE [{}] on Config Nodes", (Object)this.pipeInfo.getPipeName());
        TSStatus status = env.getConfigManager().getSyncManager().setPipeStatus(this.pipeInfo.getPipeName(), PipeStatus.STOP);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    SyncOperation getOperation() {
        return SyncOperation.CREATE_PIPE;
    }

    @Override
    protected boolean isRollbackSupported(OperatePipeState state) {
        switch (state) {
            case OPERATE_CHECK: 
            case PRE_OPERATE_PIPE_CONFIGNODE: 
            case OPERATE_PIPE_DATANODE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperatePipeState state) throws IOException, InterruptedException, ProcedureException {
        LOGGER.info("Roll back CreatePipeProcedure at STATE [{}]", (Object)state);
        switch (state) {
            case OPERATE_CHECK: {
                env.getConfigManager().getSyncManager().unlockSyncMetadata();
                break;
            }
            case PRE_OPERATE_PIPE_CONFIGNODE: {
                TSStatus status = env.getConfigManager().getSyncManager().dropPipe(this.pipeInfo.getPipeName());
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                throw new ProcedureException(String.format("Failed to create pipe and failed to roll back because %s. Please execute [DROP PIPE %s] manually.", status.getMessage(), this.pipeInfo.getPipeName()));
            }
            case OPERATE_PIPE_DATANODE: {
                env.getConfigManager().getSyncManager().operatePipeOnDataNodesForRollback(this.pipeInfo.getPipeName(), this.pipeInfo.getCreateTime(), SyncOperation.DROP_PIPE, this.executedDataNodeIds);
                break;
            }
            default: {
                LOGGER.error("Unsupported roll back STATE [{}]", (Object)state);
            }
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_PIPE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        this.pipeInfo.serialize((OutputStream)stream);
        ReadWriteIOUtils.writeIntegerSet(this.executedDataNodeIds, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeInfo = PipeInfo.deserializePipeInfo((ByteBuffer)byteBuffer);
        this.executedDataNodeIds = ReadWriteIOUtils.readIntegerSet((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePipeProcedure that = (CreatePipeProcedure)o;
        return Objects.equals(this.pipeInfo, that.pipeInfo) && Objects.equals(this.executedDataNodeIds, that.executedDataNodeIds);
    }

    public int hashCode() {
        return Objects.hash(this.pipeInfo, this.executedDataNodeIds);
    }
}

