/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.cq;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cq.CQState;
import org.apache.iotdb.commons.cq.TimeoutPolicy;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.write.cq.ActiveCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.AddCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.DropCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.ShowCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.UpdateCQLastExecTimePlan;
import org.apache.iotdb.confignode.consensus.response.ShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CQInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQInfo.class);
    private static final String SNAPSHOT_FILENAME = "cq_info.snapshot";
    private final Map<String, CQEntry> cqMap = new HashMap<String, CQEntry>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus addCQ(AddCQPlan plan) {
        TSStatus res = new TSStatus();
        String cqId = plan.getReq().cqId;
        this.lock.writeLock().lock();
        try {
            if (this.cqMap.containsKey(cqId)) {
                res.code = TSStatusCode.CQ_AlREADY_EXIST.getStatusCode();
                res.message = String.format("CQ %s has already been created.", cqId);
            } else {
                CQEntry cqEntry = new CQEntry(plan.getReq(), plan.getMd5(), plan.getFirstExecutionTime() - plan.getReq().everyInterval);
                this.cqMap.put(cqId, cqEntry);
                res.code = TSStatusCode.SUCCESS_STATUS.getStatusCode();
            }
            TSStatus tSStatus = res;
            return tSStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus dropCQ(DropCQPlan plan) {
        TSStatus res = new TSStatus();
        String cqId = plan.getCqId();
        Optional<String> md5 = plan.getMd5();
        this.lock.writeLock().lock();
        try {
            CQEntry cqEntry = this.cqMap.get(cqId);
            if (cqEntry == null) {
                res.code = TSStatusCode.NO_SUCH_CQ.getStatusCode();
                res.message = String.format("CQ %s doesn't exist.", cqId);
                LOGGER.warn("Drop CQ {} failed, because it doesn't exist.", (Object)cqId);
            } else if (md5.isPresent() && !md5.get().equals(cqEntry.md5)) {
                res.code = TSStatusCode.NO_SUCH_CQ.getStatusCode();
                res.message = String.format("MD5 of CQ %s doesn't match", cqId);
                LOGGER.warn("Drop CQ {} failed, because its MD5 doesn't match.", (Object)cqId);
            } else {
                this.cqMap.remove(cqId);
                res.code = TSStatusCode.SUCCESS_STATUS.getStatusCode();
                LOGGER.info("Drop CQ {} successfully.", (Object)cqId);
            }
            TSStatus tSStatus = res;
            return tSStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ShowCQResp showCQ(ShowCQPlan plan) {
        this.lock.readLock().lock();
        try {
            ShowCQResp showCQResp = new ShowCQResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), this.cqMap.values().stream().map(x$0 -> new CQEntry((CQEntry)x$0)).collect(Collectors.toList()));
            return showCQResp;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus activeCQ(ActiveCQPlan plan) {
        TSStatus res = new TSStatus();
        String cqId = plan.getCqId();
        String md5 = plan.getMd5();
        this.lock.writeLock().lock();
        try {
            CQEntry cqEntry = this.cqMap.get(cqId);
            if (cqEntry == null) {
                res.code = TSStatusCode.NO_SUCH_CQ.getStatusCode();
                res.message = String.format("CQ %s doesn't exist.", cqId);
            } else if (!md5.equals(cqEntry.md5)) {
                res.code = TSStatusCode.NO_SUCH_CQ.getStatusCode();
                res.message = String.format("MD5 of CQ %s doesn't match", cqId);
            } else if (cqEntry.state == CQState.ACTIVE) {
                res.code = TSStatusCode.CQ_ALREADY_ACTIVE.getStatusCode();
                res.message = String.format("CQ %s has already been active", cqId);
            } else {
                cqEntry.state = CQState.ACTIVE;
                res.code = TSStatusCode.SUCCESS_STATUS.getStatusCode();
            }
            TSStatus tSStatus = res;
            return tSStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus updateCQLastExecutionTime(UpdateCQLastExecTimePlan plan) {
        TSStatus res = new TSStatus();
        String cqId = plan.getCqId();
        String md5 = plan.getMd5();
        this.lock.writeLock().lock();
        try {
            CQEntry cqEntry = this.cqMap.get(cqId);
            if (cqEntry == null) {
                res.code = TSStatusCode.NO_SUCH_CQ.getStatusCode();
                res.message = String.format("CQ %s doesn't exist.", cqId);
            } else if (!md5.equals(cqEntry.md5)) {
                res.code = TSStatusCode.NO_SUCH_CQ.getStatusCode();
                res.message = String.format("MD5 of CQ %s doesn't match", cqId);
            } else if (cqEntry.lastExecutionTime >= plan.getExecutionTime()) {
                res.code = TSStatusCode.CQ_UPDATE_LAST_EXEC_TIME_ERROR.getStatusCode();
                res.message = String.format("Update last execution time of CQ %s failed because its original last execution time(%d) is larger than the updated one(%d).", cqId, cqEntry.lastExecutionTime, plan.getExecutionTime());
            } else {
                cqEntry.lastExecutionTime = plan.getExecutionTime();
                res.code = TSStatusCode.SUCCESS_STATUS.getStatusCode();
            }
            TSStatus tSStatus = res;
            return tSStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot of CQInfo, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        this.lock.readLock().lock();
        try {
            boolean bl;
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.serialize(fileOutputStream);
                bl = true;
            }
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.cqMap.size(), (OutputStream)stream);
        for (CQEntry entry : this.cqMap.values()) {
            entry.serialize(stream);
        }
    }

    private void deserialize(InputStream stream) throws IOException {
        int size = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < size; ++i) {
            CQEntry cqEntry = CQEntry.deserialize(stream);
            this.cqMap.put(cqEntry.cqId, cqEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot of CQInfo, snapshot file [{}] does not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.lock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.clear();
            this.deserialize(fileInputStream);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void clear() {
        this.cqMap.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CQInfo cqInfo = (CQInfo)o;
        return Objects.equals(this.cqMap, cqInfo.cqMap);
    }

    public int hashCode() {
        return Objects.hash(this.cqMap);
    }

    public static class CQEntry {
        private final String cqId;
        private final long everyInterval;
        private final long boundaryTime;
        private final long startTimeOffset;
        private final long endTimeOffset;
        private final TimeoutPolicy timeoutPolicy;
        private final String queryBody;
        private final String sql;
        private final String md5;
        private final String zoneId;
        private final String username;
        private CQState state;
        private long lastExecutionTime;

        private CQEntry(TCreateCQReq req, String md5, long lastExecutionTime) {
            this(req.cqId, req.everyInterval, req.boundaryTime, req.startTimeOffset, req.endTimeOffset, TimeoutPolicy.deserialize((byte)req.timeoutPolicy), req.queryBody, req.sql, md5, req.zoneId, req.username, CQState.INACTIVE, lastExecutionTime);
        }

        private CQEntry(CQEntry other) {
            this(other.cqId, other.everyInterval, other.boundaryTime, other.startTimeOffset, other.endTimeOffset, other.timeoutPolicy, other.queryBody, other.sql, other.md5, other.zoneId, other.username, other.state, other.lastExecutionTime);
        }

        private CQEntry(String cqId, long everyInterval, long boundaryTime, long startTimeOffset, long endTimeOffset, TimeoutPolicy timeoutPolicy, String queryBody, String sql, String md5, String zoneId, String username, CQState state, long lastExecutionTime) {
            this.cqId = cqId;
            this.everyInterval = everyInterval;
            this.boundaryTime = boundaryTime;
            this.startTimeOffset = startTimeOffset;
            this.endTimeOffset = endTimeOffset;
            this.timeoutPolicy = timeoutPolicy;
            this.queryBody = queryBody;
            this.sql = sql;
            this.md5 = md5;
            this.zoneId = zoneId;
            this.username = username;
            this.state = state;
            this.lastExecutionTime = lastExecutionTime;
        }

        private void serialize(OutputStream stream) throws IOException {
            ReadWriteIOUtils.write((String)this.cqId, (OutputStream)stream);
            ReadWriteIOUtils.write((long)this.everyInterval, (OutputStream)stream);
            ReadWriteIOUtils.write((long)this.boundaryTime, (OutputStream)stream);
            ReadWriteIOUtils.write((long)this.startTimeOffset, (OutputStream)stream);
            ReadWriteIOUtils.write((long)this.endTimeOffset, (OutputStream)stream);
            ReadWriteIOUtils.write((byte)this.timeoutPolicy.getType(), (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.queryBody, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.sql, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.md5, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.zoneId, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.username, (OutputStream)stream);
            ReadWriteIOUtils.write((byte)this.state.getType(), (OutputStream)stream);
            ReadWriteIOUtils.write((long)this.lastExecutionTime, (OutputStream)stream);
        }

        private static CQEntry deserialize(InputStream stream) throws IOException {
            String cqId = ReadWriteIOUtils.readString((InputStream)stream);
            long everyInterval = ReadWriteIOUtils.readLong((InputStream)stream);
            long boundaryTime = ReadWriteIOUtils.readLong((InputStream)stream);
            long startTimeOffset = ReadWriteIOUtils.readLong((InputStream)stream);
            long endTimeOffset = ReadWriteIOUtils.readLong((InputStream)stream);
            TimeoutPolicy timeoutPolicy = TimeoutPolicy.deserialize((byte)ReadWriteIOUtils.readByte((InputStream)stream));
            String queryBody = ReadWriteIOUtils.readString((InputStream)stream);
            String sql = ReadWriteIOUtils.readString((InputStream)stream);
            String md5 = ReadWriteIOUtils.readString((InputStream)stream);
            String zoneId = ReadWriteIOUtils.readString((InputStream)stream);
            String username = ReadWriteIOUtils.readString((InputStream)stream);
            CQState state = CQState.deserialize((byte)ReadWriteIOUtils.readByte((InputStream)stream));
            long lastExecutionTime = ReadWriteIOUtils.readLong((InputStream)stream);
            return new CQEntry(cqId, everyInterval, boundaryTime, startTimeOffset, endTimeOffset, timeoutPolicy, queryBody, sql, md5, zoneId, username, state, lastExecutionTime);
        }

        public String getCqId() {
            return this.cqId;
        }

        public long getEveryInterval() {
            return this.everyInterval;
        }

        public long getBoundaryTime() {
            return this.boundaryTime;
        }

        public long getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public long getEndTimeOffset() {
            return this.endTimeOffset;
        }

        public TimeoutPolicy getTimeoutPolicy() {
            return this.timeoutPolicy;
        }

        public String getQueryBody() {
            return this.queryBody;
        }

        public String getSql() {
            return this.sql;
        }

        public String getMd5() {
            return this.md5;
        }

        public CQState getState() {
            return this.state;
        }

        public long getLastExecutionTime() {
            return this.lastExecutionTime;
        }

        public String getZoneId() {
            return this.zoneId;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CQEntry cqEntry = (CQEntry)o;
            return this.everyInterval == cqEntry.everyInterval && this.boundaryTime == cqEntry.boundaryTime && this.startTimeOffset == cqEntry.startTimeOffset && this.endTimeOffset == cqEntry.endTimeOffset && this.lastExecutionTime == cqEntry.lastExecutionTime && Objects.equals(this.cqId, cqEntry.cqId) && this.timeoutPolicy == cqEntry.timeoutPolicy && Objects.equals(this.queryBody, cqEntry.queryBody) && Objects.equals(this.sql, cqEntry.sql) && Objects.equals(this.md5, cqEntry.md5) && Objects.equals(this.zoneId, cqEntry.zoneId) && Objects.equals(this.username, cqEntry.username) && this.state == cqEntry.state;
        }

        public int hashCode() {
            return Objects.hash(this.cqId, this.everyInterval, this.boundaryTime, this.startTimeOffset, this.endTimeOffset, this.timeoutPolicy, this.queryBody, this.sql, this.md5, this.zoneId, this.username, this.state, this.lastExecutionTime);
        }
    }
}

