/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node.heartbeat;

import java.util.LinkedList;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.node.heartbeat.BaseNodeCache;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeStatistics;

public class ConfigNodeHeartbeatCache
extends BaseNodeCache {
    public static final int CURRENT_NODE_ID = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId();
    public static final NodeStatistics CURRENT_NODE_STATISTICS = new NodeStatistics(0L, NodeStatus.Running, null);
    private final int configNodeId;

    public ConfigNodeHeartbeatCache(int configNodeId) {
        this.configNodeId = configNodeId;
    }

    public ConfigNodeHeartbeatCache(int configNodeId, NodeStatistics statistics) {
        this.configNodeId = configNodeId;
        this.previousStatistics = statistics;
        this.currentStatistics = statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateCurrentStatistics() {
        if (this.configNodeId == CURRENT_NODE_ID) {
            return;
        }
        long lastSendTime = 0L;
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (!this.slidingWindow.isEmpty()) {
                lastSendTime = ((NodeHeartbeatSample)this.slidingWindow.getLast()).getSendTimestamp();
            }
        }
        NodeStatus status = System.currentTimeMillis() - lastSendTime > 20000L ? NodeStatus.Unknown : NodeStatus.Running;
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        NodeStatistics newStatistics = new NodeStatistics(loadScore, status, null);
        if (!this.currentStatistics.equals(newStatistics)) {
            this.currentStatistics = newStatistics;
        }
    }
}

