/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.RegionRoleType;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncConfigNodeHeartbeatClientPool;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeHeartbeatClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.client.async.handlers.heartbeat.ConfigNodeHeartbeatHandler;
import org.apache.iotdb.confignode.client.async.handlers.heartbeat.DataNodeHeartbeatHandler;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.response.ConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeToStatusResp;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.TriggerManager;
import org.apache.iotdb.confignode.manager.UDFManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.ClusterNodeStartUtils;
import org.apache.iotdb.confignode.manager.node.heartbeat.BaseNodeCache;
import org.apache.iotdb.confignode.manager.node.heartbeat.ConfigNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.node.heartbeat.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.procedure.env.DataNodeRemoveHandler;
import org.apache.iotdb.confignode.rpc.thrift.TCQConfig;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.confignode.rpc.thrift.TRatisConfig;
import org.apache.iotdb.confignode.rpc.thrift.TRuntimeConfiguration;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    public static final long HEARTBEAT_INTERVAL = CONF.getHeartbeatIntervalInMs();
    private static final long UNKNOWN_DATANODE_DETECT_INTERVAL = CONF.getUnknownDataNodeDetectInterval();
    private final IManager configManager;
    private final NodeInfo nodeInfo;
    private final ReentrantLock removeConfigNodeLock;
    private final Object scheduleMonitor = new Object();
    private final Map<Integer, BaseNodeCache> nodeCacheMap;
    private final AtomicInteger heartbeatCounter = new AtomicInteger(0);
    private Future<?> currentHeartbeatFuture;
    private final ScheduledExecutorService heartBeatExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Cluster-Heartbeat-Service");
    private Future<?> currentUnknownDataNodeDetectFuture;
    private final ScheduledExecutorService unknownDataNodeDetectExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Unknown-DataNode-Detector");
    private final Set<TDataNodeLocation> oldUnknownNodes;
    private final Random random;

    public NodeManager(IManager configManager, NodeInfo nodeInfo) {
        this.configManager = configManager;
        this.nodeInfo = nodeInfo;
        this.removeConfigNodeLock = new ReentrantLock();
        this.nodeCacheMap = new ConcurrentHashMap<Integer, BaseNodeCache>();
        this.oldUnknownNodes = new HashSet<TDataNodeLocation>();
        this.random = new Random(System.currentTimeMillis());
    }

    public DataSet getSystemConfiguration() {
        ConfigurationResp dataSet = new ConfigurationResp();
        dataSet.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        this.setGlobalConfig(dataSet);
        this.setRatisConfig(dataSet);
        this.setCQConfig(dataSet);
        return dataSet;
    }

    private void setGlobalConfig(ConfigurationResp dataSet) {
        ConfigNodeConfig configNodeConfig = ConfigNodeDescriptor.getInstance().getConf();
        CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
        TGlobalConfig globalConfig = new TGlobalConfig();
        globalConfig.setDataRegionConsensusProtocolClass(configNodeConfig.getDataRegionConsensusProtocolClass());
        globalConfig.setSchemaRegionConsensusProtocolClass(configNodeConfig.getSchemaRegionConsensusProtocolClass());
        globalConfig.setSeriesPartitionSlotNum(configNodeConfig.getSeriesSlotNum());
        globalConfig.setSeriesPartitionExecutorClass(configNodeConfig.getSeriesPartitionExecutorClass());
        globalConfig.setTimePartitionInterval(configNodeConfig.getTimePartitionInterval());
        globalConfig.setReadConsistencyLevel(configNodeConfig.getReadConsistencyLevel());
        globalConfig.setDiskSpaceWarningThreshold(commonConfig.getDiskSpaceWarningThreshold());
        dataSet.setGlobalConfig(globalConfig);
    }

    private void setRatisConfig(ConfigurationResp dataSet) {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        TRatisConfig ratisConfig = new TRatisConfig();
        ratisConfig.setDataAppenderBufferSize(conf.getDataRegionRatisConsensusLogAppenderBufferSize());
        ratisConfig.setSchemaAppenderBufferSize(conf.getSchemaRegionRatisConsensusLogAppenderBufferSize());
        ratisConfig.setDataSnapshotTriggerThreshold(conf.getDataRegionRatisSnapshotTriggerThreshold());
        ratisConfig.setSchemaSnapshotTriggerThreshold(conf.getSchemaRegionRatisSnapshotTriggerThreshold());
        ratisConfig.setDataLogUnsafeFlushEnable(conf.isDataRegionRatisLogUnsafeFlushEnable());
        ratisConfig.setSchemaLogUnsafeFlushEnable(conf.isSchemaRegionRatisLogUnsafeFlushEnable());
        ratisConfig.setDataLogSegmentSizeMax(conf.getDataRegionRatisLogSegmentSizeMax());
        ratisConfig.setSchemaLogSegmentSizeMax(conf.getSchemaRegionRatisLogSegmentSizeMax());
        ratisConfig.setDataGrpcFlowControlWindow(conf.getDataRegionRatisGrpcFlowControlWindow());
        ratisConfig.setSchemaGrpcFlowControlWindow(conf.getSchemaRegionRatisGrpcFlowControlWindow());
        ratisConfig.setDataLeaderElectionTimeoutMin(conf.getDataRegionRatisRpcLeaderElectionTimeoutMinMs());
        ratisConfig.setSchemaLeaderElectionTimeoutMin(conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs());
        ratisConfig.setDataLeaderElectionTimeoutMax(conf.getDataRegionRatisRpcLeaderElectionTimeoutMaxMs());
        ratisConfig.setSchemaLeaderElectionTimeoutMax(conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs());
        ratisConfig.setDataRequestTimeout(conf.getDataRegionRatisRequestTimeoutMs());
        ratisConfig.setSchemaRequestTimeout(conf.getSchemaRegionRatisRequestTimeoutMs());
        ratisConfig.setDataMaxRetryAttempts(conf.getDataRegionRatisMaxRetryAttempts());
        ratisConfig.setDataInitialSleepTime(conf.getDataRegionRatisInitialSleepTimeMs());
        ratisConfig.setDataMaxSleepTime(conf.getDataRegionRatisMaxSleepTimeMs());
        ratisConfig.setSchemaMaxRetryAttempts(conf.getSchemaRegionRatisMaxRetryAttempts());
        ratisConfig.setSchemaInitialSleepTime(conf.getSchemaRegionRatisInitialSleepTimeMs());
        ratisConfig.setSchemaMaxSleepTime(conf.getSchemaRegionRatisMaxSleepTimeMs());
        ratisConfig.setSchemaPreserveWhenPurge(conf.getSchemaRegionRatisPreserveLogsWhenPurge());
        ratisConfig.setDataPreserveWhenPurge(conf.getDataRegionRatisPreserveLogsWhenPurge());
        ratisConfig.setFirstElectionTimeoutMin(conf.getRatisFirstElectionTimeoutMinMs());
        ratisConfig.setFirstElectionTimeoutMax(conf.getRatisFirstElectionTimeoutMaxMs());
        ratisConfig.setSchemaRegionRatisLogMax(conf.getSchemaRegionRatisLogMax());
        ratisConfig.setDataRegionRatisLogMax(conf.getDataRegionRatisLogMax());
        dataSet.setRatisConfig(ratisConfig);
    }

    private void setCQConfig(ConfigurationResp dataSet) {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        TCQConfig cqConfig = new TCQConfig();
        cqConfig.setCqMinEveryIntervalInMs(conf.getCqMinEveryIntervalInMs());
        dataSet.setCqConfig(cqConfig);
    }

    private TRuntimeConfiguration getRuntimeConfiguration() {
        this.getTriggerManager().getTriggerInfo().acquireTriggerTableLock();
        this.getUDFManager().getUdfInfo().acquireUDFTableLock();
        try {
            TRuntimeConfiguration runtimeConfiguration = new TRuntimeConfiguration();
            runtimeConfiguration.setTemplateInfo(this.getClusterSchemaManager().getAllTemplateSetInfo());
            runtimeConfiguration.setAllTriggerInformation(this.getTriggerManager().getTriggerTable(false).getAllTriggerInformation());
            runtimeConfiguration.setAllUDFInformation(this.getUDFManager().getUDFTable().getAllUDFInformation());
            runtimeConfiguration.setAllTTLInformation(DataNodeRegisterResp.convertAllTTLInformation(this.getClusterSchemaManager().getAllTTLInfo()));
            TRuntimeConfiguration tRuntimeConfiguration = runtimeConfiguration;
            return tRuntimeConfiguration;
        }
        finally {
            this.getTriggerManager().getTriggerInfo().releaseTriggerTableLock();
            this.getUDFManager().getUdfInfo().releaseUDFTableLock();
        }
    }

    public DataSet registerDataNode(RegisterDataNodePlan registerDataNodePlan) {
        DataNodeRegisterResp resp = new DataNodeRegisterResp();
        registerDataNodePlan.getDataNodeConfiguration().getLocation().setDataNodeId(this.nodeInfo.generateNextNodeId());
        this.getConsensusManager().write(registerDataNodePlan);
        this.getClusterSchemaManager().adjustMaxRegionGroupNum();
        resp.setStatus(ClusterNodeStartUtils.ACCEPT_NODE_REGISTRATION);
        resp.setConfigNodeList(this.getRegisteredConfigNodes());
        resp.setDataNodeId(registerDataNodePlan.getDataNodeConfiguration().getLocation().getDataNodeId());
        resp.setRuntimeConfiguration(this.getRuntimeConfiguration());
        return resp;
    }

    public TDataNodeRestartResp restartDataNode(TDataNodeLocation dataNodeLocation) {
        TDataNodeRestartResp resp = new TDataNodeRestartResp();
        resp.setStatus(ClusterNodeStartUtils.ACCEPT_NODE_RESTART);
        resp.setConfigNodeList(this.getRegisteredConfigNodes());
        resp.setRuntimeConfiguration(this.getRuntimeConfiguration());
        return resp;
    }

    public DataSet removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status;
        LOGGER.info("NodeManager start to remove DataNode {}", (Object)removeDataNodePlan);
        DataNodeRemoveHandler dataNodeRemoveHandler = new DataNodeRemoveHandler((ConfigManager)this.configManager);
        DataNodeToStatusResp preCheckStatus = dataNodeRemoveHandler.checkRemoveDataNodeRequest(removeDataNodePlan);
        if (preCheckStatus.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.error("The remove DataNode request check failed. req: {}, check result: {}", (Object)removeDataNodePlan, (Object)preCheckStatus.getStatus());
            return preCheckStatus;
        }
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        if (this.configManager.transfer(removeDataNodePlan.getDataNodeLocations()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            dataSet.setStatus(new TSStatus(TSStatusCode.REMOVE_DATANODE_ERROR.getStatusCode()).setMessage("Fail to do transfer of the DataNodes"));
            return dataSet;
        }
        boolean registerSucceed = this.configManager.getProcedureManager().removeDataNode(removeDataNodePlan);
        if (registerSucceed) {
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setMessage("Server accepted the request");
        } else {
            status = new TSStatus(TSStatusCode.REMOVE_DATANODE_ERROR.getStatusCode());
            status.setMessage("Server rejected the request, maybe requests are too many");
        }
        dataSet.setStatus(status);
        LOGGER.info("NodeManager submit RemoveDataNodePlan finished, removeDataNodePlan: {}", (Object)removeDataNodePlan);
        return dataSet;
    }

    public DataSet updateDataNode(UpdateDataNodePlan updateDataNodePlan) {
        TSStatus status;
        LOGGER.info("NodeManager start to update DataNode {}", (Object)updateDataNodePlan);
        DataNodeRegisterResp dataSet = new DataNodeRegisterResp();
        boolean found = false;
        List<TDataNodeConfiguration> configurationList = this.getRegisteredDataNodes();
        for (TDataNodeConfiguration configuration : configurationList) {
            if (configuration.getLocation().getDataNodeId() != updateDataNodePlan.getDataNodeLocation().getDataNodeId()) continue;
            found = true;
            break;
        }
        if (found) {
            this.getConsensusManager().write(updateDataNodePlan);
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("updateDataNode(nodeId=%d) success.");
        } else {
            status = new TSStatus(TSStatusCode.DATANODE_NOT_EXIST.getStatusCode()).setMessage(String.format("The specified DataNode(nodeId=%d) doesn't exist", updateDataNodePlan.getDataNodeLocation().getDataNodeId()));
        }
        dataSet.setStatus(status);
        dataSet.setDataNodeId(updateDataNodePlan.getDataNodeLocation().getDataNodeId());
        dataSet.setConfigNodeList(this.getRegisteredConfigNodes());
        return dataSet;
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        int nodeId = this.nodeInfo.generateNextNodeId();
        req.getConfigNodeLocation().setConfigNodeId(nodeId);
        this.configManager.getProcedureManager().addConfigNode(req);
        return new TConfigNodeRegisterResp().setStatus(ClusterNodeStartUtils.ACCEPT_NODE_REGISTRATION).setConfigNodeId(nodeId);
    }

    public TSStatus restartConfigNode(TConfigNodeLocation configNodeLocation) {
        return ClusterNodeStartUtils.ACCEPT_NODE_RESTART;
    }

    public DataNodeConfigurationResp getDataNodeConfiguration(GetDataNodeConfigurationPlan req) {
        return (DataNodeConfigurationResp)this.getConsensusManager().read(req).getDataset();
    }

    public int getRegisteredDataNodeCount() {
        return this.nodeInfo.getRegisteredDataNodeCount();
    }

    public int getTotalCpuCoreCount() {
        return this.nodeInfo.getTotalCpuCoreCount();
    }

    public List<TDataNodeConfiguration> getRegisteredDataNodes() {
        return this.nodeInfo.getRegisteredDataNodes();
    }

    public TDataNodeConfiguration getRegisteredDataNode(int dataNodeId) {
        return this.nodeInfo.getRegisteredDataNode(dataNodeId);
    }

    public Map<Integer, TDataNodeLocation> getRegisteredDataNodeLocations() {
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocations = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        this.nodeInfo.getRegisteredDataNodes().forEach(dataNodeConfiguration -> dataNodeLocations.put(dataNodeConfiguration.getLocation().getDataNodeId(), dataNodeConfiguration.getLocation()));
        return dataNodeLocations;
    }

    public List<TDataNodeInfo> getRegisteredDataNodeInfoList() {
        ArrayList<TDataNodeInfo> dataNodeInfoList = new ArrayList<TDataNodeInfo>();
        List<TDataNodeConfiguration> registeredDataNodes = this.getRegisteredDataNodes();
        if (registeredDataNodes != null) {
            registeredDataNodes.forEach(registeredDataNode -> {
                TDataNodeInfo dataNodeInfo = new TDataNodeInfo();
                int dataNodeId = registeredDataNode.getLocation().getDataNodeId();
                dataNodeInfo.setDataNodeId(dataNodeId);
                dataNodeInfo.setStatus(this.getNodeStatusWithReason(dataNodeId));
                dataNodeInfo.setRpcAddresss(registeredDataNode.getLocation().getClientRpcEndPoint().getIp());
                dataNodeInfo.setRpcPort(registeredDataNode.getLocation().getClientRpcEndPoint().getPort());
                dataNodeInfo.setDataRegionNum(0);
                dataNodeInfo.setSchemaRegionNum(0);
                dataNodeInfo.setCpuCoreNum(registeredDataNode.getResource().getCpuCoreNum());
                dataNodeInfoList.add(dataNodeInfo);
            });
        }
        HashMap dataRegionNumMap = new HashMap();
        HashMap schemaRegionNumMap = new HashMap();
        List<TRegionReplicaSet> regionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        regionReplicaSets.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> {
            switch (regionReplicaSet.getRegionId().getType()) {
                case SchemaRegion: {
                    schemaRegionNumMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), key -> new AtomicInteger()).getAndIncrement();
                    break;
                }
                default: {
                    dataRegionNumMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), key -> new AtomicInteger()).getAndIncrement();
                }
            }
        }));
        AtomicInteger zero = new AtomicInteger(0);
        dataNodeInfoList.forEach(dataNodesInfo -> {
            dataNodesInfo.setSchemaRegionNum(schemaRegionNumMap.getOrDefault(dataNodesInfo.getDataNodeId(), zero).get());
            dataNodesInfo.setDataRegionNum(dataRegionNumMap.getOrDefault(dataNodesInfo.getDataNodeId(), zero).get());
        });
        dataNodeInfoList.sort(Comparator.comparingInt(TDataNodeInfo::getDataNodeId));
        return dataNodeInfoList;
    }

    public List<TConfigNodeLocation> getRegisteredConfigNodes() {
        return this.nodeInfo.getRegisteredConfigNodes();
    }

    public List<TConfigNodeInfo> getRegisteredConfigNodeInfoList() {
        ArrayList<TConfigNodeInfo> configNodeInfoList = new ArrayList<TConfigNodeInfo>();
        List<TConfigNodeLocation> registeredConfigNodes = this.getRegisteredConfigNodes();
        if (registeredConfigNodes != null) {
            registeredConfigNodes.forEach(configNodeLocation -> {
                TConfigNodeInfo info = new TConfigNodeInfo();
                int configNodeId = configNodeLocation.getConfigNodeId();
                info.setConfigNodeId(configNodeId);
                info.setStatus(this.getNodeStatusWithReason(configNodeId));
                info.setInternalAddress(configNodeLocation.getInternalEndPoint().getIp());
                info.setInternalPort(configNodeLocation.getInternalEndPoint().getPort());
                info.setRoleType(configNodeLocation.getConfigNodeId() == ConfigNodeHeartbeatCache.CURRENT_NODE_ID ? RegionRoleType.Leader.name() : RegionRoleType.Follower.name());
                configNodeInfoList.add(info);
            });
        }
        configNodeInfoList.sort(Comparator.comparingInt(TConfigNodeInfo::getConfigNodeId));
        return configNodeInfoList;
    }

    public void applyConfigNode(TConfigNodeLocation configNodeLocation) {
        ApplyConfigNodePlan applyConfigNodePlan = new ApplyConfigNodePlan(configNodeLocation);
        this.getConsensusManager().write(applyConfigNodePlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus checkConfigNodeBeforeRemove(RemoveConfigNodePlan removeConfigNodePlan) {
        this.removeConfigNodeLock.lock();
        try {
            if (this.filterConfigNodeThroughStatus(NodeStatus.Running).size() <= 1) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because there is only one ConfigNode in current Cluster.");
                return tSStatus;
            }
            if (!this.getRegisteredConfigNodes().contains(removeConfigNodePlan.getConfigNodeLocation())) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because the ConfigNode not in current Cluster.");
                return tSStatus;
            }
            TConfigNodeLocation leader = this.getConsensusManager().getLeader();
            if (leader == null) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because the ConfigNodeGroup is on leader election, please retry.");
                return tSStatus;
            }
            if (leader.getInternalEndPoint().equals(removeConfigNodePlan.getConfigNodeLocation().getInternalEndPoint())) {
                TSStatus tSStatus = this.transferLeader(removeConfigNodePlan, this.getConsensusManager().getConsensusGroupId());
                return tSStatus;
            }
        }
        finally {
            this.removeConfigNodeLock.unlock();
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Successfully remove confignode.");
    }

    private TSStatus transferLeader(RemoveConfigNodePlan removeConfigNodePlan, ConsensusGroupId groupId) {
        TConfigNodeLocation newLeader = this.filterConfigNodeThroughStatus(NodeStatus.Running).stream().filter(e -> !e.equals(removeConfigNodePlan.getConfigNodeLocation())).findAny().get();
        ConsensusGenericResponse resp = this.getConsensusManager().getConsensusImpl().transferLeader(groupId, new Peer(groupId, newLeader.getConfigNodeId(), newLeader.getConsensusEndPoint()));
        if (!resp.isSuccess()) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because transfer ConfigNode leader failed.");
        }
        return new TSStatus(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()).setRedirectNode(newLeader.getInternalEndPoint()).setMessage("The ConfigNode to be removed is leader, already transfer Leader to " + newLeader + ".");
    }

    public List<TSStatus> merge() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.MERGE, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> flush(TFlushReq req) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.FLUSH, req, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> clearCache() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.CLEAR_CACHE, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> loadConfiguration() {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.LOAD_CONFIGURATION, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> setSystemStatus(String status) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.SET_SYSTEM_STATUS, status, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq setDataNodeStatusReq) {
        return SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(setDataNodeStatusReq.getTargetDataNode().getInternalEndPoint(), setDataNodeStatusReq.getStatus(), DataNodeRequestType.SET_SYSTEM_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHeartbeatService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentHeartbeatFuture == null) {
                this.currentHeartbeatFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.heartBeatExecutor, this::heartbeatLoopBody, (long)0L, (long)HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("Heartbeat service is started successfully.");
            }
        }
    }

    private void heartbeatLoopBody() {
        Optional.ofNullable(this.getConsensusManager()).ifPresent(consensusManager -> {
            if (this.getConsensusManager().isLeader()) {
                THeartbeatReq heartbeatReq = this.genHeartbeatReq();
                this.pingRegisteredDataNodes(heartbeatReq, this.getRegisteredDataNodes());
                this.pingRegisteredConfigNodes(heartbeatReq, this.getRegisteredConfigNodes());
            }
        });
    }

    private THeartbeatReq genHeartbeatReq() {
        THeartbeatReq heartbeatReq = new THeartbeatReq();
        heartbeatReq.setHeartbeatTimestamp(System.currentTimeMillis());
        heartbeatReq.setNeedJudgeLeader(true);
        heartbeatReq.setNeedSamplingLoad(this.heartbeatCounter.get() % 10 == 0);
        this.heartbeatCounter.getAndUpdate(x -> (x + 1) % 10);
        return heartbeatReq;
    }

    private void pingRegisteredDataNodes(THeartbeatReq heartbeatReq, List<TDataNodeConfiguration> registeredDataNodes) {
        for (TDataNodeConfiguration dataNodeInfo : registeredDataNodes) {
            DataNodeHeartbeatHandler handler = new DataNodeHeartbeatHandler(dataNodeInfo.getLocation(), (DataNodeHeartbeatCache)this.nodeCacheMap.computeIfAbsent(dataNodeInfo.getLocation().getDataNodeId(), empty -> new DataNodeHeartbeatCache()), this.getPartitionManager().getRegionGroupCacheMap(), this.getLoadManager().getRouteBalancer());
            AsyncDataNodeHeartbeatClientPool.getInstance().getDataNodeHeartBeat(dataNodeInfo.getLocation().getInternalEndPoint(), heartbeatReq, handler);
        }
    }

    private void pingRegisteredConfigNodes(THeartbeatReq heartbeatReq, List<TConfigNodeLocation> registeredConfigNodes) {
        for (TConfigNodeLocation configNodeLocation : registeredConfigNodes) {
            if (configNodeLocation.getConfigNodeId() == ConfigNodeHeartbeatCache.CURRENT_NODE_ID) continue;
            ConfigNodeHeartbeatHandler handler = new ConfigNodeHeartbeatHandler((ConfigNodeHeartbeatCache)this.nodeCacheMap.computeIfAbsent(configNodeLocation.getConfigNodeId(), empty -> new ConfigNodeHeartbeatCache(configNodeLocation.getConfigNodeId())));
            AsyncConfigNodeHeartbeatClientPool.getInstance().getConfigNodeHeartBeat(configNodeLocation.getInternalEndPoint(), heartbeatReq.getHeartbeatTimestamp(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHeartbeatService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentHeartbeatFuture != null) {
                this.currentHeartbeatFuture.cancel(false);
                this.currentHeartbeatFuture = null;
                this.nodeCacheMap.clear();
                LOGGER.info("Heartbeat service is stopped successfully.");
            }
        }
    }

    public Map<Integer, BaseNodeCache> getNodeCacheMap() {
        return this.nodeCacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUnknownDataNodeDetector() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentUnknownDataNodeDetectFuture == null) {
                this.currentUnknownDataNodeDetectFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.unknownDataNodeDetectExecutor, this::detectTask, (long)0L, (long)UNKNOWN_DATANODE_DETECT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("Unknown-DataNode-Detector is started successfully.");
            }
        }
    }

    private void detectTask() {
        TSStatus transferResult;
        ArrayList<TDataNodeLocation> newUnknownNodes = new ArrayList<TDataNodeLocation>();
        this.getRegisteredDataNodes().forEach(DataNodeConfiguration -> {
            TDataNodeLocation dataNodeLocation = DataNodeConfiguration.getLocation();
            BaseNodeCache newestNodeInformation = this.nodeCacheMap.get(dataNodeLocation.dataNodeId);
            if (newestNodeInformation != null) {
                if (newestNodeInformation.getNodeStatus() == NodeStatus.Running) {
                    this.oldUnknownNodes.remove(dataNodeLocation);
                } else if (!this.oldUnknownNodes.contains(dataNodeLocation) && newestNodeInformation.getNodeStatus() == NodeStatus.Unknown) {
                    newUnknownNodes.add(dataNodeLocation);
                }
            }
        });
        if (!newUnknownNodes.isEmpty() && (transferResult = this.configManager.transfer(newUnknownNodes)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.oldUnknownNodes.addAll(newUnknownNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUnknownDataNodeDetector() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentUnknownDataNodeDetectFuture != null) {
                this.currentUnknownDataNodeDetectFuture.cancel(false);
                this.currentUnknownDataNodeDetectFuture = null;
                LOGGER.info("Unknown-DataNode-Detector is stopped successfully.");
            }
        }
    }

    public void removeNodeCache(int nodeId) {
        this.nodeCacheMap.remove(nodeId);
    }

    private String getNodeStatusWithReason(int nodeId) {
        BaseNodeCache nodeCache = this.nodeCacheMap.get(nodeId);
        return nodeCache == null ? NodeStatus.Unknown.getStatus() + "(NoHeartbeat)" : nodeCache.getNodeStatusWithReason();
    }

    public List<TConfigNodeLocation> filterConfigNodeThroughStatus(NodeStatus ... status) {
        return this.getRegisteredConfigNodes().stream().filter(registeredConfigNode -> {
            int configNodeId = registeredConfigNode.getConfigNodeId();
            return this.nodeCacheMap.containsKey(configNodeId) && Arrays.stream(status).anyMatch(s -> s.equals((Object)this.nodeCacheMap.get(configNodeId).getNodeStatus()));
        }).collect(Collectors.toList());
    }

    public NodeStatus getNodeStatusByNodeId(int nodeId) {
        BaseNodeCache baseNodeCache = this.nodeCacheMap.get(nodeId);
        return baseNodeCache == null ? null : baseNodeCache.getNodeStatus();
    }

    public List<TDataNodeConfiguration> filterDataNodeThroughStatus(NodeStatus ... status) {
        return this.getRegisteredDataNodes().stream().filter(registeredDataNode -> {
            int dataNodeId = registeredDataNode.getLocation().getDataNodeId();
            return this.nodeCacheMap.containsKey(dataNodeId) && Arrays.stream(status).anyMatch(s -> s.equals((Object)this.nodeCacheMap.get(dataNodeId).getNodeStatus()));
        }).collect(Collectors.toList());
    }

    public Map<Integer, Long> getAllLoadScores() {
        ConcurrentHashMap<Integer, Long> result = new ConcurrentHashMap<Integer, Long>();
        this.nodeCacheMap.forEach((dataNodeId, heartbeatCache) -> result.put((Integer)dataNodeId, heartbeatCache.getLoadScore()));
        return result;
    }

    public long getFreeDiskSpace(int dataNodeId) {
        DataNodeHeartbeatCache dataNodeHeartbeatCache = (DataNodeHeartbeatCache)this.nodeCacheMap.get(dataNodeId);
        return dataNodeHeartbeatCache == null ? 0L : dataNodeHeartbeatCache.getFreeDiskSpace();
    }

    public Optional<TDataNodeLocation> getLowestLoadDataNode() {
        List<TDataNodeConfiguration> targetDataNodeList = this.filterDataNodeThroughStatus(NodeStatus.Running);
        if (targetDataNodeList == null || targetDataNodeList.isEmpty()) {
            return Optional.empty();
        }
        int index = this.random.nextInt(targetDataNodeList.size());
        return Optional.of(targetDataNodeList.get((int)index).location);
    }

    public TDataNodeLocation getLowestLoadDataNode(Set<Integer> nodes) {
        AtomicInteger result = new AtomicInteger();
        AtomicLong lowestLoadScore = new AtomicLong(Long.MAX_VALUE);
        nodes.forEach(nodeID -> {
            long score;
            BaseNodeCache cache = this.nodeCacheMap.get(nodeID);
            long l = score = cache == null ? Long.MAX_VALUE : cache.getLoadScore();
            if (score < lowestLoadScore.get()) {
                result.set((int)nodeID);
                lowestLoadScore.set(score);
            }
        });
        LOGGER.info("get the lowest load DataNode, NodeID: [{}], LoadScore: [{}]", (Object)result, (Object)lowestLoadScore);
        return this.configManager.getNodeManager().getRegisteredDataNodeLocations().get(result.get());
    }

    public void initNodeHeartbeatCache() {
        int CURRENT_NODE_ID = ConfigNodeHeartbeatCache.CURRENT_NODE_ID;
        this.nodeCacheMap.clear();
        this.getRegisteredConfigNodes().forEach(configNodeLocation -> {
            if (configNodeLocation.getConfigNodeId() != CURRENT_NODE_ID) {
                this.nodeCacheMap.put(configNodeLocation.getConfigNodeId(), new ConfigNodeHeartbeatCache(configNodeLocation.getConfigNodeId()));
            }
        });
        this.nodeCacheMap.put(ConfigNodeHeartbeatCache.CURRENT_NODE_ID, new ConfigNodeHeartbeatCache(CURRENT_NODE_ID, ConfigNodeHeartbeatCache.CURRENT_NODE_STATISTICS));
        this.getRegisteredDataNodes().forEach(dataNodeConfiguration -> this.nodeCacheMap.put(dataNodeConfiguration.getLocation().getDataNodeId(), new DataNodeHeartbeatCache()));
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    private TriggerManager getTriggerManager() {
        return this.configManager.getTriggerManager();
    }

    private UDFManager getUDFManager() {
        return this.configManager.getUDFManager();
    }
}

