/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManagerMetrics;
import org.apache.iotdb.confignode.manager.load.balancer.PartitionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.RegionRouteMap;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeStatistics;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionStatistics;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final long HEARTBEAT_INTERVAL = CONF.getHeartbeatIntervalInMs();
    private final IManager configManager;
    private final RegionBalancer regionBalancer;
    private final PartitionBalancer partitionBalancer;
    private final RouteBalancer routeBalancer;
    private Future<?> currentLoadStatisticsFuture;
    private final ScheduledExecutorService loadStatisticsExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Cluster-LoadStatistics-Service");
    private final Object scheduleMonitor = new Object();

    public LoadManager(IManager configManager) {
        this.configManager = configManager;
        this.regionBalancer = new RegionBalancer(configManager);
        this.partitionBalancer = new PartitionBalancer(configManager);
        this.routeBalancer = new RouteBalancer(configManager);
        MetricService.getInstance().addMetricSet((IMetricSet)new LoadManagerMetrics(configManager));
    }

    public CreateRegionGroupsPlan allocateRegionGroups(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, StorageGroupNotExistsException {
        return this.regionBalancer.genRegionGroupsAllocationPlan(allotmentMap, consensusGroupType);
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NoAvailableRegionGroupException {
        return this.partitionBalancer.allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
    }

    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap) throws NoAvailableRegionGroupException {
        return this.partitionBalancer.allocateDataPartition(unassignedDataPartitionSlotsMap);
    }

    public Map<TConsensusGroupId, Integer> getLatestRegionLeaderMap() {
        return this.routeBalancer.getLatestRegionLeaderMap();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getLatestRegionRouteMap() {
        return this.routeBalancer.getLatestRegionPriorityMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoadStatisticsService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentLoadStatisticsFuture == null) {
                this.currentLoadStatisticsFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.loadStatisticsExecutor, this::updateLoadStatistics, (long)0L, (long)HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("LoadStatistics service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoadStatisticsService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentLoadStatisticsFuture != null) {
                this.currentLoadStatisticsFuture.cancel(false);
                this.currentLoadStatisticsFuture = null;
                LOGGER.info("LoadStatistics service is stopped successfully.");
            }
        }
    }

    private void updateLoadStatistics() {
        boolean isNeedBroadcast = false;
        ConcurrentHashMap<Integer, NodeStatistics> differentNodeStatisticsMap = new ConcurrentHashMap<Integer, NodeStatistics>();
        this.getNodeManager().getNodeCacheMap().forEach((nodeId, nodeCache) -> {
            if (nodeCache.periodicUpdate()) {
                differentNodeStatisticsMap.put((Integer)nodeId, nodeCache.getStatistics());
            }
        });
        if (!differentNodeStatisticsMap.isEmpty()) {
            isNeedBroadcast = true;
            this.recordNodeStatistics(differentNodeStatisticsMap);
        }
        ConcurrentHashMap<TConsensusGroupId, RegionGroupStatistics> differentRegionGroupStatisticsMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroupStatistics>();
        this.getPartitionManager().getRegionGroupCacheMap().forEach((regionGroupId, regionGroupCache) -> {
            if (regionGroupCache.periodicUpdate()) {
                differentRegionGroupStatisticsMap.put((TConsensusGroupId)regionGroupId, regionGroupCache.getStatistics());
            }
        });
        if (!differentRegionGroupStatisticsMap.isEmpty()) {
            isNeedBroadcast = true;
            this.recordRegionGroupStatistics(differentRegionGroupStatisticsMap);
        }
        if (this.routeBalancer.updateRegionRouteMap()) {
            isNeedBroadcast = true;
            this.recordRegionRouteMap(this.routeBalancer.getRegionRouteMap());
        }
        if (isNeedBroadcast) {
            this.broadcastLatestRegionRouteMap();
        }
    }

    private void recordNodeStatistics(Map<Integer, NodeStatistics> differentNodeStatisticsMap) {
        LOGGER.info("[UpdateLoadStatistics] NodeStatisticsMap: ");
        for (Map.Entry<Integer, NodeStatistics> nodeCacheEntry : differentNodeStatisticsMap.entrySet()) {
            LOGGER.info("[UpdateLoadStatistics]\t {}={}", (Object)("nodeId{" + nodeCacheEntry.getKey() + "}"), (Object)nodeCacheEntry.getValue());
        }
    }

    private void recordRegionGroupStatistics(Map<TConsensusGroupId, RegionGroupStatistics> differentRegionGroupStatisticsMap) {
        LOGGER.info("[UpdateLoadStatistics] RegionGroupStatisticsMap: ");
        for (Map.Entry<TConsensusGroupId, RegionGroupStatistics> regionGroupStatisticsEntry : differentRegionGroupStatisticsMap.entrySet()) {
            LOGGER.info("[UpdateLoadStatistics]\t RegionGroup: {}", (Object)regionGroupStatisticsEntry.getKey());
            LOGGER.info("[UpdateLoadStatistics]\t {}", (Object)regionGroupStatisticsEntry.getValue());
            for (Map.Entry<Integer, RegionStatistics> regionStatisticsEntry : regionGroupStatisticsEntry.getValue().getRegionStatisticsMap().entrySet()) {
                LOGGER.info("[UpdateLoadStatistics]\t dataNodeId{}={}", (Object)regionStatisticsEntry.getKey(), (Object)regionStatisticsEntry.getValue());
            }
        }
    }

    private void recordRegionRouteMap(RegionRouteMap regionRouteMap) {
        LOGGER.info("[UpdateLoadStatistics] RegionLeaderMap: ");
        for (Map.Entry<TConsensusGroupId, Integer> entry : regionRouteMap.getRegionLeaderMap().entrySet()) {
            LOGGER.info("[UpdateLoadStatistics]\t {}={}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        LOGGER.info("[UpdateLoadStatistics] RegionPriorityMap: ");
        for (Map.Entry<TConsensusGroupId, Integer> entry : regionRouteMap.getRegionPriorityMap().entrySet()) {
            LOGGER.info("[UpdateLoadStatistics]\t {}={}", (Object)entry.getKey(), ((TRegionReplicaSet)entry.getValue()).getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList()));
        }
    }

    public void broadcastLatestRegionRouteMap() {
        Map<TConsensusGroupId, TRegionReplicaSet> latestRegionRouteMap = this.getLatestRegionRouteMap();
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.Removing, NodeStatus.ReadOnly).forEach(onlineDataNode -> dataNodeLocationMap.put(onlineDataNode.getLocation().getDataNodeId(), onlineDataNode.getLocation()));
        LOGGER.info("[UpdateLoadStatistics] Begin to broadcast RegionRouteMap:");
        long broadcastTime = System.currentTimeMillis();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_REGION_ROUTE_MAP, new TRegionRouteReq(broadcastTime, latestRegionRouteMap), dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        LOGGER.info("[UpdateLoadStatistics] Broadcast the latest RegionRouteMap finished.");
    }

    public void initHeartbeatCache() {
        this.getNodeManager().initNodeHeartbeatCache();
        this.getPartitionManager().initRegionGroupHeartbeatCache();
        this.routeBalancer.initRegionRouteMap();
    }

    public RouteBalancer getRouteBalancer() {
        return this.routeBalancer;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

