/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.function.GetFunctionTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.udf.GetUDFJarPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.DropFunctionPlan;
import org.apache.iotdb.confignode.consensus.response.FunctionTableResp;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionInstanceReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFManager.class);
    private final ConfigManager configManager;
    private final UDFInfo udfInfo;
    private final long planSizeLimit = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeRatisConsensusLogAppenderBufferSize() - 48L;

    public UDFManager(ConfigManager configManager, UDFInfo udfInfo) {
        this.configManager = configManager;
        this.udfInfo = udfInfo;
    }

    public UDFInfo getUdfInfo() {
        return this.udfInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createFunction(TCreateFunctionReq req) {
        this.udfInfo.acquireUDFTableLock();
        try {
            boolean isUsingURI = req.isIsUsingURI();
            String udfName = req.udfName.toUpperCase();
            String jarMD5 = req.getJarMD5();
            String jarName = req.getJarName();
            byte[] jarFile = req.getJarFile();
            this.udfInfo.validate(udfName, jarName, jarMD5);
            UDFInformation udfInformation = new UDFInformation(udfName, req.getClassName(), false, isUsingURI, jarName, jarMD5);
            boolean needToSaveJar = isUsingURI && this.udfInfo.needToSaveJar(jarName);
            LOGGER.info("Start to create UDF [{}] on Data Nodes, needToSaveJar[{}]", (Object)udfName, (Object)needToSaveJar);
            TSStatus dataNodesStatus = RpcUtils.squashResponseStatusList(this.createFunctionOnDataNodes(udfInformation, (byte[])(needToSaveJar ? jarFile : null)));
            if (dataNodesStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = dataNodesStatus;
                return tSStatus;
            }
            CreateFunctionPlan createFunctionPlan = new CreateFunctionPlan(udfInformation, needToSaveJar ? new Binary(jarFile) : null);
            if (needToSaveJar && (long)createFunctionPlan.getSerializedSize() > this.planSizeLimit) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(String.format("Fail to create UDF[%s], the size of Jar is too large, you can increase the value of property 'config_node_ratis_log_appender_buffer_size_max' on ConfigNode", udfName));
                return tSStatus;
            }
            LOGGER.info("Start to add UDF [{}] in UDF_Table on Config Nodes", (Object)udfName);
            TSStatus tSStatus = this.configManager.getConsensusManager().write(createFunctionPlan).getStatus();
            return tSStatus;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage());
            return tSStatus;
        }
        finally {
            this.udfInfo.releaseUDFTableLock();
        }
    }

    private List<TSStatus> createFunctionOnDataNodes(UDFInformation udfInformation, byte[] jarFile) throws IOException {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TCreateFunctionInstanceReq req = new TCreateFunctionInstanceReq(udfInformation.serialize()).setJarFile(jarFile);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.CREATE_FUNCTION, req, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus dropFunction(String functionName) {
        functionName = functionName.toUpperCase();
        this.udfInfo.acquireUDFTableLock();
        try {
            this.udfInfo.validate(functionName);
            TSStatus result = RpcUtils.squashResponseStatusList(this.dropFunctionOnDataNodes(functionName));
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = result;
                return tSStatus;
            }
            TSStatus tSStatus = this.configManager.getConsensusManager().write(new DropFunctionPlan(functionName)).getStatus();
            return tSStatus;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage());
            return tSStatus;
        }
        finally {
            this.udfInfo.releaseUDFTableLock();
        }
    }

    private List<TSStatus> dropFunctionOnDataNodes(String functionName) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TDropFunctionInstanceReq request = new TDropFunctionInstanceReq(functionName, false);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.DROP_FUNCTION, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public TGetUDFTableResp getUDFTable() {
        try {
            return ((FunctionTableResp)this.configManager.getConsensusManager().read(new GetFunctionTablePlan()).getDataset()).convertToThriftResponse();
        }
        catch (IOException e) {
            LOGGER.error("Fail to get TriggerTable", (Throwable)e);
            return new TGetUDFTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TGetJarInListResp getUDFJar(TGetJarInListReq req) {
        try {
            return ((JarResp)this.configManager.getConsensusManager().read(new GetUDFJarPlan(req.getJarNameList())).getDataset()).convertToThriftResponse();
        }
        catch (IOException e) {
            LOGGER.error("Fail to get TriggerJar", (Throwable)e);
            return new TGetJarInListResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }
}

