/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.statemachine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.exception.physical.UnknownPhysicalPlanTypeException;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.executor.ConfigPlanExecutor;
import org.apache.iotdb.confignode.writelog.io.SingleFileLogReader;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.utils.writelog.LogWriter;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeRegionStateMachine
implements IStateMachine,
IStateMachine.EventApi,
IStateMachine.RetryPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeRegionStateMachine.class);
    private static final ExecutorService threadPool = IoTDBThreadPoolFactory.newCachedThreadPool((String)"CQ-recovery");
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigPlanExecutor executor;
    private ConfigManager configManager;
    private LogWriter logWriter;
    private File logFile;
    private int startIndex;
    private int endIndex;
    private static final String CURRENT_FILE_DIR = CONF.getConsensusDir() + File.separator + "simple" + File.separator + "current";
    private static final String PROGRESS_FILE_PATH = CURRENT_FILE_DIR + File.separator + "log_inprogress_";
    private static final String FILE_PATH = CURRENT_FILE_DIR + File.separator + "log_";
    private static final long LOG_FILE_MAX_SIZE = CONF.getConfigNodeSimpleConsensusLogSegmentSizeMax();
    private final TEndPoint currentNodeTEndPoint;

    public ConfigNodeRegionStateMachine(ConfigManager configManager, ConfigPlanExecutor executor) {
        this.executor = executor;
        this.configManager = configManager;
        this.currentNodeTEndPoint = new TEndPoint().setIp(ConfigNodeDescriptor.getInstance().getConf().getInternalAddress()).setPort(ConfigNodeDescriptor.getInstance().getConf().getConsensusPort());
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public TSStatus write(IConsensusRequest request) {
        ConfigPhysicalPlan plan;
        if (request instanceof ByteBufferConsensusRequest) {
            try {
                plan = ConfigPhysicalPlan.Factory.create(request.serializeToByteBuffer());
            }
            catch (Throwable e) {
                LOGGER.error("Deserialization error for write plan, request: {}, bytebuffer: {}", new Object[]{request, request.serializeToByteBuffer(), e});
                return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        } else if (request instanceof ConfigPhysicalPlan) {
            plan = (ConfigPhysicalPlan)request;
        } else {
            LOGGER.error("Unexpected write plan, request: {}, bytebuffer: {}", (Object)request, (Object)request.serializeToByteBuffer());
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return this.write(plan);
    }

    protected TSStatus write(ConfigPhysicalPlan plan) {
        TSStatus result;
        try {
            result = this.executor.executeNonQueryPlan(plan);
        }
        catch (AuthException | UnknownPhysicalPlanTypeException e) {
            LOGGER.error(e.getMessage());
            result = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        if ("org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getConfigNodeConsensusProtocolClass())) {
            this.writeLogForSimpleConsensus(plan);
        }
        return result;
    }

    public DataSet read(IConsensusRequest request) {
        ConfigPhysicalPlan plan;
        if (request instanceof ByteBufferConsensusRequest) {
            try {
                plan = ConfigPhysicalPlan.Factory.create(request.serializeToByteBuffer());
            }
            catch (Throwable e) {
                LOGGER.error("Deserialization error for write plan : {}", (Object)request);
                return null;
            }
        } else if (request instanceof ConfigPhysicalPlan) {
            plan = (ConfigPhysicalPlan)request;
        } else {
            LOGGER.error("Unexpected read plan : {}", (Object)request);
            return null;
        }
        return this.read(plan);
    }

    public boolean takeSnapshot(File snapshotDir) {
        return this.executor.takeSnapshot(snapshotDir);
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        this.executor.loadSnapshot(latestSnapshotRootDir);
    }

    protected DataSet read(ConfigPhysicalPlan plan) {
        DataSet result;
        try {
            result = this.executor.executeQueryPlan(plan);
        }
        catch (AuthException | UnknownPhysicalPlanTypeException e) {
            LOGGER.error(e.getMessage());
            result = null;
        }
        return result;
    }

    public void notifyLeaderChanged(ConsensusGroupId groupId, int newLeaderId) {
        int currentNodeId = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId();
        if (currentNodeId == newLeaderId) {
            LOGGER.info("Current node [nodeId: {}, ip:port: {}] becomes Leader", (Object)newLeaderId, (Object)this.currentNodeTEndPoint);
            this.configManager.getLoadManager().initHeartbeatCache();
            this.configManager.getProcedureManager().shiftExecutor(true);
            this.configManager.getLoadManager().startLoadStatisticsService();
            this.configManager.getLoadManager().getRouteBalancer().startRouteBalancingService();
            this.configManager.getNodeManager().startHeartbeatService();
            this.configManager.getNodeManager().startUnknownDataNodeDetector();
            this.configManager.getPartitionManager().startRegionCleaner();
            threadPool.submit(() -> this.configManager.getCQManager().startCQScheduler());
        } else {
            LOGGER.info("Current node [nodeId:{}, ip:port: {}] is not longer the leader, the new leader is [nodeId:{}]", new Object[]{currentNodeId, this.currentNodeTEndPoint, newLeaderId});
            this.configManager.getProcedureManager().shiftExecutor(false);
            this.configManager.getLoadManager().stopLoadStatisticsService();
            this.configManager.getLoadManager().getRouteBalancer().stopRouteBalancingService();
            this.configManager.getNodeManager().stopHeartbeatService();
            this.configManager.getNodeManager().stopUnknownDataNodeDetector();
            this.configManager.getPartitionManager().stopRegionCleaner();
            this.configManager.getCQManager().stopCQScheduler();
        }
    }

    public void start() {
        if ("org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getConfigNodeConsensusProtocolClass())) {
            this.initStandAloneConfigNode();
        }
    }

    public void stop() {
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly();
    }

    public boolean shouldRetry(TSStatus writeResult) {
        return super.shouldRetry(writeResult);
    }

    public TSStatus updateResult(TSStatus previousResult, TSStatus retryResult) {
        return super.updateResult(previousResult, retryResult);
    }

    public long getSleepTime() {
        return super.getSleepTime();
    }

    private synchronized void writeLogForSimpleConsensus(ConfigPhysicalPlan plan) {
        if (this.logFile.length() > LOG_FILE_MAX_SIZE) {
            try {
                this.logWriter.force();
                File completedFilePath = new File(FILE_PATH + this.startIndex + "_" + this.endIndex);
                Files.move(this.logFile.toPath(), completedFilePath.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                LOGGER.error("Can't force logWriter for ConfigNode SimpleConsensus mode", (Throwable)e);
            }
            for (int retry = 0; retry < 5; ++retry) {
                try {
                    this.logWriter.close();
                    break;
                }
                catch (IOException e) {
                    LOGGER.warn("Can't close StandAloneLog for ConfigNode SimpleConsensus mode, filePath: {}, retry: {}", (Object)this.logFile.getAbsolutePath(), (Object)retry);
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        LOGGER.warn("Unexpected interruption during the close method of logWriter");
                    }
                    continue;
                }
            }
            this.startIndex = this.endIndex + 1;
            this.createLogFile(this.startIndex);
        }
        try {
            ByteBuffer buffer = plan.serializeToByteBuffer();
            buffer.position(buffer.limit());
            this.logWriter.write(buffer);
            ++this.endIndex;
            File tmpLogFile = new File(PROGRESS_FILE_PATH + this.endIndex);
            Files.move(this.logFile.toPath(), tmpLogFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            this.logFile = tmpLogFile;
            this.logWriter = new LogWriter(this.logFile, false);
        }
        catch (Exception e) {
            LOGGER.error("Can't serialize current ConfigPhysicalPlan for ConfigNode SimpleConsensus mode", (Throwable)e);
        }
    }

    private void initStandAloneConfigNode() {
        File dir = new File(CURRENT_FILE_DIR);
        dir.mkdirs();
        String[] list = new File(CURRENT_FILE_DIR).list();
        if (list != null && list.length != 0) {
            for (String logFileName : list) {
                SingleFileLogReader logReader;
                int tmp = Integer.parseInt(logFileName.substring(logFileName.lastIndexOf("_") + 1));
                if (logFileName.startsWith("log_inprogress")) {
                    this.endIndex = tmp;
                } else if (this.startIndex < tmp) {
                    this.startIndex = tmp;
                }
                File logFile = SystemFileFactory.INSTANCE.getFile(CURRENT_FILE_DIR + File.separator + logFileName);
                try {
                    logReader = new SingleFileLogReader(logFile);
                }
                catch (FileNotFoundException e) {
                    LOGGER.error("InitStandAloneConfigNode meets error, can't find standalone log files, filePath: {}", (Object)logFile.getAbsolutePath(), (Object)e);
                    continue;
                }
                while (logReader.hasNext()) {
                    ConfigPhysicalPlan nextPlan = logReader.next();
                    try {
                        this.executor.executeNonQueryPlan(nextPlan);
                    }
                    catch (AuthException | UnknownPhysicalPlanTypeException e) {
                        LOGGER.error(e.getMessage());
                    }
                }
                logReader.close();
            }
        } else {
            this.startIndex = 0;
            this.endIndex = 0;
        }
        ++this.startIndex;
        this.createLogFile(this.endIndex);
    }

    private void createLogFile(int endIndex) {
        this.logFile = SystemFileFactory.INSTANCE.getFile(PROGRESS_FILE_PATH + endIndex);
        try {
            this.logFile.createNewFile();
            this.logWriter = new LogWriter(this.logFile, false);
            LOGGER.info("Create ConfigNode SimpleConsensusFile: {}", (Object)this.logFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.warn("Create ConfigNode SimpleConsensusFile failed, filePath: {}", (Object)this.logFile.getAbsolutePath(), (Object)e);
        }
    }
}

