/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.datanode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class UpdateDataNodePlan
extends ConfigPhysicalPlan {
    private TDataNodeLocation dataNodeLocation;

    public UpdateDataNodePlan() {
        super(ConfigPhysicalPlanType.UpdateDataNodeConfiguration);
    }

    public UpdateDataNodePlan(TDataNodeLocation datanodeLocation) {
        this();
        this.dataNodeLocation = datanodeLocation;
    }

    public TDataNodeLocation getDataNodeLocation() {
        return this.dataNodeLocation;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.dataNodeLocation, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.dataNodeLocation = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDataNodePlan that = (UpdateDataNodePlan)o;
        return this.dataNodeLocation.equals(that.dataNodeLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataNodeLocation);
    }
}

