/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFSubstr
implements UDTF {
    int start;
    int end;

    public void validate(UDFParameterValidator validator) throws Exception {
        int start = validator.getParameters().getInt("start");
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT).validate(startPosition -> (Integer)startPosition >= 0, "start should be more or equal than 0", (Object)start).validate(end -> (Integer)end >= start, "end should be more or equal than start", (Object)validator.getParameters().getIntOrDefault("end", Integer.MAX_VALUE));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.start = parameters.getInt("start");
        this.end = parameters.getIntOrDefault("end", Integer.MAX_VALUE);
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.TEXT);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        String series = row.getString(0);
        collector.putString(row.getTime(), this.end >= series.length() ? row.getString(0).substring(this.start) : row.getString(0).substring(this.start, this.end));
    }
}

