/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.tool.AbstractCsvTool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.thrift.TException;
import org.jline.reader.LineReader;

public class ExportCsv
extends AbstractCsvTool {
    private static final String TARGET_DIR_ARGS = "td";
    private static final String TARGET_DIR_NAME = "targetDirectory";
    private static final String TARGET_FILE_ARGS = "f";
    private static final String TARGET_FILE_NAME = "targetFile";
    private static final String SQL_FILE_ARGS = "s";
    private static final String SQL_FILE_NAME = "sqlfile";
    private static final String DATA_TYPE_ARGS = "datatype";
    private static final String DATA_TYPE_NAME = "datatype";
    private static final String QUERY_COMMAND_ARGS = "q";
    private static final String QUERY_COMMAND_NAME = "queryCommand";
    private static final String LINES_PER_FILE_ARGS = "linesPerFile";
    private static final String LINES_PER_FILE_ARGS_NAME = "Lines Per File";
    private static final String TSFILEDB_CLI_PREFIX = "ExportCsv";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static String targetFile = "dump";
    private static String targetDirectory;
    private static Boolean needDataTypePrinted;
    private static String queryCommand;
    private static String timestampPrecision;
    private static int linesPerFile;
    private static final int EXPORT_PER_LINE_COUNT = 10000;
    private static long timeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = ExportCsv.createOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        int exitCode = 0;
        try {
            ExportCsv.parseBasicParams(commandLine);
            ExportCsv.parseSpecialParams(commandLine);
            if (!ExportCsv.checkTimeFormat()) {
                System.exit(1);
            }
            session = new Session(host, Integer.parseInt(port), username, password);
            session.open(false);
            timestampPrecision = session.getTimestampPrecision();
            ExportCsv.setTimeZone();
            if (queryCommand == null) {
                String sqlFile = commandLine.getOptionValue(SQL_FILE_ARGS);
                if (sqlFile == null) {
                    LineReader lineReader = JlineUtils.getLineReader(username, host, port);
                    String sql = lineReader.readLine("ExportCsv> please input query: ");
                    System.out.println(sql);
                    String[] values = sql.trim().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        ExportCsv.dumpResult(values[i], i);
                    }
                } else {
                    ExportCsv.dumpFromSqlFile(sqlFile);
                }
            } else {
                ExportCsv.dumpResult(queryCommand, 0);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to operate on file, because " + e.getMessage());
            exitCode = 1;
        }
        catch (ArgsErrorException e) {
            System.out.println("Invalid args: " + e.getMessage());
            exitCode = 1;
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            System.out.println("Connect failed because " + e.getMessage());
            exitCode = 1;
        }
        catch (TException e) {
            System.out.println("Can not get the timestamp precision from server because " + e.getMessage());
            exitCode = 1;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    exitCode = 1;
                    System.out.println("Encounter an error when closing session, error is: " + e.getMessage());
                }
            }
        }
        System.exit(exitCode);
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportCsv.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_NAME, commandLine);
        targetFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
        needDataTypePrinted = Boolean.valueOf(commandLine.getOptionValue("datatype"));
        queryCommand = commandLine.getOptionValue(QUERY_COMMAND_ARGS);
        String timeoutString = commandLine.getOptionValue("t");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        if (needDataTypePrinted == null) {
            needDataTypePrinted = true;
        }
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if ((timeFormat = commandLine.getOptionValue("tf")) == null) {
            timeFormat = "default";
        }
        timeZoneID = commandLine.getOptionValue("tz");
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
        if (commandLine.getOptionValue(LINES_PER_FILE_ARGS) != null) {
            linesPerFile = Integer.parseInt(commandLine.getOptionValue(LINES_PER_FILE_ARGS));
        }
    }

    private static Options createOptions() {
        Options options = ExportCsv.createNewOptions();
        Option opTargetFile = Option.builder((String)TARGET_DIR_ARGS).required().argName(TARGET_DIR_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opTargetFile);
        Option targetFileName = Option.builder((String)TARGET_FILE_ARGS).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(targetFileName);
        Option opSqlFile = Option.builder((String)SQL_FILE_ARGS).argName(SQL_FILE_NAME).hasArg().desc("SQL File Path (optional)").build();
        options.addOption(opSqlFile);
        Option opTimeFormat = Option.builder((String)"tf").argName("timeformat").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd\\ HH:mm:ss, default ISO8601 (optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opDataType = Option.builder((String)"datatype").argName("datatype").hasArg().desc("Will the data type of timeseries be printed in the head line of the CSV file?\nYou can choose true) or false) . (optional)").build();
        options.addOption(opDataType);
        Option opQuery = Option.builder((String)QUERY_COMMAND_ARGS).argName(QUERY_COMMAND_NAME).hasArg().desc("The query command that you want to execute. (optional)").build();
        options.addOption(opQuery);
        Option opLinesPerFile = Option.builder((String)LINES_PER_FILE_ARGS).argName(LINES_PER_FILE_ARGS_NAME).hasArg().desc("Lines per dump file.").build();
        options.addOption(opLinesPerFile);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        Option opTimeout = Option.builder((String)"t").longOpt("timeout").hasArg().desc("Timeout for session query").build();
        options.addOption(opTimeout);
        return options;
    }

    private static void dumpFromSqlFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String sql;
            int index = 0;
            while ((sql = reader.readLine()) != null) {
                ExportCsv.dumpResult(sql, index);
                ++index;
            }
        }
    }

    private static void dumpResult(String sql, int index) {
        String path = targetDirectory + targetFile + index;
        try {
            SessionDataSet sessionDataSet = session.executeQueryStatement(sql, timeout);
            ArrayList<Object> headers = new ArrayList<Object>();
            List names = sessionDataSet.getColumnNames();
            List types = sessionDataSet.getColumnTypes();
            if (needDataTypePrinted.booleanValue()) {
                for (int i = 0; i < names.size(); ++i) {
                    if (!"Time".equals(names.get(i)) && !"Device".equals(names.get(i))) {
                        headers.add(String.format("%s(%s)", names.get(i), types.get(i)));
                        continue;
                    }
                    headers.add(names.get(i));
                }
            } else {
                headers.addAll(names);
            }
            ExportCsv.writeCsvFile(sessionDataSet, path, headers, linesPerFile);
            sessionDataSet.closeOperationHandle();
            System.out.println("Export completely!");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException e) {
            System.out.println("Cannot dump result because: " + e.getMessage());
        }
    }

    public static String timeTrans(Long time) {
        switch (timeFormat) {
            case "default": {
                return RpcUtils.parseLongToDateWithPrecision((DateTimeFormatter)DateTimeFormatter.ISO_OFFSET_DATE_TIME, (long)time, (ZoneId)zoneId, (String)timestampPrecision);
            }
            case "timestamp": 
            case "long": 
            case "number": {
                return String.valueOf(time);
            }
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), zoneId).format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static void writeCsvFile(SessionDataSet sessionDataSet, String filePath, List<Object> headers, int linesPerFile) throws IOException, IoTDBConnectionException, StatementExecutionException {
        int fileIndex = 0;
        boolean hasNext = true;
        while (hasNext) {
            int i = 0;
            String finalFilePath = filePath + "_" + fileIndex + ".csv";
            AbstractCsvTool.CSVPrinterWrapper csvPrinterWrapper = new AbstractCsvTool.CSVPrinterWrapper(finalFilePath);
            csvPrinterWrapper.printRecord(headers);
            while (i++ < linesPerFile) {
                if (sessionDataSet.hasNext()) {
                    RowRecord rowRecord = sessionDataSet.next();
                    if (rowRecord.getTimestamp() != 0L) {
                        csvPrinterWrapper.print(ExportCsv.timeTrans(rowRecord.getTimestamp()));
                    }
                    rowRecord.getFields().forEach(field -> {
                        String fieldStringValue = field.getStringValue();
                        if (!"null".equals(field.getStringValue())) {
                            if (field.getDataType() == TSDataType.TEXT && !fieldStringValue.startsWith("root.")) {
                                fieldStringValue = "\"" + fieldStringValue + "\"";
                            }
                            csvPrinterWrapper.print(fieldStringValue);
                        } else {
                            csvPrinterWrapper.print("");
                        }
                    });
                    csvPrinterWrapper.println();
                    continue;
                }
                hasNext = false;
                break;
            }
            ++fileIndex;
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
        }
    }

    static {
        linesPerFile = 10000;
        timeout = -1L;
    }
}

