/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.BitReader;
import org.jtransforms.dct.DoubleDCT_1D;

public class FreqDecoder
extends Decoder {
    private double[] data;
    private int readTotalCount = 0;
    private int nextReadIndex = 0;

    public FreqDecoder() {
        super(TSEncoding.FREQ);
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        if (this.nextReadIndex == this.readTotalCount) {
            this.loadBlock(buffer);
            this.nextReadIndex = 0;
        }
        return this.data[this.nextReadIndex++];
    }

    @Override
    public float readFloat(ByteBuffer buffer) {
        return (float)this.readDouble(buffer);
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        return (int)Math.round(this.readDouble(buffer));
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        return Math.round(this.readDouble(buffer));
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return this.nextReadIndex < this.readTotalCount || buffer.hasRemaining();
    }

    @Override
    public void reset() {
        this.nextReadIndex = 0;
        this.readTotalCount = 0;
    }

    private void loadBlock(ByteBuffer buffer) {
        BitReader reader = new BitReader(buffer);
        this.readTotalCount = (int)reader.next(16);
        int m = (int)reader.next(16);
        short beta = (short)reader.next(16);
        int[] index = this.decodeIndex(m, reader);
        long[] value = this.decodeValue(m, reader);
        reader.skip();
        double eps = Math.pow(2.0, beta);
        this.data = new double[this.readTotalCount];
        for (int i = 0; i < m; ++i) {
            this.data[index[i]] = (double)value[i] * eps;
        }
        DoubleDCT_1D dct = new DoubleDCT_1D((long)this.readTotalCount);
        dct.inverse(this.data, true);
    }

    private long[] decodeValue(int m, BitReader reader) {
        if (m == 0) {
            return new long[0];
        }
        int bits = (int)reader.next(8);
        long min = reader.next(bits);
        long[] value = new long[m];
        for (int i = 0; i < m; ++i) {
            int symbol = (int)reader.next(1);
            value[i] = reader.next(bits);
            bits = this.getValueWidth(value[i]);
            int n = i;
            value[n] = value[n] + min;
            if (symbol != 1) continue;
            value[i] = -value[i];
        }
        return value;
    }

    private int[] decodeIndex(int m, BitReader reader) {
        int[] value = new int[m];
        int bitsWidth = this.getValueWidth(this.getValueWidth(this.readTotalCount - 1));
        for (int i = 0; i < m; i += 8) {
            int bits = (int)reader.next(bitsWidth);
            for (int j = i; j < Math.min(i + 8, m); ++j) {
                value[j] = (int)reader.next(bits);
            }
        }
        return value;
    }

    private int getValueWidth(long x) {
        return 64 - Long.numberOfLeadingZeros(x);
    }
}

