/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.timerangeiterator;

import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.db.utils.timerangeiterator.AggrWindowIterator;
import org.apache.iotdb.db.utils.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public class PreAggrWindowWithNaturalMonthIterator
implements ITimeRangeIterator {
    private static final int HEAP_MAX_SIZE = 100;
    private final boolean isAscending;
    private final TimeSelector timeBoundaryHeap;
    private final AggrWindowIterator aggrWindowIterator;
    private long curStartTimeForIterator;
    private long lastEndTime;
    private TimeRange curTimeRange;

    public PreAggrWindowWithNaturalMonthIterator(long startTime, long endTime, long interval, long slidingStep, boolean isAscending, boolean isSlidingStepByMonth, boolean isIntervalByMonth) {
        this.isAscending = isAscending;
        this.timeBoundaryHeap = new TimeSelector(100, isAscending);
        this.aggrWindowIterator = new AggrWindowIterator(startTime, endTime, interval, slidingStep, isAscending, isSlidingStepByMonth, isIntervalByMonth);
        this.initHeap();
    }

    @Override
    public TimeRange getFirstTimeRange() {
        long retStartTime = this.timeBoundaryHeap.pollFirst();
        this.lastEndTime = this.timeBoundaryHeap.first();
        return new TimeRange(retStartTime, this.lastEndTime);
    }

    @Override
    public boolean hasNextTimeRange() {
        if (this.curTimeRange == null) {
            this.curTimeRange = this.getFirstTimeRange();
            return true;
        }
        if (this.lastEndTime >= this.curStartTimeForIterator) {
            this.tryToExpandHeap();
        }
        if (this.timeBoundaryHeap.isEmpty()) {
            return false;
        }
        long retStartTime = this.timeBoundaryHeap.pollFirst();
        if (retStartTime >= this.curStartTimeForIterator) {
            this.tryToExpandHeap();
        }
        if (this.timeBoundaryHeap.isEmpty()) {
            return false;
        }
        this.lastEndTime = this.timeBoundaryHeap.first();
        this.curTimeRange = new TimeRange(retStartTime, this.lastEndTime);
        return true;
    }

    @Override
    public TimeRange nextTimeRange() {
        if (this.curTimeRange != null || this.hasNextTimeRange()) {
            return this.curTimeRange;
        }
        return null;
    }

    private void initHeap() {
        TimeRange firstTimeRange = this.aggrWindowIterator.nextTimeRange();
        this.timeBoundaryHeap.add(firstTimeRange.getMin());
        this.timeBoundaryHeap.add(firstTimeRange.getMax());
        this.curStartTimeForIterator = firstTimeRange.getMin();
        this.tryToExpandHeap();
    }

    private void tryToExpandHeap() {
        TimeRange timeRangeToExpand = null;
        while (this.aggrWindowIterator.hasNextTimeRange() && this.timeBoundaryHeap.size() < 100) {
            timeRangeToExpand = this.aggrWindowIterator.nextTimeRange();
            this.timeBoundaryHeap.add(timeRangeToExpand.getMin());
            this.timeBoundaryHeap.add(timeRangeToExpand.getMax());
            this.curStartTimeForIterator = timeRangeToExpand.getMin();
        }
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }
}

