/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.schema;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.db.metadata.logfile.BufferedSerializer;
import org.apache.iotdb.db.metadata.logfile.FakeCRC32Deserializer;
import org.apache.iotdb.db.metadata.logfile.SchemaLogReader;
import org.apache.iotdb.db.metadata.logfile.SchemaLogWriter;
import org.apache.iotdb.db.metadata.plan.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanDeserializer;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.SchemaRegionPlanTxtSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogParser {
    private static final Logger logger = LoggerFactory.getLogger(MLogParser.class);
    private static final String MLOG_CLI_PREFIX = "print-schema-log";
    private static final String FILE_ARGS = "f";
    private static final String FILE_NAME = "mlog file";
    private static final String OUT_ARGS = "o";
    private static final String OUT_NAME = "output txt file";
    private static final String HELP_ARGS = "help";
    private static String inputFile;
    private static String outputFile;

    public static Options createOptions() {
        Options options = new Options();
        Option opFile = Option.builder((String)FILE_ARGS).required().argName(FILE_NAME).hasArg().desc("Need to specify a binary mlog file to parse (required)").build();
        options.addOption(opFile);
        Option opOut = Option.builder((String)OUT_ARGS).required(false).argName(OUT_NAME).hasArg().desc("Could specify the output file after parse (optional)").build();
        options.addOption(opOut);
        Option opHelp = Option.builder((String)HELP_ARGS).longOpt(HELP_ARGS).hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = MLogParser.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            logger.warn("Too few params input, please check the following hint.");
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error("Parse error: {}", (Object)e.getMessage());
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption(HELP_ARGS)) {
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        try {
            MLogParser.parseBasicParams(commandLine);
            MLogParser.parseFromFile(inputFile, outputFile);
        }
        catch (Exception e) {
            logger.error("Encounter an error, because: {} ", (Object)e.getMessage());
        }
    }

    public static void parseBasicParams(CommandLine commandLine) throws ParseException {
        inputFile = MLogParser.checkRequiredArg(FILE_ARGS, FILE_NAME, commandLine);
        outputFile = commandLine.getOptionValue(OUT_ARGS);
        if (outputFile == null) {
            outputFile = "tmp.txt";
        }
    }

    public static String checkRequiredArg(String arg, String name, CommandLine commandLine) throws ParseException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            String msg = String.format("Required values for option '%s' not provided", name);
            logger.info(msg);
            logger.info("Use -help for more information");
            throw new ParseException(msg);
        }
        return str;
    }

    public static void parseFromFile(String inputFile, String outputFile) throws IOException {
        try (SchemaLogReader<ISchemaRegionPlan> mLogReader = new SchemaLogReader<ISchemaRegionPlan>(inputFile, new FakeCRC32Deserializer<ISchemaRegionPlan>(new SchemaRegionPlanDeserializer()));
             SchemaLogWriter<ISchemaRegionPlan> mLogTxtWriter = new SchemaLogWriter<ISchemaRegionPlan>(outputFile, new BufferedSerializer<ISchemaRegionPlan>(new SchemaRegionPlanTxtSerializer()), false);){
            while (mLogReader.hasNext()) {
                ISchemaRegionPlan plan = mLogReader.next();
                mLogTxtWriter.write(plan);
            }
            mLogTxtWriter.force();
        }
    }
}

