/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk.metadata;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.DiskChunkLoader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class MemChunkMetadataLoader
implements IChunkMetadataLoader {
    private final TsFileResource resource;
    private final PartialPath seriesPath;
    private final QueryContext context;
    private final Filter timeFilter;

    public MemChunkMetadataLoader(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter timeFilter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.timeFilter = timeFilter;
    }

    public List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        List<IChunkMetadata> chunkMetadataList = this.resource.getChunkMetadataList(this.seriesPath);
        chunkMetadataList.forEach(chunkMetadata -> {
            if (chunkMetadata.needSetChunkLoader()) {
                chunkMetadata.setFilePath(this.resource.getTsFilePath());
                chunkMetadata.setClosed(this.resource.isClosed());
                chunkMetadata.setChunkLoader((IChunkLoader)new DiskChunkLoader(this.context.isDebug()));
            }
        });
        List<ReadOnlyMemChunk> memChunks = this.resource.getReadOnlyMemChunk(this.seriesPath);
        if (memChunks != null) {
            for (ReadOnlyMemChunk readOnlyMemChunk : memChunks) {
                if (memChunks.isEmpty()) continue;
                chunkMetadataList.add(readOnlyMemChunk.getChunkMetaData());
            }
        }
        chunkMetadataList.removeIf(chunkMetaData -> this.timeFilter != null && !this.timeFilter.satisfyStartEndTime(chunkMetaData.getStartTime(), chunkMetaData.getEndTime()) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
        for (IChunkMetadata metadata : chunkMetadataList) {
            metadata.setVersion(this.resource.getVersion());
        }
        return chunkMetadataList;
    }
}

