/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.planner.SubPlanTypeExtractor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.IPartitionRelatedNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PlanFragment {
    private final PlanFragmentId id;
    private PlanNode planNodeTree;
    private TypeProvider typeProvider;
    private boolean isRoot;

    public PlanFragment(PlanFragmentId id, PlanNode planNodeTree) {
        this.id = id;
        this.planNodeTree = planNodeTree;
        this.isRoot = false;
    }

    public PlanFragmentId getId() {
        return this.id;
    }

    public PlanNode getPlanNodeTree() {
        return this.planNodeTree;
    }

    public void setPlanNodeTree(PlanNode planNodeTree) {
        this.planNodeTree = planNodeTree;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void setTypeProvider(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public void generateTypeProvider(TypeProvider allTypes) {
        this.typeProvider = SubPlanTypeExtractor.extractor(this.planNodeTree, allTypes);
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean root) {
        this.isRoot = root;
    }

    public String toString() {
        return String.format("PlanFragment-%s", this.getId());
    }

    public TRegionReplicaSet getTargetRegion() {
        return this.getNodeRegion(this.planNodeTree);
    }

    private TRegionReplicaSet getNodeRegion(PlanNode root) {
        if (root instanceof IPartitionRelatedNode) {
            return ((IPartitionRelatedNode)((Object)root)).getRegionReplicaSet();
        }
        for (PlanNode child : root.getChildren()) {
            TRegionReplicaSet result = this.getNodeRegion(child);
            if (result == null || result == DataPartition.NOT_ASSIGNED) continue;
            return result;
        }
        return null;
    }

    public PlanNode getPlanNodeById(PlanNodeId nodeId) {
        return this.getPlanNodeById(this.planNodeTree, nodeId);
    }

    private PlanNode getPlanNodeById(PlanNode root, PlanNodeId nodeId) {
        if (root.getPlanNodeId().equals(nodeId)) {
            return root;
        }
        for (PlanNode child : root.getChildren()) {
            PlanNode node = this.getPlanNodeById(child, nodeId);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.id.serialize(byteBuffer);
        this.planNodeTree.serialize(byteBuffer);
        if (this.typeProvider == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.typeProvider.serialize(byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.id.serialize(stream);
        this.planNodeTree.serialize(stream);
        if (this.typeProvider == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.typeProvider.serialize(stream);
        }
    }

    public static PlanFragment deserialize(ByteBuffer byteBuffer) {
        PlanFragment planFragment = new PlanFragment(PlanFragmentId.deserialize(byteBuffer), PlanFragment.deserializeHelper(byteBuffer));
        byte hasTypeProvider = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (hasTypeProvider == 1) {
            planFragment.setTypeProvider(TypeProvider.deserialize(byteBuffer));
        }
        return planFragment;
    }

    public static PlanNode deserializeHelper(ByteBuffer byteBuffer) {
        PlanNode root = PlanNodeType.deserialize(byteBuffer);
        int childrenCount = byteBuffer.getInt();
        for (int i = 0; i < childrenCount; ++i) {
            root.addChild(PlanFragment.deserializeHelper(byteBuffer));
        }
        return root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanFragment that = (PlanFragment)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.planNodeTree, that.planNodeTree);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.planNodeTree);
    }
}

