/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.execution.exchange.ISinkHandle;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.mpp.execution.timer.RuleBasedTimeSliceAllocator;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;

public class LocalExecutionPlanContext {
    private final FragmentInstanceContext instanceContext;
    private final List<PartialPath> paths;
    private final Map<String, Set<String>> allSensorsMap;
    private final List<DataSourceOperator> sourceOperators;
    private final long dataRegionTTL;
    private ISinkHandle sinkHandle;
    private int nextOperatorId = 0;
    private final TypeProvider typeProvider;
    private List<Pair<TimeValuePair, Binary>> cachedLastValueAndPathList;
    private Filter lastQueryTimeFilter;
    private boolean needUpdateLastCache;
    private final RuleBasedTimeSliceAllocator timeSliceAllocator;

    public LocalExecutionPlanContext(TypeProvider typeProvider, FragmentInstanceContext instanceContext, long dataRegionTTL) {
        this.typeProvider = typeProvider;
        this.instanceContext = instanceContext;
        this.paths = new ArrayList<PartialPath>();
        this.allSensorsMap = new HashMap<String, Set<String>>();
        this.sourceOperators = new ArrayList<DataSourceOperator>();
        this.timeSliceAllocator = new RuleBasedTimeSliceAllocator();
        this.dataRegionTTL = dataRegionTTL;
    }

    public LocalExecutionPlanContext(FragmentInstanceContext instanceContext) {
        this.instanceContext = instanceContext;
        this.paths = new ArrayList<PartialPath>();
        this.allSensorsMap = new HashMap<String, Set<String>>();
        this.sourceOperators = new ArrayList<DataSourceOperator>();
        this.typeProvider = null;
        this.timeSliceAllocator = new RuleBasedTimeSliceAllocator();
        this.dataRegionTTL = Long.MAX_VALUE;
    }

    public int getNextOperatorId() {
        return this.nextOperatorId++;
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public Set<String> getAllSensors(String deviceId, String sensorId) {
        Set allSensors = this.allSensorsMap.computeIfAbsent(deviceId, k -> new HashSet());
        allSensors.add(sensorId);
        return allSensors;
    }

    public List<DataSourceOperator> getSourceOperators() {
        return this.sourceOperators;
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public void addSourceOperator(DataSourceOperator sourceOperator) {
        this.sourceOperators.add(sourceOperator);
    }

    public void setLastQueryTimeFilter(Filter lastQueryTimeFilter) {
        this.lastQueryTimeFilter = lastQueryTimeFilter;
    }

    public void setNeedUpdateLastCache(boolean needUpdateLastCache) {
        this.needUpdateLastCache = needUpdateLastCache;
    }

    public void addCachedLastValue(TimeValuePair timeValuePair, String fullPath) {
        if (this.cachedLastValueAndPathList == null) {
            this.cachedLastValueAndPathList = new ArrayList<Pair<TimeValuePair, Binary>>();
        }
        this.cachedLastValueAndPathList.add((Pair<TimeValuePair, Binary>)new Pair((Object)timeValuePair, (Object)new Binary(fullPath)));
    }

    public List<Pair<TimeValuePair, Binary>> getCachedLastValueAndPathList() {
        return this.cachedLastValueAndPathList;
    }

    public ISinkHandle getSinkHandle() {
        return this.sinkHandle;
    }

    public void setSinkHandle(ISinkHandle sinkHandle) {
        Objects.requireNonNull(sinkHandle, "sinkHandle is null");
        Preconditions.checkArgument((this.sinkHandle == null ? 1 : 0) != 0, (Object)"There must be at most one SinkNode");
        this.sinkHandle = sinkHandle;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public RuleBasedTimeSliceAllocator getTimeSliceAllocator() {
        return this.timeSliceAllocator;
    }

    public FragmentInstanceContext getInstanceContext() {
        return this.instanceContext;
    }

    public Filter getLastQueryTimeFilter() {
        return this.lastQueryTimeFilter;
    }

    public boolean isNeedUpdateLastCache() {
        return this.needUpdateLastCache;
    }

    public long getDataRegionTTL() {
        return this.dataRegionTTL;
    }
}

